/*
 * Decompiled with CFR 0.152.
 */
package com.zehon.scp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.zehon.exception.FileTransferException;
import com.zehon.scp.Profile;
import com.zehon.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SCPClient {
    private String serverName;
    private String username;
    private String password;
    private static final Log log = LogFactory.getLog(SCPClient.class);

    public SCPClient() {
    }

    public SCPClient(String serverName, String username, String password) {
        this.setServerName(serverName);
        this.setUsername(username);
        this.setPassword(password);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private boolean validate() {
        if (this.getServerName() == null || this.getUsername() == null || this.getPassword() == null) {
            log.warn((Object)"++++++++++++PLEASE SET THE servername, username and password, if they're null set them to empty string++++++");
            return false;
        }
        return true;
    }

    public int sendFile(String localFilePath, String scpDestFolder, String newFileName) throws FileTransferException {
        SCPClient.scpTo(this.getServerName(), this.getUsername(), this.getPassword(), localFilePath, FileUtils.getFilePath(scpDestFolder, newFileName, false));
        return 1;
    }

    public int getFile(String remoteFileName, String scpFolder, String toLocalFolder) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        SCPClient.scpFrom(this.getServerName(), this.getUsername(), this.getPassword(), FileUtils.getFilePath(scpFolder, remoteFileName, false), toLocalFolder);
        return 1;
    }

    public static void scpFrom(String host, String user, String password, String remoteFile, String localFolderFile) throws FileTransferException {
        FileOutputStream fos = null;
        try {
            int c;
            String rfile = remoteFile;
            String lfile = localFolderFile;
            String prefix = null;
            if (new File(lfile).isDirectory()) {
                prefix = lfile + File.separator;
            }
            JSch jsch = new JSch();
            Session session = jsch.getSession(user, host, 22);
            Profile ui = new Profile();
            ui.setPassword(password);
            session.setUserInfo((UserInfo)ui);
            session.connect();
            String command = "scp -f " + rfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = SCPClient.checkAckFrom(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(prefix == null ? lfile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                SCPClient.checkAckFrom(in);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
            session.disconnect();
            SCPClient.checkAckFrom(in);
        }
        catch (Exception e) {
            throw new FileTransferException(e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    static int checkAckFrom(InputStream in) throws IOException, FileTransferException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                throw new FileTransferException("Error when acknowledging response from the server. ");
            }
            if (b == 2) {
                throw new FileTransferException("Fatal Error when acknowledging response from the server.");
            }
        }
        return b;
    }

    public static void scpTo(String host, String user, String password, String localFile, String remoteFile) throws FileTransferException {
        FileInputStream fis = null;
        try {
            int len;
            String lfile = localFile;
            String rfile = remoteFile;
            JSch jsch = new JSch();
            Session session = jsch.getSession(user, host, 22);
            Profile ui = new Profile();
            ui.setPassword(password);
            session.setUserInfo((UserInfo)ui);
            session.connect();
            String command = "scp -p -t " + rfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            SCPClient.checkAckTo(in);
            long filesize = new File(lfile).length();
            command = "C0644 " + filesize + " ";
            command = lfile.lastIndexOf(47) > 0 ? command + lfile.substring(lfile.lastIndexOf(47) + 1) : command + lfile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            SCPClient.checkAckTo(in);
            fis = new FileInputStream(lfile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            SCPClient.checkAckTo(in);
            out.close();
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            throw new FileTransferException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    static int checkAckTo(InputStream in) throws IOException, FileTransferException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                throw new FileTransferException("Error when acknowledging response from the server. ");
            }
            if (b == 2) {
                throw new FileTransferException("Fatal Error when acknowledging response from the server. ");
            }
        }
        return b;
    }
}

