/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.MachineInfo;
import com.intersys.classes.FileBinaryStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.Database;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class CacheFileLoader {
    public static String sendFile(Database database, String string) throws CacheException, IOException {
        String string2 = new File(string).getName();
        com.intersys.classes.File file = CacheFileLoader.createTempFile(database, string2);
        FileReader fileReader = new FileReader(string);
        CacheFileLoader.transfer(fileReader, file);
        return file.get_name();
    }

    public static String sendStream(Database database, Reader reader) throws CacheException, IOException {
        String string = MachineInfo.getExeName();
        com.intersys.classes.File file = CacheFileLoader.createTempFile(database, string);
        CacheFileLoader.transfer(reader, file);
        return file.get_name();
    }

    public static void recieveFile(Database database, String string, String string2) throws CacheException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        FileBinaryStream fileBinaryStream = new FileBinaryStream(database);
        fileBinaryStream._linkToFile(string);
        CacheFileLoader.transfer(new CacheInputStream(fileBinaryStream), fileOutputStream);
    }

    public static void removeFile(Database database, String string) throws CacheException {
        com.intersys.classes.File.delete(database, string);
    }

    private static void transfer(Reader reader, com.intersys.classes.File file) throws CacheException, IOException {
        int n;
        file.open("WSN");
        char[] cArray = new char[16000];
        while ((n = reader.read(cArray)) >= 0) {
            String string = new String(cArray, 0, n);
            file._write(string);
        }
        file.close();
    }

    private static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = inputStream.available();
        if (n2 < 1) {
            n2 = 16000;
        } else {
            int n3 = (int)Runtime.getRuntime().freeMemory() / 2;
            if (n3 > 1024000) {
                n3 = 1024000;
            }
            if (n2 > n3) {
                n2 = n3;
            }
        }
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
    }

    public static String createTempFileName(Database database, String string) throws CacheException {
        return CacheFileLoader.createTempFile(database, string).get_name();
    }

    public static com.intersys.classes.File createTempFile(Database database, String string) throws CacheException {
        long l;
        String string2;
        int n = string.lastIndexOf(46);
        do {
            l = System.currentTimeMillis() % 10000L;
        } while (com.intersys.classes.File.exists(database, string2 = n > 0 ? string.substring(0, n) + l + string.substring(n) : string + l));
        com.intersys.classes.File file = new com.intersys.classes.File(database);
        file.set_name(string2);
        return file;
    }
}

