/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import java.io.PrintStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WeakValuesHashMap
extends HashMap {
    public static final Object TERMINATE = new Object();
    public static final Object REPORT = new Object();
    private boolean mProfileOn = false;
    private int mCollisions = 0;
    private int mWeakRemoves = 0;
    private ReferenceQueue mQueue = new ReferenceQueue();

    public static Map create(boolean bl) {
        WeakValuesHashMap weakValuesHashMap = new WeakValuesHashMap();
        if (bl) {
            weakValuesHashMap.setProfileOn();
        }
        return Collections.synchronizedMap(weakValuesHashMap);
    }

    private WeakValuesHashMap() {
        new Janitor().start();
    }

    public Object get(Object object) {
        WeakReference weakReference = (WeakReference)super.get(object);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    public Object put(Object object, Object object2) {
        if (object == TERMINATE) {
            this.close();
            return null;
        }
        if (object == REPORT) {
            this.dumpReport((PrintStream)object2);
        }
        Ref ref = new Ref(object2, object);
        return super.put(object, ref);
    }

    public Object remove(Object object) {
        WeakReference weakReference = (WeakReference)super.remove(object);
        Object t = weakReference.get();
        if (weakReference != null) {
            weakReference.clear();
        }
        return t;
    }

    public void dumpReport(PrintStream printStream) {
        printStream.println("Weak removes/collisions:  " + this.mWeakRemoves + "/" + this.mCollisions);
    }

    public void setProfileOn() {
        this.mProfileOn = true;
    }

    private Object superRemove(Object object) {
        return super.remove(object);
    }

    private boolean check(Object object, Object object2) {
        Object v = super.get(object);
        return object2 == v;
    }

    public void close() {
        this.clear();
        this.mQueue = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class Janitor
    extends Thread {
        public Janitor() {
            this.setDaemon(true);
        }

        public void run() {
            while (WeakValuesHashMap.this.mQueue != null) {
                try {
                    Ref ref = (Ref)WeakValuesHashMap.this.mQueue.remove(10L);
                    if (ref == null) continue;
                    if (WeakValuesHashMap.this.check(ref.key, ref)) {
                        WeakValuesHashMap.this.superRemove(ref.key);
                        if (!WeakValuesHashMap.this.mProfileOn) continue;
                        WeakValuesHashMap.this.mWeakRemoves++;
                        continue;
                    }
                    if (!WeakValuesHashMap.this.mProfileOn) continue;
                    WeakValuesHashMap.this.mCollisions++;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private class Ref
    extends WeakReference {
        public Object key;

        public Ref(Object object, Object object2) {
            super(object, WeakValuesHashMap.this.mQueue);
            this.key = object2;
        }
    }
}

