/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.JBindCacheField;
import com.intersys.cache.jbind.JBindCacheObject;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.classes.ObjectHandle;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import java.sql.Date;

public class JBindFieldHelper {
    public static Object getRO(CacheField cacheField, SysDatabase sysDatabase, int n) throws CacheException {
        CacheObject cacheObject = sysDatabase.getCacheObjectUnsafe(null, n);
        if (cacheObject == null) {
            throw new CacheException("Oref " + n + " is invalid");
        }
        return JBindFieldHelper.get(cacheField, cacheObject);
    }

    public static Object getRW(CacheField cacheField, SysDatabase sysDatabase, int n) throws CacheException {
        JBindCacheObject jBindCacheObject = ((JBindDatabase)sysDatabase).find(n);
        if (jBindCacheObject == null) {
            throw new CacheException("Oref " + n + " is invalid");
        }
        return JBindFieldHelper.get(cacheField, jBindCacheObject);
    }

    public static Object get(CacheField cacheField, SysDatabase sysDatabase, Object object) throws CacheException {
        if (object instanceof ObjectHandle) {
            CacheObject cacheObject = ((ObjectHandle)object).getProxy();
            return JBindFieldHelper.get(cacheField, cacheObject);
        }
        if (object instanceof Integer) {
            if (sysDatabase instanceof JBindDatabase) {
                return JBindFieldHelper.getRW(cacheField, sysDatabase, (Integer)object);
            }
            if (sysDatabase instanceof ReadOnlyDatabase) {
                return JBindFieldHelper.getRO(cacheField, sysDatabase, (Integer)object);
            }
        }
        throw new CacheException("Can not get field value on object of type " + object.getClass().getName());
    }

    private static Object get(CacheField cacheField, CacheObject cacheObject) throws CacheException {
        CacheObject cacheObject2;
        boolean bl = CacheModifier.isLiteral(cacheField.getModifiers());
        int n = bl ? 0 : 1;
        Dataholder dataholder = cacheObject.getProperty(cacheField.getII(), cacheField.getJJ(), n, cacheField.getName());
        if (bl) {
            if (cacheField instanceof JBindCacheField) {
                int n2 = ((JBindCacheField)cacheField).getJavaTypeDHType();
                return dataholder.getObject(n2);
            }
            if (bl) {
                return dataholder.getObject(cacheField.getJavaTypeName());
            }
        }
        if ((cacheObject2 = dataholder.getCacheObject()) == null) {
            return null;
        }
        return cacheObject2.newJavaInstance(true);
    }

    public static void set(CacheField cacheField, CacheObject cacheObject, Object object) throws CacheException {
        int n;
        Dataholder dataholder = null;
        int n2 = n = CacheModifier.isLiteral(cacheField.getModifiers()) ? 0 : 1;
        if (n == 1 && object instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object;
            dataholder = new Dataholder(1026, objectHandle.getProxy());
        } else if (Date.class.getName().endsWith(cacheField.getJavaTypeName())) {
            dataholder = Dataholder.create(object);
            dataholder = new Dataholder(64, dataholder.getDate());
        } else {
            dataholder = Dataholder.create(object);
        }
        cacheObject.setProperty(cacheField.getII(), cacheField.getJJ(), cacheField.getKK(), n, cacheField.getName(), dataholder);
    }

    public static void set(CacheField cacheField, SysDatabase sysDatabase, int n, Object object) throws CacheException {
        JBindCacheObject jBindCacheObject = ((JBindDatabase)sysDatabase).find(n);
        if (jBindCacheObject == null) {
            throw new CacheException("Oref " + n + " is invalid");
        }
        JBindFieldHelper.set(cacheField, jBindCacheObject, object);
    }

    public static void set(CacheField cacheField, SysDatabase sysDatabase, Object object, Object object2) throws CacheException {
        if (object instanceof ObjectHandle) {
            CacheObject cacheObject = ((ObjectHandle)object).getProxy();
            JBindFieldHelper.set(cacheField, cacheObject, object2);
            return;
        }
        if (object instanceof Integer) {
            JBindFieldHelper.set(cacheField, sysDatabase, (Integer)object, object2);
            return;
        }
        throw new CacheException("Can not set field value for object of type " + object.getClass().getName());
    }
}

