/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.Map;

public class ZObjValReader {
    protected static final int MAX_ZOBJVAL_NODE = 6;
    protected byte[][] mZobjval;
    protected Map mValueMap;
    protected Oid mOid;

    public ZObjValReader(Map map, Oid oid) {
        this.mValueMap = map;
        this.mOid = oid;
    }

    public ZObjValReader(byte[][] byArray) {
        this.mZobjval = byArray;
    }

    private byte[] getAt(int n) {
        return this.mZobjval[n - 1];
    }

    public boolean isSwizzled(int n, int n2) throws CacheException {
        Object object;
        byte[] byArray = null;
        if (this.mValueMap != null) {
            object = (Dataholder)this.mValueMap.get(new Integer(n));
            if (object == null) {
                return false;
            }
            if (n2 > 0) {
                byArray = ((Dataholder)object).getBinary();
            }
            if (n2 <= 0) {
                return !ZObjValReader.isObjNull(n2, (Dataholder)object);
            }
        }
        if (byArray == null) {
            byArray = this.getAt(n);
        }
        try {
            object = SysListProxy.createSysList(byArray, false);
            if (SysListProxy.atEnd(object)) {
                return false;
            }
            if (n2 < 1) {
                return false;
            }
            if (n2 > 1) {
                if (!SysListProxy.skip(object, n2 - 1)) {
                    return false;
                }
                if (SysListProxy.atEnd(object)) {
                    return false;
                }
            }
            return Dataholder.isSwizzled(object);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Bad data in cache for nodes [" + n + ';' + n2 + "]");
        }
    }

    public Dataholder getProperty(int n, int n2) throws CacheException {
        Object object;
        byte[] byArray = null;
        if (this.mValueMap != null) {
            object = (Dataholder)this.mValueMap.get(new Integer(n));
            if (n2 <= 0) {
                switch (n2) {
                    case 0: {
                        return object;
                    }
                }
                throw new SystemError("Unsupported jj value: " + n2);
            }
            if (object == null) {
                return null;
            }
            byArray = ((Dataholder)object).getBinary();
        } else {
            byArray = this.getAt(n);
        }
        try {
            object = SysListProxy.createSysList(byArray, false);
            Object object2 = SysListProxy.getWrappedItem(object, n2 - 1);
            return new Dataholder(4096, object2);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Bad data in cache for nodes [" + n + ';' + n2 + "]");
        }
    }

    protected void setCachedObject(int n, int n2, Dataholder dataholder) {
        if (this.mValueMap == null) {
            return;
        }
        if (n2 != 0) {
            return;
        }
        this.mValueMap.put(new Integer(n), dataholder);
    }

    public Oid getOid() {
        return this.mOid;
    }

    protected Map getValueMap() {
        return this.mValueMap;
    }

    private static final boolean isObjNull(int n, Dataholder dataholder) throws CacheException {
        switch (n) {
            case 0: {
                switch (dataholder.getType()) {
                    case 2: 
                    case 4: 
                    case 6: 
                    case 15: 
                    case 512: 
                    case 4096: {
                        int n2 = ZObjValReader.getOrefFromDataholder(dataholder);
                        return n2 == 0;
                    }
                    case 1026: {
                        return false;
                    }
                }
                byte[] byArray = dataholder.getBinary();
                return byArray == null || byArray.length == 0;
            }
        }
        throw new SystemError("Unsupported jj value: " + n);
    }

    private static int getOrefFromDataholder(Dataholder dataholder) throws CacheException {
        String string = dataholder.getString();
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(64);
        if (n >= 0) {
            return Integer.parseInt(string.substring(0, n));
        }
        return Integer.parseInt(string);
    }

    public String toString() {
        if (this.mZobjval != null) {
            return super.toString();
        }
        String string = this.mOid != null ? this.mOid.toString() + ": " : "";
        return string + this.mValueMap.toString();
    }
}

