/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jdbcutil;

import com.intersys.jdbc.CacheConnection;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionUtils {
    private static final int DEFAULT_PORT = 1972;

    public static String convert_old_url(String string) {
        if (string.substring(0, 8).compareTo("cn_iptcp") != 0) {
            return string;
        }
        int n = string.indexOf(":");
        int n2 = string.indexOf(91, n);
        int n3 = string.indexOf(93, n2);
        int n4 = string.indexOf(58, n3);
        String string2 = "jdbc:Cache://" + string.substring(n + 1, n2) + ":" + string.substring(n2 + 1, n3) + "/" + string.substring(n4 + 1);
        return string2;
    }

    public static final boolean determineStatisticsUsage() throws CacheException {
        String string = System.getProperty("com.intersys.cache.statistics");
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new CacheException("Invalid statistics usage property in system properties: " + string);
    }

    public static final boolean determineObsoleteProtocolOK() throws CacheException {
        String string = System.getProperty("com.intersys.cache.ObsoleteProtocolOK");
        if (string == null) {
            return true;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new CacheException("Invalid ObsoleteProtocolOK property in system properties: " + string);
    }

    public static boolean determineCacheOnClose() throws CacheException {
        String string = System.getProperty("com.intersys.cache.CacheOnClose");
        if (string == null) {
            return true;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new CacheException("Invalid CacheOnClose property in system properties: " + string);
    }

    public static int determineUpdateUserClasses() throws CacheException {
        String string = System.getProperty("com.intersys.classes.update.user");
        int n = 1;
        if (string != null) {
            if (string.equalsIgnoreCase("true") || string.equals("1")) {
                n = 1;
            } else if (string.equalsIgnoreCase("false") || string.equals("0")) {
                n = 0;
            } else if (string.equalsIgnoreCase("nocheck") || string.equals("-1")) {
                n = -1;
            } else {
                throw new CacheException("Invalid value for property com.intersys.classes.update.user: " + string);
            }
        }
        return n;
    }

    public static final Boolean determineTcpNoDelay() throws CacheException {
        String string = System.getProperty("com.intersys.tcp.TCP_NODELAY");
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("true")) {
            return new Boolean(true);
        }
        if (string.equalsIgnoreCase("false")) {
            return new Boolean(false);
        }
        throw new CacheException("Invalid TCP_NODELAY property in system properties: " + string);
    }

    public static final int determinePort() throws CacheException {
        String string = System.getProperty("com.intersys.port");
        if (string == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CacheException("Invalid default port specified in system properties: " + string);
        }
        if (n == 1972) {
            return 0;
        }
        return n;
    }

    public static final int determineCacheType() throws CacheException {
        String string = System.getProperty("com.intersys.cache.type");
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("DEFAULT")) {
            return 1;
        }
        if (string.equalsIgnoreCase("ANT")) {
            return 1;
        }
        if (string.equalsIgnoreCase("LAZY")) {
            return 2;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return 0;
        }
        throw new CacheException("Invalid cache type property in system properties: " + string);
    }

    public static String createURLString(String string) throws CacheException {
        int n;
        int n2;
        String string2 = ConnectionUtils.convert_old_url(string);
        int n3 = string2.indexOf(47, (n2 = string2.indexOf(47, (n = string2.indexOf("//")) + 2)) + 1);
        if (n3 > 0 && n3 < string2.length() - 1) {
            Logger.setConnectionLog(string2.substring(n3 + 1));
        } else {
            String string3 = Logger.getConnectionLog();
            if (string3 != null) {
                string2 = string2 + "/" + string3;
            }
        }
        int n4 = ConnectionUtils.determinePort();
        if (n4 != 0) {
            String string4 = String.valueOf(1972);
            n = string2.indexOf(string4);
            n2 = n + string4.length();
            if (n > 0 && string2.charAt(n - 1) == ':' && string2.charAt(n2) == '/') {
                String string5 = String.valueOf(n4);
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.replace(n, n2, string5);
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    public static CacheConnection staticInitConnection(String string, String string2, String string3) throws CacheException {
        try {
            Class.forName("com.intersys.jdbc.CacheDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheServerException("Can not find Cache JDBC driver");
        }
        if (string2 == null) {
            string2 = "_SYSTEM";
        }
        if (string3 == null) {
            string3 = "SYS";
        }
        Properties properties = new Properties();
        properties.setProperty("user", string2);
        properties.setProperty("password", string3);
        Boolean bl = ConnectionUtils.determineTcpNoDelay();
        if (bl != null) {
            properties.setProperty("TCP_NODELAY", bl.toString());
        }
        try {
            Connection connection = DriverManager.getConnection(string, properties);
            return (CacheConnection)connection;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to connect to URL: " + string);
        }
        catch (ClassCastException classCastException) {
            throw new CacheException(classCastException, "Obtained connection is not an intstance of com.intersys.jdbc.CacheConnection");
        }
    }

    public static boolean processCloseDatabase(Object object, int n, long l) {
        if (n > 0) {
            if (Logger.debugOn()) {
                Logger.out.println("Decreased ref count for Database " + l + ": " + object.toString() + " it is now " + n);
            }
            return false;
        }
        if (Logger.debugOn()) {
            Logger.out.println("Closing Database " + l + ": " + object.toString());
        }
        return true;
    }

    public static void processErrorOnConnectionClose(Exception exception, Object object, long l) {
        if (Logger.debugOn()) {
            Logger.out.println("Error closing database " + l + ": " + object.toString() + " on connection close " + "notification.");
            Logger.out.println("EXCEPTION: " + exception.getMessage());
        }
    }
}

