/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.CacheElementMetadataImpl;
import com.intersys.cache.metadata.TableMetadataFromPropertyImpl;
import com.intersys.classes.Compiler.LG.JavaColumnDef;
import com.intersys.classes.Compiler.LG.JavaPropDef;
import com.intersys.classes.Dictionary.CompiledProperty;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.SList;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.TypeModifierHelper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

abstract class CacheFieldMetadataImpl
extends CacheElementMetadataImpl
implements Comparable,
CacheField {
    private JavaPropDef mJavaPropDef;
    private CacheClassMetadataImpl mClass;
    private TableMetadata mTableMetadata;
    private boolean mTableMetadataInit = false;
    private int mII;
    private int mJJ;
    private int mKK;
    private String mChildTableName;
    private SQLColumn mSQLColumn = null;
    private int mHasSQLColumn = -1;
    private String mInverseFieldName;
    private String[] mValueList = null;
    private String[] mDisplayList = null;
    private String mGetAccessorName;
    private String mDeclaredType;
    private String mGetter;
    private Boolean mIsRequired = null;
    private int mFieldModifiers;
    private final int IS_CHILD_TABLE = 1;
    private final int IS_CALCULATED = 2;
    private final int IS_SQL_COMPUTED = 4;
    private final int HAS_GET = 8;
    private final int HAS_SET = 16;
    private final int HAS_GET_AS_METHOD = 32;
    private final int HAS_SET_AS_METHOD = 64;
    private final int DEFINED_GET = 128;
    private final int DEFINED_SET = 256;
    private final int IS_TRANSIENT = 512;

    protected abstract SQLColumn createColumn(CacheFieldMetadataImpl var1, JavaColumnDef var2) throws CacheException;

    public CacheFieldMetadataImpl(CacheClassMetadataImpl cacheClassMetadataImpl, JavaPropDef javaPropDef) throws CacheException {
        super(cacheClassMetadataImpl, javaPropDef.getjprop(), javaPropDef.getprop());
        this.mClass = cacheClassMetadataImpl;
        this.mJavaPropDef = javaPropDef;
        this.mName = this.mElemDef.getname();
        this.mJavaName = this.mJElemDef.getname();
        if (this.mJavaName == null) {
            this.mJavaName = this.mName;
        }
        this.mDeclaredType = cacheClassMetadataImpl.lookupName(this.mJavaPropDef.getDeclaredType());
        this.mII = this.mJavaPropDef.getii();
        this.mJJ = this.mJavaPropDef.getjj();
        this.mKK = this.mJavaPropDef.getmodFlag();
        this.constructModifiers();
        this.constructTypeModifiers();
        if (this.isCollection() && this.mElemDef.getcolnElemType() != null) {
            this.mElementTypeName = cacheClassMetadataImpl.lookupName(this.mElemDef.getcolnElemType());
        }
        this.mFieldModifiers = 0;
        if (this.mJavaPropDef.getprojectsAsChildTable()) {
            this.mFieldModifiers |= 1;
        }
        if (this.mJavaPropDef.getcalculated() != 0) {
            this.mFieldModifiers |= 2;
        }
        if (this.mJavaPropDef.getsqlComputed()) {
            this.mFieldModifiers |= 4;
        }
        if (this.mJavaPropDef.gethasGet()) {
            this.mFieldModifiers |= 8;
        }
        if (this.mJavaPropDef.gethasSet()) {
            this.mFieldModifiers |= 0x10;
        }
        if (this.mJavaPropDef.gethasGetAsMtd()) {
            this.mFieldModifiers |= 0x20;
        }
        if (this.mJavaPropDef.gethasSetAsMtd()) {
            this.mFieldModifiers |= 0x40;
        }
        if (this.mJavaPropDef.getdefinedGet() != 0) {
            this.mFieldModifiers |= 0x80;
        }
        if (this.mJavaPropDef.getdefinedSet() != 0) {
            this.mFieldModifiers |= 0x100;
        }
        if (this.mJavaPropDef.getisTransient()) {
            this.mFieldModifiers |= 0x200;
        }
    }

    public CacheField cloneForColumn(SQLColumn sQLColumn, CacheClassMetadataImpl cacheClassMetadataImpl) throws CacheException {
        CacheFieldMetadataImpl cacheFieldMetadataImpl = this.cloneFor(cacheClassMetadataImpl);
        cacheFieldMetadataImpl.mSQLColumn = sQLColumn;
        cacheFieldMetadataImpl.mHasSQLColumn = 1;
        return cacheFieldMetadataImpl;
    }

    public void checkForClientName(SysDatabase sysDatabase) throws CacheException {
        String string = this.getDeclaringCacheClass().getName() + "||" + this.getName();
        CompiledProperty compiledProperty = (CompiledProperty)CompiledProperty._open((Database)sysDatabase, new Id(string));
        String string2 = compiledProperty.getClientName();
        if (string2 != null && string2.length() > 0) {
            this.mJavaName = string2;
        }
    }

    protected CacheFieldMetadataImpl cloneFor(CacheClassMetadataImpl cacheClassMetadataImpl) throws CacheException {
        CacheFieldMetadataImpl cacheFieldMetadataImpl = (CacheFieldMetadataImpl)this.mClass.createField(this.mJavaPropDef);
        cacheFieldMetadataImpl.mClass = cacheClassMetadataImpl;
        return cacheFieldMetadataImpl;
    }

    protected CacheClassMetadata getTypeInternal() throws CacheException {
        return this.mClass.getAClass(this.getTypeName());
    }

    private void constructModifiers() throws CacheException {
        boolean bl = !this.mJavaPropDef.gethasSet();
        int n = this.getII();
        if (bl && n != -1 || bl || n == -1) {
            // empty if block
        }
        if (bl) {
            this.addModifier(64);
        }
    }

    private void constructTypeModifiers() throws CacheException {
        int n = this.mJavaPropDef.getrelationshipClassifier();
        if (n == 1) {
            this.mTypeModifier |= 0x13;
        } else if (n == 2) {
            this.mTypeModifier |= 0x15;
        }
    }

    public final int getII() {
        return this.mII;
    }

    public final int getJJ() {
        return this.mJJ;
    }

    public final int getKK() {
        return this.mKK;
    }

    public boolean isChildTable() {
        return (this.mFieldModifiers & 1) != 0;
    }

    public String getChildTableName() throws CacheException {
        if (this.mChildTableName == null) {
            this.mChildTableName = this.mJavaPropDef.getchildTableName();
        }
        return this.mChildTableName;
    }

    protected void setChildTable(String string) {
        this.mChildTableName = string;
        if (string != null) {
            this.mFieldModifiers |= 1;
        }
    }

    public boolean isMappedToTable() {
        return this.mClass.isMappedToTable();
    }

    public SQLColumn getSQLColumn() {
        if (this.mHasSQLColumn == 0) {
            return null;
        }
        if (this.mHasSQLColumn == 1) {
            return this.mSQLColumn;
        }
        if (!this.mClass.isMappedToTable()) {
            this.mHasSQLColumn = 0;
            return null;
        }
        try {
            this.mHasSQLColumn = 0;
            SQLColumn[] sQLColumnArray = this.mClass.getSQLTableMetadata().getColumns();
            for (int i = 0; i < sQLColumnArray.length; ++i) {
                SQLColumn sQLColumn = sQLColumnArray[i];
                if (!sQLColumn.getFieldName().equals(this.getName())) continue;
                this.mHasSQLColumn = 1;
                this.mSQLColumn = sQLColumn;
                return sQLColumn;
            }
            return null;
        }
        catch (CacheException cacheException) {
            this.mHasSQLColumn = 0;
            return null;
        }
    }

    public String getInverseFieldName() throws CacheException {
        if (this.mInverseFieldName == null) {
            this.mInverseFieldName = this.mElemDef.getcolnElemInverse();
        }
        return this.mInverseFieldName;
    }

    public boolean isSerial() {
        return TypeModifierHelper.isSerial(this.mTypeModifier);
    }

    public String[] getDisplayList() throws CacheException {
        if (this.mDisplayList == null) {
            SList sList = null;
            sList = this.mElemDef.getdisplayList();
            if (sList != null) {
                Object[] objectArray = sList.toArray();
                this.mDisplayList = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    this.mDisplayList[i] = objectArray[i] == null ? "" : (String)objectArray[i];
                }
            } else {
                this.mDisplayList = new String[0];
            }
        }
        return this.mDisplayList;
    }

    public String[] getValueList() throws CacheException {
        if (this.mValueList == null) {
            SList sList = this.mElemDef.getvalueList();
            if (sList != null) {
                Object[] objectArray = sList.toArray();
                this.mValueList = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    this.mValueList[i] = objectArray[i] == null ? "" : (String)objectArray[i];
                }
            } else {
                this.mValueList = new String[0];
            }
        }
        return this.mValueList;
    }

    public boolean isCalculated() {
        return (this.mFieldModifiers & 2) != 0;
    }

    public boolean isSQLComputed() {
        return (this.mFieldModifiers & 4) != 0;
    }

    public boolean hasGet() {
        return (this.mFieldModifiers & 8) != 0;
    }

    public boolean hasSet() {
        return (this.mFieldModifiers & 0x10) != 0;
    }

    public boolean hasGetAsMethod() {
        return (this.mFieldModifiers & 0x20) != 0;
    }

    public boolean hasSetAsMethod() {
        return (this.mFieldModifiers & 0x40) != 0;
    }

    public boolean definedGet() {
        return (this.mFieldModifiers & 0x80) != 0;
    }

    public boolean definedSet() {
        return (this.mFieldModifiers & 0x100) != 0;
    }

    public int compareTo(Object object) {
        if (object instanceof String) {
            return this.getName().compareTo((String)object);
        }
        CacheFieldMetadataImpl cacheFieldMetadataImpl = (CacheFieldMetadataImpl)object;
        return this.getName().compareTo(cacheFieldMetadataImpl.getName());
    }

    public String getGetAccessorName() throws CacheException {
        if (this.mGetAccessorName == null) {
            this.mGetAccessorName = this.mClass.lookupName(this.mJElemDef.getAccessorName());
        }
        return this.mGetAccessorName;
    }

    public String getDeclaredType() {
        return this.mDeclaredType;
    }

    public String getGetter() throws CacheException {
        if (this.mGetter == null) {
            this.mGetter = this.mJavaPropDef.getGetter();
        }
        return this.mGetter;
    }

    public boolean isRequired() throws CacheException {
        if (this.mIsRequired == null) {
            this.mIsRequired = this.serverSupportsIsRequired() ? new Boolean(this.mJavaPropDef.getisRequired()) : new Boolean(this.isLiteral());
        }
        return this.mIsRequired;
    }

    private final boolean serverSupportsIsRequired() throws CacheException {
        SysDatabase sysDatabase = this.mClass.getDatabase();
        return sysDatabase.getReflectionVersion() > 11;
    }

    public CacheClass getDeclaringCacheClass() {
        return this.mClass;
    }

    public boolean isTransient() {
        boolean bl;
        boolean bl2 = bl = (this.mFieldModifiers & 0x200) != 0;
        if (!bl) {
            return bl;
        }
        if (this.mName.equals("%Version")) {
            try {
                boolean bl3 = this.mClass.isVersionControlEnabled();
                return !bl3;
            }
            catch (CacheException cacheException) {
                throw new IllegalStateException("Failed to determine if version checking is enabled for class " + this.mClass.getName() + ". Caused by: " + cacheException.getMessage());
            }
        }
        return bl;
    }

    protected final SQLColumn[] checkColumns() throws CacheException {
        List list = this.mJavaPropDef.getchildTableColumns();
        if (list != null) {
            Object[] objectArray = new SQLColumn[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                JavaColumnDef javaColumnDef = (JavaColumnDef)iterator.next();
                objectArray[n] = this.createColumn(this, javaColumnDef);
                ++n;
            }
            Arrays.sort(objectArray);
            return objectArray;
        }
        return new SQLColumn[0];
    }

    public final synchronized TableMetadata getChildTableMetadata() throws CacheException {
        if (!this.mTableMetadataInit) {
            this.createTableMetadata();
        }
        return this.mTableMetadata;
    }

    private synchronized void createTableMetadata() throws CacheException {
        this.mTableMetadataInit = true;
        if (this.getChildTableName() != null && !this.getChildTableName().equals("")) {
            if (this.isRelationship()) {
                String string = this.getElementTypeName();
                CacheClass cacheClass = this.mClass.getDatabase().getCacheClass(string);
                this.mTableMetadata = cacheClass.getSQLTableMetadata();
            } else {
                this.mTableMetadata = new TableMetadataFromPropertyImpl(this, this.mJavaPropDef);
                ((TableMetadataFromPropertyImpl)this.mTableMetadata).init();
            }
        } else {
            this.mTableMetadata = null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheFieldMetadataImpl)) {
            return false;
        }
        CacheFieldMetadataImpl cacheFieldMetadataImpl = (CacheFieldMetadataImpl)object;
        return this.mName.equals(cacheFieldMetadataImpl.mName) && (this.mTypeName == null && cacheFieldMetadataImpl.mTypeName == null || this.mTypeName != null && this.mTypeName.equals(cacheFieldMetadataImpl.mTypeName)) && this.getDeclaringCacheClass().getName().equals(cacheFieldMetadataImpl.getDeclaringCacheClass().getName());
    }

    public int hashCode() {
        return this.mName.hashCode() + this.getDeclaringCacheClass().getName().hashCode();
    }
}

