/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.CacheObject;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.CacheJavaClassMapping;
import com.intersys.cache.metadata.SysClasses;
import com.intersys.classes.CacheGeneric;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SerialObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class JavaClassController
implements CacheJavaClassMapping,
SysClasses {
    private Class mJavaClass = null;
    private Class mSysJavaClass = null;
    private Constructor mJavaConstructor = null;
    private boolean mVerified = false;
    private CacheClass mMetadata;
    private SysDatabase mDB;

    public JavaClassController(SysDatabase sysDatabase, CacheClass cacheClass) {
        this.mMetadata = cacheClass;
        this.mDB = sysDatabase;
    }

    public JavaClassController(SysDatabase sysDatabase, CacheClass cacheClass, boolean bl) {
        this(sysDatabase, cacheClass);
        this.mVerified = !bl;
    }

    public synchronized Class getJavaClass() throws CacheException {
        if (this.mJavaClass == null) {
            this.setJavaClass(this.mMetadata.getJavaClassName(), false);
        }
        return this.mJavaClass;
    }

    public synchronized Class getJavaClass(boolean bl) throws CacheException {
        if (this.mJavaClass == null) {
            this.setJavaClass(this.mMetadata.getJavaClassName(), bl);
        }
        return this.mJavaClass;
    }

    public void setJavaClass(String string, boolean bl) throws CacheException {
        if (this.mJavaClass != null) {
            throw new SystemError("Attempt to change java class name.");
        }
        this.mDB.addClass(this.mMetadata, string);
        ClassLoader classLoader = this.mDB.getClassLoader();
        ClassNotFoundException classNotFoundException = null;
        try {
            this.mJavaClass = classLoader == null ? Class.forName(string) : Class.forName(string, false, classLoader);
            if (ObjectHandle.class.isAssignableFrom(this.mJavaClass)) {
                this.setSysJavaClass(string);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        if (!bl) {
            throw new CacheException(classNotFoundException, "Unable to find Java class for Cache class " + this.mMetadata.getName());
        }
        this.mJavaClass = this.mMetadata.isPersistent() ? Persistent.class : (this.mMetadata.isSerial() ? SerialObject.class : RegisteredObject.class);
    }

    public boolean isJavaClassSet() {
        return this.mJavaClass != null;
    }

    public Object openObject(Id id) throws CacheException {
        CacheObject cacheObject = this.mDB.openCacheObject(this.mMetadata.getName(), id.toString());
        return this.newInstance(cacheObject, true);
    }

    public Object openObject(Oid oid) throws CacheException {
        CacheObject cacheObject = this.mDB.openCacheObject(this.mMetadata.getName(), oid.getData());
        return this.newInstance(cacheObject, true);
    }

    public Object openByKey(CandidateKey candidateKey) throws CacheException {
        CacheObject cacheObject = this.mDB.openByKey(this.mMetadata.getName(), candidateKey, -1);
        return this.newInstance(cacheObject, true);
    }

    public Object newInstance(String string) throws CacheException {
        this.getJavaClass(true);
        CacheObject cacheObject = this.mDB.newCacheObject(this.mMetadata.getName(), string);
        return this.newInstance(cacheObject, true);
    }

    public Object newInstance(CacheObject cacheObject) throws CacheException {
        return this.newInstance(cacheObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(CacheObject cacheObject, boolean bl) throws CacheException {
        if (this.mMetadata.isExternallyMapped()) {
            Object object = cacheObject.getZRef();
            Object object2 = this.mDB.getExternalObject(object);
            if (object2 == null) {
                throw new CacheException("Externally mapped object of class " + this.mMetadata.getName() + " and handle " + object + " not found.");
            }
            return object2;
        }
        Constructor constructor = this.getJavaConstructor(bl);
        try {
            Object[] objectArray = this;
            synchronized (this) {
                if (!this.mVerified) {
                    this.verifyClass();
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                constructor.setAccessible(true);
                objectArray = new Object[]{cacheObject};
                Object t = constructor.newInstance(objectArray);
                return t;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new CacheException(throwable, "Exception during call to invoke of " + this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SystemError(illegalAccessException, "Exception during call to invoke of " + this);
        }
        catch (InstantiationException instantiationException) {
            throw new SystemError(instantiationException, "Exception during call to invoke of " + this);
        }
    }

    public final boolean isVerified() {
        return this.mVerified;
    }

    public void verifyClass() throws CacheException {
        block5: {
            if (Logger.debugOn()) {
                Logger.out.println("Loading class " + this.mMetadata.getName() + "[" + this.mMetadata.getJavaClassName() + "]");
            }
            try {
                CacheGeneric.checkFieldsLimited(this.mDB, this.mMetadata.getName(), this.getSysJavaClass());
            }
            catch (IllegalAccessException illegalAccessException) {
                if (Logger.debugOn()) {
                    Logger.out.println("Exception occured while verifying class " + this.mMetadata.getName() + ". Class unverified.");
                    illegalAccessException.printStackTrace(Logger.out);
                }
            }
            catch (SecurityException securityException) {
                if (!Logger.debugOn()) break block5;
                Logger.out.println("Exception occured while verifying class " + this.mMetadata.getName() + ". Class unverified.");
                securityException.printStackTrace(Logger.out);
            }
        }
        this.mVerified = true;
    }

    private synchronized Class getSysJavaClass() throws CacheException {
        if (this.mJavaClass == null) {
            this.setJavaClass(this.mMetadata.getJavaClassName(), false);
        }
        if (this.mSysJavaClass == null) {
            return this.mJavaClass;
        }
        return this.mSysJavaClass;
    }

    private void setSysJavaClass(String string) throws ClassNotFoundException {
        if (Arrays.binarySearch(SYS_CLASSES, string) < 0) {
            return;
        }
        string = "com.intersys.classes.Sys" + string.substring(SYS_CLASSES_NAME_POS);
        this.mSysJavaClass = Class.forName(string);
    }

    private Constructor getJavaConstructor(boolean bl) throws CacheException {
        if (this.mJavaConstructor == null) {
            try {
                Class clazz = this.getJavaClass(bl);
                Class[] classArray = new Class[]{CacheObject.class};
                this.mJavaConstructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SystemError(noSuchMethodException, "Exception during call to invoke of " + this);
            }
        }
        return this.mJavaConstructor;
    }
}

