/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.CacheObject;
import com.intersys.cache.CodeStream;
import com.intersys.cache.CodeStreamColn;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.AbstractCacheClass;
import com.intersys.cache.metadata.MetaMetaField;
import com.intersys.cache.metadata.SysClasses;
import com.intersys.classes.CPPStoredProc;
import com.intersys.classes.CacheGeneric;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.StringHolder;
import com.intersys.objects.SysListHolder;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassInfo;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheForeignKeyInfo;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Iterator;

public class MetaMetaClass
implements CacheClass,
SysClasses {
    private String mName;
    private String mJavaName;
    private Class mJavaClass = null;
    private Constructor mJavaConstructor = null;
    private SysDatabase mDB;
    private CacheField[] mFields;
    private boolean mVerified;
    private static boolean VERIFIED = false;

    public MetaMetaClass(SysDatabase sysDatabase, String string) {
        this.mName = string;
        this.mVerified = false;
        this.mDB = sysDatabase;
    }

    public String getName() {
        return this.mName;
    }

    public CacheField[] getFields() {
        return this.mFields;
    }

    public Object newInstance(CacheObject cacheObject) throws CacheException {
        return this.newInstance(cacheObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(CacheObject cacheObject, boolean bl) throws CacheException {
        Constructor constructor = this.getJavaConstructor();
        try {
            Object[] objectArray = this;
            synchronized (this) {
                if (!this.mVerified) {
                    this.verifyClass();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                constructor.setAccessible(true);
                objectArray = new Object[]{cacheObject};
                Object t = constructor.newInstance(objectArray);
                return t;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new CacheException(throwable, "Exception during call to invoke of " + this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SystemError(illegalAccessException, "Exception during call to invoke of " + this);
        }
        catch (InstantiationException instantiationException) {
            throw new SystemError(instantiationException, "Exception during call to invoke of " + this);
        }
    }

    public Object createClientObject() throws CacheException {
        throw new UnsupportedOperationException("Method createClientObject() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    private Constructor getJavaConstructor() throws CacheException {
        if (this.mJavaConstructor == null) {
            try {
                Class clazz = this.getJavaClass();
                Class[] classArray = new Class[]{CacheObject.class};
                this.mJavaConstructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SystemError(noSuchMethodException, "Exception during call to invoke of " + this);
            }
        }
        return this.mJavaConstructor;
    }

    public Class getJavaClass() throws CacheException {
        if (this.mJavaClass == null) {
            try {
                this.mJavaClass = Class.forName(this.getJavaClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SystemError(classNotFoundException, "Unable to find Java class for Cache class " + this.getName());
            }
        }
        return this.mJavaClass;
    }

    public String getJavaClassName() throws CacheException {
        if (this.mJavaName != null) {
            return this.mJavaName;
        }
        this.mJavaName = this.checkIfCollectionClassName();
        if (this.mJavaName != null) {
            return this.mJavaName;
        }
        int n = this.mName.lastIndexOf(46);
        String string = n < 0 ? this.mName : this.mName.substring(n + 1);
        this.mJavaName = this.getJavaPackage() + string;
        return this.mJavaName;
    }

    public String getJavaPackage() throws CacheException {
        if (this.mName.startsWith("%Library")) {
            return "com.intersys.classes.";
        }
        if (this.mName.startsWith("%Dictionary")) {
            return "com.intersys.classes.Dictionary.";
        }
        if (this.mName.equals(CodeStreamColn.getCacheClassName())) {
            return CodeStreamColn.class.getPackage().getName() + ".";
        }
        if (this.mName.equals(CodeStream.getCacheClassName())) {
            return CodeStream.class.getPackage().getName() + ".";
        }
        if (this.mName.startsWith("%Compiler.LG")) {
            return "com.intersys.classes.Compiler.LG.";
        }
        if (this.mName.startsWith("%Collection")) {
            return "com.intersys.classes.";
        }
        throw new SystemError("Unknown package for a metadata class: " + this.mName);
    }

    protected String checkIfCollectionClassName() {
        if (this.mName.startsWith("%Collection.ListOfDT")) {
            return "com.intersys.classes.ListOfDataTypes";
        }
        if (this.mName.startsWith("%Collection.ArrayOfDT")) {
            return "com.intersys.classes.ArrayOfDataTypes";
        }
        if (this.mName.startsWith("%Collection.ListOfObj")) {
            return "com.intersys.classes.ListOfObjects";
        }
        if (this.mName.startsWith("%Collection.ArrayOfObj")) {
            return "com.intersys.classes.ArrayOfObjects";
        }
        if (this.mName.equals("%Compiler.LG.QueryHelper")) {
            return "com.intersys.classes.ListOfObjects";
        }
        return null;
    }

    public boolean isVerified() {
        return this.mVerified;
    }

    public void verifyClass() throws CacheException {
        if (this.mVerified) {
            return;
        }
        if (VERIFIED) {
            this.mVerified = true;
            return;
        }
        try {
            MetaMetaClass.verifyAll(this.mDB, this);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not verify metadata classes.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Can not verify metadata classes. Insufficent access priviligies.");
        }
        this.mVerified = true;
    }

    private static void verifyAll(SysDatabase sysDatabase, MetaMetaClass metaMetaClass) throws CacheException, SQLException, IllegalAccessException {
        if (VERIFIED) {
            throw new SystemError("Metadata is already verified.");
        }
        VERIFIED = true;
        SysListHolder sysListHolder = new SysListHolder(null);
        CPPStoredProc.getLGMeta(sysDatabase, sysListHolder, new StringHolder(null));
        byte[] byArray = sysListHolder.value.getData();
        Object object = SysListProxy.createSysList(byArray);
        while (!SysListProxy.atEnd(object)) {
            MetaMetaClass metaMetaClass2;
            String string = SysListProxy.getString(object);
            int n = SysListProxy.getInteger(object);
            if (metaMetaClass.getName().equals(string)) {
                metaMetaClass2 = metaMetaClass;
            } else {
                boolean bl;
                CacheClass cacheClass = sysDatabase.getCacheClassIfLoaded(string);
                if (cacheClass instanceof AbstractCacheClass) {
                    if (Logger.debugOn()) {
                        Logger.out.println("Metadata for " + string + " is instanceof " + cacheClass.getClass().getName());
                    }
                    SysListProxy.skip(object, n * 2);
                    continue;
                }
                try {
                    metaMetaClass2 = (MetaMetaClass)cacheClass;
                }
                catch (ClassCastException classCastException) {
                    throw new SystemError("Metadata for " + string + " is instanceof " + cacheClass.getClass().getName());
                }
                boolean bl2 = bl = metaMetaClass2 != null;
                if (!bl) {
                    metaMetaClass2 = new MetaMetaClass(sysDatabase, string);
                }
                try {
                    metaMetaClass2.getJavaClass();
                }
                catch (CacheException cacheException) {
                    SysListProxy.skip(object, n * 2);
                    continue;
                }
                if (!bl) {
                    sysDatabase.addClass(metaMetaClass2, null);
                }
            }
            metaMetaClass2.mFields = new CacheField[n];
            for (int i = 0; i < n; ++i) {
                String string2 = SysListProxy.getString(object);
                int n2 = SysListProxy.getInteger(object);
                metaMetaClass2.mFields[i] = new MetaMetaField(string2, n2);
            }
            CacheGeneric.checkMetadataFields(metaMetaClass2);
            metaMetaClass2.mVerified = true;
        }
    }

    public void close() {
    }

    public Object newInstance(String string) throws CacheException {
        throw new UnsupportedOperationException("Method newInstance() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public Object openObject(Id id) throws CacheException {
        throw new UnsupportedOperationException("Method openObject() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public Object openObject(Oid oid) throws CacheException {
        throw new UnsupportedOperationException("Method openObject() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public void deleteObject(Id id) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKey createKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKey createKey(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKey createBestCandidateKey() throws CacheException {
        throw new UnsupportedOperationException("Method createBestCandidateKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKey createPrimaryKey() throws CacheException {
        throw new UnsupportedOperationException("Method createPrimaryKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKey createPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createPrimaryKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public Object openByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public Object openByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean deleteObjectByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean deleteObjectByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByPrimaryKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public int getClassTypeId() {
        throw new UnsupportedOperationException("Method getClassTypeId() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean hasDeleteIdMethod() {
        throw new UnsupportedOperationException("Method hasDeleteIdMethod() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean hasExistsIdMethod() {
        throw new UnsupportedOperationException("Method hasExistsIdMethod() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean hasOpenIdMethod() {
        throw new UnsupportedOperationException("Method hasOpenIdMethod() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean hasOpenMethod() {
        throw new UnsupportedOperationException("Method hasOpenMethod() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isChild() {
        throw new UnsupportedOperationException("Method isChild() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getParentClassName() {
        throw new UnsupportedOperationException("Method getParentClassName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheSerialStorageMetadata getSerialStateInfo() {
        throw new UnsupportedOperationException("Method getSerialStateInfo() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getSchemaName() {
        throw new UnsupportedOperationException("Method getSchemaName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public int getRowIdJDBCCode() {
        throw new UnsupportedOperationException("Method getRowIdJDBCCode() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isExternallyMapped() throws CacheException {
        return false;
    }

    public CacheField getParentField() throws CacheException {
        throw new UnsupportedOperationException("Method getParentField() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getFullSQLTableName() {
        throw new UnsupportedOperationException("Method getSQLTableName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getSQLTableName() {
        throw new UnsupportedOperationException("Method getSQLTableName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getIdPlaceholder() {
        throw new UnsupportedOperationException("Method getIdPlaceholder() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean eagerFetchRequiredForPOJO() throws CacheException {
        throw new UnsupportedOperationException("Method eagerFetchRequiredForPOJO() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getPackageName() {
        throw new UnsupportedOperationException("Method getPackageName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheMethod[] getMethods() throws CacheException {
        throw new UnsupportedOperationException("Method getMethods() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheQueryDefinition[] getQueries() throws CacheException {
        throw new UnsupportedOperationException("Method getQueries() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public Iterator getFieldNames() throws CacheException {
        throw new UnsupportedOperationException("Method getFieldNames() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public Iterator getMethodSignatures() throws CacheException {
        throw new UnsupportedOperationException("Method getMethodSignatures() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheField getField(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getField() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheMethod getMethod(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getMethod() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheMethod getMethod(String string, CacheClassInfo[] cacheClassInfoArray) throws CacheException {
        throw new UnsupportedOperationException("Method getMethod() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheQueryDefinition getQuery(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getQuery() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheClass getSuperclass() throws CacheException {
        throw new UnsupportedOperationException("Method getSuperclass() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheClass[] getCacheSuperclasses() throws CacheException {
        throw new UnsupportedOperationException("Method getCacheSuperclasses() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isAssignableFrom(CacheClassInfo cacheClassInfo) throws CacheException {
        throw new UnsupportedOperationException("Method isAssignableFrom() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public int getModifiers() {
        throw new UnsupportedOperationException("Method getModifiers() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isPersistent() throws CacheException {
        throw new UnsupportedOperationException("Method isPersistent() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isSerial() throws CacheException {
        throw new UnsupportedOperationException("Method isSerial() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isDatatype() {
        throw new UnsupportedOperationException("Method isDatatype() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public boolean isAbstract() {
        throw new UnsupportedOperationException("Method isAbstract() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public TableMetadata getSQLTableMetadata() {
        throw new UnsupportedOperationException("Method getChildTableMetadata() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheField[] getDeclaredFields() throws CacheException {
        throw new UnsupportedOperationException("Method getDeclaredFields() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKeyInfo[] getAvailableCandidateKeys() throws CacheException {
        throw new UnsupportedOperationException("Method getAvailableCandidateKeys() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKeyInfo getBestCandidateKey() throws CacheException {
        throw new UnsupportedOperationException("Method getBestCandidateKey() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CandidateKeyInfo getKeyInfo(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getKeyInfo() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public SQLColumn[] getSQLColumns() throws CacheException {
        throw new UnsupportedOperationException("Method getSQLColumns() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getJavaImplements() {
        throw new UnsupportedOperationException("Method getJavaImplements() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getJavaInterfaceName() throws CacheException {
        throw new UnsupportedOperationException("Method getJavaInterfaceName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public String getJavaPojoName() throws CacheException {
        throw new UnsupportedOperationException("Method getJavaPojoName() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheIndexInfo[] getIndexInfo() throws CacheException {
        throw new UnsupportedOperationException("Method getIndexInfo() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }

    public CacheForeignKeyInfo[] getForeignKeyInfo() throws CacheException {
        throw new UnsupportedOperationException("Method getForeignKeyInfo() is not implemented in class com.intersys.cache.metadata.MetaMetaClass");
    }
}

