/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickRelationshipObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.SerialStorage;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.Persistent;
import com.intersys.classes.PersistentWrapper;
import com.intersys.classes.RegisteredObject;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.TypeModifierHelper;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuickPersistentObject
extends QuickCacheObject
implements Mappings {
    private Object mFieldValues;
    private Object[] mCachedValues;
    private int mLoadMethod;
    protected boolean inSave = false;

    public QuickPersistentObject(TableBasedClass tableBasedClass) {
        super(tableBasedClass);
        this.mLoadMethod = 7503;
        this.mCachedValues = new Object[tableBasedClass.getNumberOfCachedElements()];
        this.mState = 65282;
    }

    public QuickPersistentObject(TableBasedClass tableBasedClass, Object object, int n) {
        super(tableBasedClass);
        this.mLoadMethod = n;
        if (Logger.getDebugCache()) {
            Logger.out.println("Loaded object: ");
            QuickPersistentObject.logData(object);
        }
        this.mFieldValues = object;
        this.mCachedValues = new Object[tableBasedClass.getNumberOfCachedElements()];
        this.mState = 65281;
    }

    public Id getId() throws CacheException {
        String string = this.getProperty(this.mClass.getIdField()).getString();
        if (string == null) {
            return null;
        }
        return new Id(string);
    }

    public Oid getOid() throws CacheException {
        String string = this.getProperty(this.mClass.getIdField()).getString();
        if (string == null) {
            return null;
        }
        return new Oid(string, this.mClass.getName());
    }

    public void forceClose() throws CacheException {
        super.forceClose();
        this.mFieldValues = null;
        this.mState |= 0xFF02;
    }

    public synchronized int save(boolean bl) throws CacheException {
        Object object = ((LightDatabase)this.getDatabase()).createSysList();
        this.save(object, false, bl);
        return 1;
    }

    public synchronized int save(Object object, boolean bl, boolean bl2) throws CacheException {
        Object object2;
        Object object3;
        if (this.inSave) {
            if (bl) {
                try {
                    SysListProxy.setInteger(object, 0);
                }
                catch (SQLException sQLException) {
                    throw new SystemError("Failed to set number of columns");
                }
            }
            if (this.getId() != null) {
                if (bl) {
                    return 0;
                }
                return 1;
            }
            try {
                if (!bl) {
                    SysListProxy.setInteger(object, 0);
                }
            }
            catch (SQLException sQLException) {
                throw new SystemError("Failed to set number of columns");
            }
            int n = ((LightDatabase)this.getDatabase()).create(this.mClass, object);
            this.setProperty(this.mClass.getIdField(), new Dataholder(n), false);
            if (bl) {
                return 0;
            }
            return 1;
        }
        this.inSave = true;
        boolean bl3 = false;
        int n = this.mClass.isChild() ? 2 : 1;
        try {
            SysListProxy.setInteger(object, this.mClass.getNumberOfColumnsForSet() - n);
        }
        catch (SQLException sQLException) {
            throw new SystemError("Failed to set number of columns");
        }
        boolean bl4 = false;
        Object object4 = null;
        int n2 = 0;
        Object object5 = this.mClass.getAllSettableFieldsIterator();
        while (object5.hasNext()) {
            try {
                object3 = (ColumnBasedField)object5.next();
                if (n2 != object3.getColumnIndexForSet()) {
                    throw new SystemError("Expected column " + n2 + ", instead got " + object3.getColumnIndexForSet());
                }
                if (n2 != this.mClass.getIdField().getColumnIndexForSet()) {
                    Dataholder dataholder;
                    object2 = this.mCachedValues[n2];
                    if ("%Version".equals(object3.getName())) {
                        if (object2 == null) {
                            object2 = this.getProperty((ColumnBasedField)object3);
                        }
                        if (object2 != null && object2 instanceof Dataholder && (dataholder = (Dataholder)object2).getObject() != null && dataholder.getLongValue() < 0L) {
                            object2 = Dataholder.create(null);
                        }
                    }
                    if ((object2 = this.valueToSave((ColumnBasedField)object3, object2, bl2)) == null) {
                        if (!object3.isChildTable()) {
                            SysListProxy.setUndefined(object);
                        }
                    } else {
                        bl4 = true;
                        if (object2 instanceof Dataholder && (dataholder = (Dataholder)object2).getObject() == null) {
                            object2 = null;
                        }
                        if (object2 == UNCHANGED) {
                            bl3 = true;
                            if (!object3.isChildTable()) {
                                throw new SystemError("Unexpected value.");
                            }
                        } else if (this.mClass.isChild() && n2 == ((ColumnBasedField)this.mClass.getParentField()).getColumnIndexForSet()) {
                            if (!object3.isObject()) {
                                throw new SystemError("Reference class expected  for parent column: class: " + this.mClass.getName() + ", column: " + object3.getName());
                            }
                            object4 = object2;
                        } else {
                            SysListProxy.setObject(object, object2);
                            this.mCachedValues[n2] = UNCHANGED;
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to set value to col #" + n2 + " for Object of class " + this.mClass.getName() + "; id = " + this.getId());
            }
            ++n2;
        }
        if (bl) {
            this.inSave = false;
            if (!bl4) {
                return 0;
            }
            if (bl3) {
                return 2;
            }
            return 1;
        }
        object5 = (LightDatabase)this.getDatabase();
        object3 = this.getProperty(this.mClass.getIdField());
        if (((Dataholder)object3).getObject() == null && this.mFieldValues == null) {
            if (this.mClass.isChild()) {
                object2 = ((LightDatabase)object5).createChild(this.mClass, object4, object);
                object3 = new Dataholder((String)object2);
            } else {
                int n3 = ((LightDatabase)object5).create(this.mClass, object);
                object3 = new Dataholder(n3);
                this.setId((Dataholder)object3);
            }
            bl4 = true;
        } else if (bl4) {
            ((LightDatabase)object5).save(this.getOid(), object);
        }
        this.inSave = false;
        if (bl3) {
            this.setId((Dataholder)object3);
            this.save(bl2);
        }
        if (bl4) {
            this.invalidate((Dataholder)object3);
        }
        return 1;
    }

    protected Iterator getAllProperties() throws CacheException {
        HashMap<String, Dataholder> hashMap = new HashMap<String, Dataholder>(this.mClass.getNumberOfColumnsForSet());
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            Dataholder dataholder;
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField == null || columnBasedField.getColumnIndexForGet() <= 0 || columnBasedField.equals(this.mClass.getIdField()) || (dataholder = this.getProperty(columnBasedField)) == null) continue;
            hashMap.put(columnBasedField.getName(), dataholder);
        }
        return hashMap.entrySet().iterator();
    }

    protected void objectDeleted() throws CacheException {
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField.getColumnIndexForSet() == 0) continue;
            Dataholder dataholder = this.getProperty(columnBasedField);
            this.setProperty(columnBasedField, dataholder, false);
        }
        this.setId(Dataholder.create(null));
        this.mFieldValues = null;
        this.mState |= 0xFF02;
    }

    protected void setId(Dataholder dataholder) throws CacheException {
        String string;
        ColumnBasedField columnBasedField = this.mClass.getIdField();
        String string2 = this.mClass.getName();
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        Dataholder dataholder2 = this.getProperty(columnBasedField);
        if (dataholder2 != null && dataholder2.equals(dataholder)) {
            return;
        }
        if (dataholder2 != null && (string = dataholder2.getString()) != null) {
            lightDatabase.removeFromMap(string2, string);
        }
        this.setProperty(columnBasedField, dataholder, false);
        if (dataholder != null) {
            lightDatabase.addToMap(this, null, string2, dataholder.getString());
        }
    }

    protected void invalidate(Dataholder dataholder) throws CacheException {
        if (dataholder == null) {
            dataholder = this.getProperty(this.mClass.getIdField());
        }
        this.mFieldValues = null;
        for (int i = 0; i < this.mCachedValues.length; ++i) {
            this.mCachedValues[i] = null;
        }
        this.setProperty(this.mClass.getIdField(), dataholder, false);
        this.mState |= 0xFF02;
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        ColumnBasedField columnBasedField = this.mClass.getField(string, n, n2);
        return this.getProperty(columnBasedField);
    }

    protected Dataholder getProperty(ColumnBasedField columnBasedField) throws CacheException {
        ColumnBasedField columnBasedField2;
        int n;
        Dataholder dataholder;
        int n2 = columnBasedField.getColumnIndexForSet();
        Object object = this.mCachedValues[n2];
        if (object != null && object != UNCHANGED) {
            return (Dataholder)object;
        }
        if (this.mFieldValues == null && (dataholder = (Dataholder)this.mCachedValues[n = (columnBasedField2 = this.mClass.getIdField()).getColumnIndexForSet()]) != null && dataholder.getObject() != null) {
            this.mFieldValues = ((LightDatabase)this.getDatabase()).loadObject(dataholder.getString(), this.mClass);
            this.mLoadMethod = 7502;
            this.mState |= 0xFF01;
        }
        int n3 = columnBasedField.getColumnIndexForGet();
        if (columnBasedField.isEmbedded()) {
            object = this.getEmbeddedObject(columnBasedField);
        } else {
            if (n3 < 0 && columnBasedField.getChildTableName() == null) {
                throw new CacheException("Property " + columnBasedField.getName() + " of class " + this.mClass.getName() + " can not be accessed " + "with Quick interface");
            }
            if (this.mFieldValues == null && columnBasedField.getCollectionType() != 0) {
                object = SerialStorage.newCollection(columnBasedField);
            } else if (this.mFieldValues == null) {
                object = new Dataholder();
            } else {
                if (columnBasedField.isCollection() || columnBasedField.isStream()) {
                    try {
                        object = this.getCollection(columnBasedField);
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException, "Failed to get collection or stream for field " + columnBasedField.getName());
                    }
                }
                if (columnBasedField.isObject()) {
                    object = this.getReferenceObject(columnBasedField, n3);
                } else {
                    try {
                        Object object2 = SysListProxy.getWrappedItem(this.mFieldValues, n3 - 1);
                        object = new Dataholder(4096, object2);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        arrayIndexOutOfBoundsException.printStackTrace();
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException, "Failed to get property " + columnBasedField.getName());
                    }
                }
            }
        }
        this.mCachedValues[n2] = object;
        return (Dataholder)object;
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        ColumnBasedField columnBasedField = this.mClass.getField(string, n, n2);
        this.setProperty(columnBasedField, dataholder, true);
    }

    protected void setProperty(ColumnBasedField columnBasedField, Dataholder dataholder, boolean bl) throws CacheException {
        if (bl) {
            this.mState |= 0xFF10;
        }
        if (columnBasedField.isEmbedded() && !columnBasedField.equals(this.mClass.getIdField())) {
            this.setEmbeddedObject(columnBasedField, dataholder);
        } else if (columnBasedField.getCollectionType() != 0) {
            this.setCollection(columnBasedField, dataholder);
        }
        int n = columnBasedField.getColumnIndexForSet();
        this.mCachedValues[n] = dataholder;
    }

    private void setEmbeddedObject(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        QuickEmbeddedObject quickEmbeddedObject = (QuickEmbeddedObject)dataholder.getCacheObject();
        if (!columnBasedField.isEmbeddedSetUp()) {
            this.mClass.setupEmbeddedField(columnBasedField);
        }
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        if (quickEmbeddedObject != null) {
            quickEmbeddedObject.onSetStore(this, columnBasedField, tableBasedClass);
        }
    }

    private Dataholder getReferenceObject(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string;
        try {
            string = SysListProxy.getString(this.mFieldValues, n - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not get id of object at field " + columnBasedField.getName());
        }
        if (string == null) {
            return new Dataholder();
        }
        CacheObject cacheObject = this.getDatabase().openCacheObject(columnBasedField.getTypeName(), string);
        return new Dataholder(cacheObject);
    }

    private void setCollection(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        int n = columnBasedField.getColumnIndexForSet();
        this.mCachedValues[n] = dataholder;
    }

    private Dataholder getCollection(ColumnBasedField columnBasedField) throws CacheException, SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        block47: {
            LightDatabase lightDatabase;
            object4 = null;
            int n = columnBasedField.getColumnIndexForGet();
            int n2 = columnBasedField.getCollectionType();
            String string = columnBasedField.getElementTypeName();
            String string2 = columnBasedField.getChildTableName();
            Object object5 = null;
            if (string2 == null) {
                object5 = SysListProxy.getWrappedItem(this.mFieldValues, n - 1);
            } else if (!columnBasedField.isRelationship() && !(lightDatabase = (LightDatabase)this.getDatabase()).isClassRegistered(string2)) {
                lightDatabase.createQuickCacheClass(columnBasedField);
            }
            int n3 = columnBasedField.getElementType();
            int n4 = -1;
            if (!TypeModifierHelper.isStream(n2) && n3 == 256 && string != null && !string.endsWith("String")) {
                object3 = this.getDatabase().getCacheClass(string).getJavaClassName();
                n4 = Dataholder.toIntType((String)object3);
            }
            object3 = (TableBasedClass)columnBasedField.getType();
            if (string2 != null && columnBasedField.isList()) {
                object2 = this.getListOfReferencesAsChildTable(columnBasedField, n3);
                object = new ArrayList(((ArrayList)object2).size());
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Object object6;
                    Object e = iterator.next();
                    if (e instanceof QuickStatement.ChildTableRow) {
                        QuickStatement.ChildTableRow childTableRow = (QuickStatement.ChildTableRow)e;
                        object6 = childTableRow.data;
                    } else {
                        object6 = e;
                    }
                    this.processRefListElem((List)object, columnBasedField, string, n3, n4, object6);
                }
                object4 = object;
            } else if (string2 != null && n2 == 19) {
                object2 = this.getListOfReferencesAsChildTable(columnBasedField, n3);
                object = new ArrayList(((ArrayList)object2).size());
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    QuickStatement.ChildTableRow childTableRow = (QuickStatement.ChildTableRow)e;
                    Object object7 = childTableRow.data;
                    this.processRefListElem((List)object, columnBasedField, string, n3, n4, object7);
                }
                object4 = object;
            } else if (string2 != null && n2 == 21) {
                object4 = this.getMany(columnBasedField, string);
            } else if (string2 != null && n2 == 1) {
                object2 = this.getArrayOfReferencesAsChildTable(columnBasedField, n3);
                object = new HashMap(((HashMap)object2).size());
                block15: for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                    Object object8;
                    Object object9;
                    Object object10;
                    Object object11;
                    Object v = entry.getValue();
                    if (v instanceof QuickStatement.ChildTableRow) {
                        object11 = (QuickStatement.ChildTableRow)v;
                        LightDatabase lightDatabase2 = (LightDatabase)this.getDatabase();
                        int n5 = lightDatabase2.getKeyColumn(string2);
                        object10 = n5 == 0 ? ((QuickStatement.ChildTableRow)object11).data : entry.getKey();
                        object9 = n5 == 0 ? entry.getKey() : ((QuickStatement.ChildTableRow)object11).data;
                        object8 = ((QuickStatement.ChildTableRow)object11).data;
                    } else {
                        object10 = entry.getKey();
                        object8 = object9 = v;
                    }
                    switch (n3) {
                        case 256: {
                            if (n4 > 0) {
                                object11 = Dataholder.create(object9);
                                object9 = ((Dataholder)object11).getObject(n4);
                            }
                            ((HashMap)object).put(object10, object9);
                            continue block15;
                        }
                        case 4608: {
                            object11 = object9.toString();
                            ((HashMap)object).put(object10, this.getObjectInCollection((String)object11, string));
                            continue block15;
                        }
                        case 8704: {
                            SysListProxy.rewind(object9);
                            ((HashMap)object).put(object10, this.getObjectInCollection(object8, string, string2));
                            continue block15;
                        }
                    }
                    throw new CacheException("Unsupported collection element type");
                }
                object4 = object;
            } else if (columnBasedField.isList() && this.mLoadMethod == 7506) {
                try {
                    object4 = SerialStorage.getSerialList(this.getDatabase(), string, n3, object5, n4);
                    this.mLoadMethod = 7502;
                }
                catch (Exception exception) {
                    SysListProxy.rewind(object5);
                    object4 = SerialStorage.getCommaSeparatedSerialList(this.getDatabase(), string, n3, object5, n4);
                    this.mLoadMethod = 7501;
                }
            } else {
                if (columnBasedField.isList() && this.mLoadMethod == 7502) {
                    try {
                        object4 = SerialStorage.getSerialList(this.getDatabase(), string, n3, object5, n4);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage().startsWith("Incorrect list")) {
                            SysListProxy.rewind(object5);
                            object4 = SerialStorage.getCommaSeparatedSerialList(this.getDatabase(), string, n3, object5, n4);
                        }
                        break block47;
                    }
                }
                if (columnBasedField.isList() && this.mLoadMethod == 7501) {
                    object4 = SerialStorage.getCommaSeparatedSerialList(this.getDatabase(), string, n3, object5, n4);
                } else if (n2 == 1 && this.mLoadMethod == 7501) {
                    object4 = SerialStorage.getCommaSeparatedSerialArray(this.getDatabase(), string, n3, object5, n4);
                } else if (n2 == 1 && this.mLoadMethod == 7506) {
                    try {
                        object4 = SerialStorage.getCommaSeparatedSerialArray(this.getDatabase(), string, n3, object5, n4);
                        this.mLoadMethod = 7501;
                    }
                    catch (Exception exception) {
                        object4 = SerialStorage.getSerialArray(this.getDatabase(), string, n3, object5, n4);
                        this.mLoadMethod = 7502;
                    }
                } else if (n2 == 1 && this.mLoadMethod == 7502) {
                    object4 = SerialStorage.getSerialArray(this.getDatabase(), string, n3, object5, n4);
                } else {
                    if (n2 == 32) {
                        InputStream inputStream = null;
                        try {
                            inputStream = ((LightDatabase)this.getDatabase()).getJDBCBinaryStream(object5);
                        }
                        catch (SQLException sQLException) {
                            inputStream = null;
                        }
                        QuickStreamObject quickStreamObject = new QuickStreamObject((TableBasedClass)object3, inputStream, new ByteArrayOutputStream());
                        return new Dataholder(quickStreamObject);
                    }
                    if (n2 == 64) {
                        Reader reader = ((LightDatabase)this.getDatabase()).getJDBCCharacterStream(object5);
                        QuickReaderObject quickReaderObject = new QuickReaderObject((TableBasedClass)object3, reader, new CharArrayWriter());
                        return new Dataholder(quickReaderObject);
                    }
                    throw new CacheException("Unsupported collection type: " + n2);
                }
            }
        }
        object2 = columnBasedField.isRelationship() ? new QuickRelationshipObject((TableBasedClass)object3, object4) : new QuickCollectionObject((TableBasedClass)object3, object4);
        object = new Dataholder((CacheObject)object2);
        return object;
    }

    private void processRefListElem(List list, ColumnBasedField columnBasedField, String string, int n, int n2, Object object) throws CacheException, SQLException {
        switch (n) {
            case 256: {
                if (n2 > 0) {
                    Dataholder dataholder = Dataholder.create(object);
                    object = dataholder.getObject(n2);
                }
                list.add(object);
                break;
            }
            case 4608: {
                String string2 = (String)object;
                list.add(this.getObjectInCollection(string2, string));
                break;
            }
            case 8704: {
                SysListProxy.rewind(object);
                list.add(this.getObjectInCollection(object, string, columnBasedField.getChildTableName()));
                break;
            }
            default: {
                throw new CacheException("Unsupported collection element type");
            }
        }
    }

    private List getMany(ColumnBasedField columnBasedField, String string) throws CacheException {
        ArrayList arrayList = new ArrayList();
        String string2 = columnBasedField.getInverseFieldName();
        CacheClass cacheClass = this.getDatabase().getCacheClass(string);
        CacheField cacheField = cacheClass.getField(string2);
        String string3 = cacheField.getSQLColumn().getName();
        String string4 = string3 + " = ? ";
        Object[] objectArray = new String[]{this.getId().toString()};
        Iterator iterator = ((LightDatabase)this.getDatabase()).openByQuery(string, string4, objectArray);
        Dataholder dataholder = new Dataholder(this);
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField2;
            RegisteredObject registeredObject;
            Object e = iterator.next();
            if (e instanceof PersistentWrapper) {
                registeredObject = (PersistentWrapper)e;
                columnBasedField2 = (ColumnBasedField)registeredObject.getCacheClass().getField(string2);
                ((QuickPersistentObject)registeredObject.getProxy()).setProperty(columnBasedField2, dataholder, false);
            } else {
                registeredObject = (Persistent)e;
                columnBasedField2 = (ColumnBasedField)registeredObject.getCacheClass().getField(string2);
                ((QuickPersistentObject)registeredObject.getProxy()).setProperty(columnBasedField2, dataholder, false);
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    private ArrayList getListOfReferencesAsChildTable(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string = columnBasedField.getChildTableName();
        Id id = this.getId();
        if (id == null) {
            return new ArrayList();
        }
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        ArrayList arrayList = lightDatabase.getListOfReferencesAsChildTable(string, id.toString(), 12, 12, n);
        return arrayList;
    }

    private HashMap getArrayOfReferencesAsChildTable(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string = columnBasedField.getChildTableName();
        Id id = this.getId();
        if (id == null) {
            return new HashMap();
        }
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        HashMap hashMap = lightDatabase.getArrayOfReferencesAsChildTable(string, id.toString(), 12, 12, n);
        return hashMap;
    }

    private Object getObjectInCollection(byte[] byArray, String string) throws CacheException {
        return SerialStorage.getObjectInCollection(this.getDatabase(), byArray, string);
    }

    private Object getObjectInCollection(Object object, String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = ((LightDatabase)this.getDatabase()).getCacheClass(string, string2);
        QuickPersistentObject quickPersistentObject = new QuickPersistentObject(tableBasedClass, object, 7502);
        return quickPersistentObject.newJavaInstance(true);
    }

    private Object getObjectInCollection(String string, String string2) throws CacheException {
        CacheObject cacheObject = this.getDatabase().openCacheObject(string2, string);
        return cacheObject.newJavaInstance(true);
    }

    private Dataholder getEmbeddedObject(ColumnBasedField columnBasedField) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        QuickEmbeddedObject quickEmbeddedObject = new QuickEmbeddedObject(tableBasedClass, this, columnBasedField);
        if (!columnBasedField.isEmbeddedSetUp()) {
            this.mClass.setupEmbeddedField(columnBasedField);
        }
        return new Dataholder(quickEmbeddedObject);
    }

    private static void logData(Object object) {
        try {
            SysListProxy.rewind(object);
            int n = 1;
            while (!SysListProxy.atEnd(object)) {
                Logger.out.println("\t" + n + ":\t" + SysListProxy.getObject(object));
                ++n;
            }
        }
        catch (SQLException sQLException) {
            Logger.out.println("Exception caught " + sQLException.getMessage());
        }
    }
}

