/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.ProtoMetadataFactory;
import com.intersys.cache.serial.SerialMetadataFactory;
import com.intersys.cache.util.ConnectionAnalyzer;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ThirdPartyDBMetadataFactory
extends SerialMetadataFactory
implements ProtoMetadataFactory {
    private PreparedStatement mSysStatement = null;
    private PreparedStatement mGenStatement = null;
    private PreparedStatement mTblStatement = null;
    private PreparedStatement mSeqStatement = null;
    private PreparedStatement mViewMapStatement = null;
    int mProducType = 0;
    private static final String SYS_STATEMENT = "SELECT CLASS_METADATA FROM CACHE_SYS.LG_CLASSES WHERE CLASS_NAME = ?";
    private static final String GEN_STATEMENT = "SELECT CLASS_METADATA FROM CACHE_SYS.METADATA WHERE CLASS_NAME = ?";
    private static final String MD_BY_TABLE_STATEMENT = "SELECT CLASS_METADATA FROM CACHE_SYS.METADATA WHERE TABLE_NAME = ?";
    private static final String SEQ_STATEMENT = "SELECT CLASS_SEQUENCE FROM CACHE_SYS.METADATA WHERE CLASS_NAME = ?";
    private static final String VIEW_STATEMENT = "SELECT CLASS_BASE_TABLE FROM CACHE_SYS.HIERARCHY WHERE CLASS_VIEW = ?";

    public ThirdPartyDBMetadataFactory(SysDatabase sysDatabase, Connection connection) throws SQLException {
        super(sysDatabase);
        this.mSysStatement = connection.prepareStatement(SYS_STATEMENT);
        this.mGenStatement = connection.prepareStatement(GEN_STATEMENT);
        this.mTblStatement = connection.prepareStatement(MD_BY_TABLE_STATEMENT);
        this.mSeqStatement = connection.prepareStatement(SEQ_STATEMENT);
        this.mViewMapStatement = connection.prepareStatement(VIEW_STATEMENT);
        this.mProducType = ConnectionAnalyzer.getProductType(connection);
    }

    public byte[] getSerialInfo(String string) throws SQLException {
        return this.getSerialInfo(string, true);
    }

    public byte[] getStaticDictionary() throws SQLException {
        return this.getSerialInfo("%Compiler.LG.StaticDictionary", true);
    }

    public int getMDVersion() throws SQLException {
        byte[] byArray = this.getSerialInfo("%Compiler.LG.___VERSION", true);
        int n = Integer.parseInt(new String(byArray));
        return n;
    }

    public byte[] getSerialInfo(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = bl ? this.mSysStatement : this.mGenStatement;
        return this.getSerialInfo(string, preparedStatement);
    }

    public byte[] getSerialInfo(String string, PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = resultSet.next();
        byte[] byArray = null;
        if (bl) {
            if (this.mProducType == 3) {
                Blob blob = resultSet.getBlob(1);
                long l = blob.length();
                byArray = blob.getBytes(1L, (int)l);
            } else {
                byArray = resultSet.getBytes(1);
            }
        }
        resultSet.close();
        return byArray;
    }

    public JavaClassDef getJavaClassDefByTable(String string) throws CacheException {
        return this.getJavaClassDef(string, this.mTblStatement);
    }

    public JavaClassDef getJavaClassDef(String string) throws CacheException {
        return this.getJavaClassDef(string, this.mGenStatement);
    }

    public JavaClassDef getJavaClassDef(String string, PreparedStatement preparedStatement) throws CacheException {
        byte[] byArray;
        try {
            byArray = this.getSerialInfo(string, preparedStatement);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get metadata for cache class: " + string);
        }
        if (byArray == null) {
            throw new CacheException("Metadata for cache class: " + string + " not found");
        }
        return (JavaClassDef)JavaClassDef.open((Database)this.mDB, byArray);
    }

    public String getBaseTable(String string) throws SQLException {
        this.mViewMapStatement.setString(1, string);
        ResultSet resultSet = this.mViewMapStatement.executeQuery();
        String string2 = null;
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        return string2;
    }

    public String getSequenceName(String string) throws SQLException {
        this.mSeqStatement.setString(1, string);
        ResultSet resultSet = this.mSeqStatement.executeQuery();
        String string2 = null;
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        return string2;
    }
}

