/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ConnectionAnalyzer {
    public static int getProductType(Connection connection) throws SQLException {
        int n = 0;
        if ("mysql".equalsIgnoreCase(ConnectionAnalyzer.getProductName(connection).substring(0, 5))) {
            n = 1;
        } else if ("Cache".equalsIgnoreCase(ConnectionAnalyzer.getProductName(connection).substring(0, 5))) {
            n = 2;
        } else if ("Oracle".equalsIgnoreCase(ConnectionAnalyzer.getProductName(connection).substring(0, 6))) {
            n = 3;
        } else if ("Microsoft SQL Server".equalsIgnoreCase(ConnectionAnalyzer.getProductName(connection).substring(0, 20))) {
            n = 4;
        }
        return n;
    }

    public static String getProductName(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        return databaseMetaData.getDatabaseProductName();
    }

    public static void printMetadata(Connection connection) throws SQLException {
        ResultSet resultSet;
        String string;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        System.out.println(databaseMetaData.getDatabaseProductName());
        boolean bl = databaseMetaData.supportsSchemasInTableDefinitions();
        String string2 = databaseMetaData.getSchemaTerm();
        System.out.println("Schemas supported: reproted - " + bl + "; guessed - " + (string2.length() > 0));
        boolean bl2 = databaseMetaData.supportsCatalogsInTableDefinitions();
        String string3 = databaseMetaData.getCatalogTerm();
        System.out.println("Catalogs supported: reported - " + bl2 + "; guessed - " + (string3.length() > 0));
        System.out.println("\tAt strat: " + databaseMetaData.isCatalogAtStart());
        System.out.println("\t Catalog separator: " + databaseMetaData.getCatalogSeparator());
        ResultSet resultSet2 = databaseMetaData.getCatalogs();
        System.out.println("Catalogs (" + string3 + "): ");
        while (resultSet2.next()) {
            string = resultSet2.getString(1);
            System.out.println("\t" + string);
            resultSet = databaseMetaData.getTables(string, null, null, null);
            ConnectionAnalyzer.printTables(resultSet);
        }
        resultSet2 = databaseMetaData.getSchemas();
        System.out.println("Schemas (" + string2 + "): ");
        while (resultSet2.next()) {
            string = resultSet2.getString(1);
            System.out.println("\t" + string);
            resultSet = databaseMetaData.getTables(null, string, null, null);
            ConnectionAnalyzer.printTables(resultSet);
        }
    }

    private static void printTables(ResultSet resultSet) throws SQLException {
        System.out.println("\tTables: ");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            String string4 = resultSet.getString(4);
            System.out.println("\t\t" + string + "." + string2 + "." + string3 + ": " + string4);
        }
    }
}

