/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.DatabaseWithReferenceMap;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.ArrayBuffer;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SysArrayOfObjects;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheNullValueException;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.Logger;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class ObjectArrayBuffer
extends ArrayBuffer {
    private Map mClassBuffer = null;
    private Set mUnusedOrefs = new HashSet();
    private Set mLockedOrefs = new HashSet();

    ObjectArrayBuffer(SysArrayOfObjects sysArrayOfObjects, int n) throws CacheException {
        super(sysArrayOfObjects, n);
        this.mClassBuffer = new TreeMap();
    }

    ObjectArrayBuffer(SysArrayOfObjects sysArrayOfObjects) throws CacheException {
        super(sysArrayOfObjects);
        this.mClassBuffer = new TreeMap();
    }

    protected Object dbGetAt(String string) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string)};
        Dataholder dataholder = this.mArray.runInstanceMethod("GetAt", dataholderArray, 1);
        CacheObject cacheObject = null;
        if (dataholder.getType() == 1026) {
            cacheObject = dataholder.getCacheObject();
        } else {
            Integer n = dataholder.getInteger();
            if (n == null) {
                return null;
            }
            int n2 = n;
            String string2 = RegisteredObject.getCacheClassName();
            cacheObject = this.mArray.getDatabase().getCacheObjectUnsafe(string2, n2);
        }
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.newJavaInstance(true);
    }

    protected Object getArrayBuffer(String string, int n) throws CacheException {
        this.clearUnusedOrefs(true);
        SysDatabase sysDatabase = this.mArray.getDatabase();
        Object object = sysDatabase.getObjectArrayBuffer(this.mArray.getOref(), string, this.mBufferSize, n);
        Object object2 = null;
        Object object3 = null;
        try {
            object3 = SysListProxy.createSysList();
            object2 = this.processArrayBuffer(sysDatabase, object, object3);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to process received array object buffer");
        }
        sysDatabase.processObjectBuffer(object3, object, this);
        return object2;
    }

    private Object processArrayBuffer(SysDatabase sysDatabase, Object object, Object object2) throws CacheException, SQLException {
        Object object3 = SysListProxy.getSysList(object);
        if (SysListProxy.atEnd(object3)) {
            return null;
        }
        Object object4 = SysListProxy.getSysList(object3);
        Object object5 = SysListProxy.getSysList(object3);
        int n = SysListProxy.getInteger(object4);
        while (!SysListProxy.atEnd(object4)) {
            boolean bl;
            String string = SysListProxy.getString(object4);
            int n2 = SysListProxy.getInteger(object4);
            String string2 = SysListProxy.getString(object5);
            if (n2 == 0) continue;
            if (string2 == null) {
                throw new InvalidClassException("Class can not be null");
            }
            Integer n3 = new Integer(n2);
            boolean bl2 = bl = this.mLockedOrefs.contains(n3) || sysDatabase.ensureInMap(n2, string2);
            if (!bl) {
                if (this.mUnusedOrefs.add(n3)) {
                    SysListProxy.setInteger(object2, n2);
                }
                if (Logger.getDebugReferenceCountLevel() > 0) {
                    Logger.out.println("Array Buffer: Added oref = " + n2);
                }
            } else {
                this.mLockedOrefs.add(n3);
                if (Logger.getDebugReferenceCountLevel() > 0) {
                    Logger.out.println("Array Buffer: Skipped oref = " + n2);
                }
            }
            this.mClassBuffer.put(new Integer(n2), string2);
        }
        return object4;
    }

    public void onDatabaseDestroy() throws CacheException {
        this.clearUnusedOrefs(false);
        super.onDatabaseDestroy();
    }

    public void invalidateCache(boolean bl) throws CacheException {
        this.clearUnusedOrefs(bl);
        super.invalidateCache(bl);
    }

    private void clearUnusedOrefs(boolean bl) throws CacheException {
        if (this.mUnusedOrefs.isEmpty() && this.mLockedOrefs.isEmpty()) {
            if (Logger.getDebugReferenceCountLevel() > 1) {
                Logger.out.println("Array Buffer: no orefs to remove.");
            }
            return;
        }
        DatabaseWithReferenceMap databaseWithReferenceMap = (DatabaseWithReferenceMap)this.mArray.getDatabase();
        for (Integer n : this.mUnusedOrefs) {
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println("Array Buffer: Removed oref = " + n);
            }
            databaseWithReferenceMap.decreaseServerReferenceCount(n, 1);
        }
        if (bl) {
            Iterator iterator = this.mLockedOrefs.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (Logger.getDebugReferenceCountLevel() > 1) {
                    Logger.out.println("Array Buffer: Releasing oref = " + n);
                }
                databaseWithReferenceMap.releaseEnsuredFromMap(n);
            }
        }
        this.mLockedOrefs.clear();
        this.mUnusedOrefs.clear();
        this.mClassBuffer.clear();
    }

    protected Object getFromDataholder(Dataholder dataholder) throws CacheException {
        int n = 0;
        try {
            n = dataholder.getIntValue();
        }
        catch (CacheNullValueException cacheNullValueException) {
            return null;
        }
        Integer n2 = new Integer(n);
        boolean bl = !this.mUnusedOrefs.remove(n2);
        String string = (String)this.mClassBuffer.get(new Integer(n));
        if (string == null) {
            throw new InvalidClassException("Class name is null for oref " + n + " Array: " + this.mArray);
        }
        SysDatabase sysDatabase = this.mArray.getDatabase();
        CacheObject cacheObject = sysDatabase.getCacheObjectUnsafe(string, n);
        CacheClass cacheClass = sysDatabase.getCacheClass(string);
        cacheObject.setCacheClass(cacheClass);
        ObjectHandle objectHandle = (ObjectHandle)cacheObject.newJavaInstance(true);
        return objectHandle;
    }

    public void close(boolean bl) throws CacheException {
        this.invalidateCache(bl);
        super.close(bl);
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }
}

