/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.RegisteredObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SList;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import java.util.Map;

public class Persistent
extends RegisteredObject {
    private static String CACHE_CLASS_NAME = "%Library.Persistent";
    private static int ii__Version = 2;
    private static int jj__Version = 0;
    private static int kk__Version = 2;

    public Persistent(CacheObject cacheObject) throws CacheException {
        super(cacheObject);
    }

    public static RegisteredObject _open(Database database, Oid oid) throws CacheException {
        CacheObject cacheObject = ((SysDatabase)database).openCacheObject(CACHE_CLASS_NAME, oid.getData());
        return (RegisteredObject)cacheObject.newJavaInstance();
    }

    public static RegisteredObject _open(Database database, Oid oid, int n) throws CacheException {
        CacheObject cacheObject = ((SysDatabase)database).openCacheObject(CACHE_CLASS_NAME, oid.getData(), n);
        return (RegisteredObject)cacheObject.newJavaInstance();
    }

    public Oid getOid() throws CacheException {
        return this.mInternal.getOid();
    }

    public Oid _oid() throws CacheException {
        return this.mInternal.getOid();
    }

    public Id getId() throws CacheException {
        return this.mInternal.getId();
    }

    public Id _id() throws CacheException {
        return this.mInternal.getId();
    }

    public CandidateKey getKey(String string) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CandidateKey candidateKey = cacheClass.createKey(string);
        if (candidateKey == null) {
            throw new CacheException("No key with name " + string + " is defined in class " + cacheClass.getName());
        }
        candidateKey.setFromObject(this);
        return candidateKey;
    }

    public CandidateKey getBestCandidateKey() throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CandidateKey candidateKey = cacheClass.createBestCandidateKey();
        if (candidateKey == null) {
            return null;
        }
        candidateKey.setFromObject(this);
        return candidateKey;
    }

    public int save() throws CacheException {
        boolean bl = !this.getDatabase().isLightConnection();
        return this.save(bl);
    }

    public int save(boolean bl) throws CacheException {
        int n = this.getOref();
        int n2 = this.mInternal.save(bl);
        if (n > 0 && n != this.getOref()) {
            throw new SystemError("Object closed before save completed: " + n + "/" + this.getOref());
        }
        return n2;
    }

    public int _save() throws CacheException {
        return this.save();
    }

    public static void check_VersionValid(Database database) throws CacheException {
        Persistent.checkZobjValid(database, CACHE_CLASS_NAME, "%Version", ii__Version, jj__Version, kk__Version);
    }

    public Integer get_Version() throws CacheException {
        Dataholder dataholder = this.mInternal.getProperty(ii__Version, jj__Version, 0, "%Version");
        return dataholder.getInteger();
    }

    public void set_Version(Integer n) throws CacheException {
        Dataholder dataholder = new Dataholder(n);
        this.mInternal.setProperty(ii__Version, jj__Version, kk__Version, 0, "%Version", dataholder);
    }

    public static Boolean _exists(Database database, Oid oid) throws CacheException {
        return new Boolean(Persistent.exists(database, oid));
    }

    public static boolean exists(Database database, Oid oid) throws CacheException {
        return ((SysDatabase)database).existsObject(oid);
    }

    protected static boolean exists(Database database, Oid oid, String string) throws CacheException {
        String string2 = oid.getClassName();
        if (string2 != null && !string2.equals("")) {
            return ((SysDatabase)database).existsObject(oid);
        }
        oid = new Oid(oid.getId(), string);
        return ((SysDatabase)database).existsObject(oid);
    }

    public static void _delete(Database database, Oid oid) throws CacheException {
        Persistent.delete(database, oid);
    }

    public static void delete(Database database, Oid oid) throws CacheException {
        ((SysDatabase)database).deleteObject(oid);
    }

    public void delete() throws CacheException {
        this.mInternal.delete();
    }

    public static void _delete(Database database, Oid oid, Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(oid), new Dataholder(n)};
        Dataholder dataholder = database.runClassMethod(CACHE_CLASS_NAME, "%Delete", dataholderArray, 0);
        database.parseStatus(dataholder);
    }

    public void _downgradeConcurrency(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%DowngradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _downgradeConcurrency(int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%DowngradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _upgradeConcurrency(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%UpgradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _upgradeConcurrency(int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%UpgradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _reload() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%Reload", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public static void _buildIndices(Database database) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = database.runClassMethod(CACHE_CLASS_NAME, "%BuildIndices", dataholderArray, 0);
        database.parseStatus(dataholder);
    }

    public static void _buildIndices(Database database, SList sList) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(sList)};
        Dataholder dataholder = database.runClassMethod(CACHE_CLASS_NAME, "%BuildIndices", dataholderArray, 0);
        database.parseStatus(dataholder);
    }

    public Integer JournalObject(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("JournalObject", dataholderArray, 0);
        return dataholder.getInteger();
    }

    public Integer JournalObject(Integer n, Integer n2) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n), new Dataholder(n2)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("JournalObject", dataholderArray, 0);
        return dataholder.getInteger();
    }

    public static String getCacheClassName() {
        return CACHE_CLASS_NAME;
    }

    public void attach(Object object, boolean bl) throws Exception {
        boolean bl2 = false;
        Oid oid = this.getOid();
        if (oid != null && !oid.undefined()) {
            this.registerPojo(object);
            bl2 = true;
        }
        super.attach(object, bl);
        if (!bl2) {
            this.registerPojo(object);
        }
    }

    public Object detach(boolean bl) throws Exception {
        Object object = super.detach(bl);
        this.registerPojo(object);
        return object;
    }

    protected Object detach(Map map, boolean bl) throws Exception {
        Object object = super.detach(map, bl);
        this.registerPojo(object);
        return object;
    }

    private final void registerPojo(Object object) throws CacheException {
        SysDatabase sysDatabase = (SysDatabase)this.getDatabase();
        sysDatabase.getDetachedObjectsManager().register(this, object);
    }
}

