/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.codegenerator.sql;

import com.intersys.codegenerator.java.GenFlags;
import com.intersys.codegenerator.java.Java;
import com.intersys.jdbc.QuickStatement;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.SList;
import com.intersys.objects.reflect.CacheClassMetadata;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class Generator {
    private Java mGen;
    private CacheClassMetadata mClass;
    private PrintWriter mOut;

    public Generator(Database database, String string, String string2, String string3) throws IOException, CacheException {
        String string4 = string3.replaceAll("\\.", "\\" + File.separator) + ".java";
        string4 = string2 + File.separator + string4;
        int n = string4.lastIndexOf(File.separatorChar);
        if (n > 0) {
            String string5 = string4.substring(0, n);
            new File(string5).mkdirs();
        }
        this.mOut = new PrintWriter((Writer)new FileWriter(string4), false);
        this.mGen = new Java(this.mOut, database, null, null, null, null, "/primtivedatatypes", null, new GenFlags("/primtivedatatypes", "", ""), null, false);
        this.mClass = database.getCacheClass(string);
        this.generateDeclaration(string3);
    }

    private void generateDeclaration(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            this.declarePackage(string2);
        }
        this.addImport(CacheException.class);
        this.addImport(SList.class);
        this.declareClass(string);
        this.declareMemeber("protected", QuickStatement.class, "statement");
        this.declareMemeber("protected", Object.class, "wire");
        this.mOut.println();
        this.declareMemeber("protected", String.class, "schema");
        this.declareMemeber("protected", String.class, "table");
        this.mOut.println();
        this.doConstructor(string);
    }

    public void generateBatchInsert() throws CacheException {
        this.mGen.displayBulkInsert(this.mClass);
    }

    public void generateSingleInsert(String[] stringArray) throws CacheException {
        this.mGen.displaySingleInsert(this.mClass, stringArray);
    }

    public void generateUpdate(String[] stringArray) throws CacheException {
        this.mGen.displayUpdate(this.mClass, stringArray);
    }

    public void generateLoad(String string, String[] stringArray) throws CacheException {
        this.mGen.displayLoad(this.mClass, string, stringArray);
    }

    public void flush() {
        this.mOut.println("}");
        this.mOut.flush();
        this.mOut.close();
    }

    protected void declarePackage(String string) {
        this.mOut.println("package " + string + ";");
        this.mOut.println();
    }

    protected void declareClass(String string) {
        this.mOut.println();
        this.mOut.println("public class " + string + "{");
        this.mOut.println();
    }

    protected void declareMemeber(String string, Class clazz, String string2) {
        this.mOut.print("\t");
        this.mOut.print(string + " ");
        this.mOut.print(clazz.getName() + " ");
        this.mOut.println(string2 + ";");
    }

    protected void addImport(Class clazz) {
        this.mOut.println("import " + clazz.getName() + ";");
    }

    protected void addImport(Package package_) {
        this.mOut.println("import " + package_.getName() + ".*;");
    }

    private void doConstructor(String string) {
        this.mOut.println("\tpublic " + string + " (java.sql.Connection connection, String schema, String table)");
        this.mOut.println("\t\tthrows java.sql.SQLException");
        this.mOut.println("\t{");
        this.mOut.println("\t\tthis.schema = schema;");
        this.mOut.println("\t\tthis.table = table;");
        this.mOut.println("\t\ttry");
        this.mOut.println("\t\t\t{");
        this.mOut.println("\t\t\t\tcom.intersys.jdbc.CacheConnection c = com.intersys.cache.jdbcutil.JDBCAdapter.getCacheConnection (connection);");
        this.mOut.println("\t\t\t\tstatement = c.createQuickStatement ();");
        this.mOut.println("\t\t\t\twire = com.intersys.jdbc.SysListProxy.createSysList ();");
        this.mOut.println("\t\t\t}");
        this.mOut.println("\t\tcatch (CacheException e)");
        this.mOut.println("\t\t\t{");
        this.mOut.println("\t\t\t\tthrow new java.sql.SQLException (e.getMessage ());");
        this.mOut.println("\t\t\t}");
        this.mOut.println("\t}");
        this.mOut.println("");
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "localhost";
        String string2 = "_SYSTEM";
        String string3 = "SYS";
        String string4 = "1972";
        String string5 = "SAMPLES";
        String string6 = System.getProperty("user.dir", ".");
        String string7 = "Sample.Person";
        String string8 = "sqlcommands.PersonCommands";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-host")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-port")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-namespace")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-srcdir")) {
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-outclass")) {
                string8 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-cacheclass")) {
                string7 = stringArray[++i];
                continue;
            }
            System.out.println("Unknown option: " + stringArray[i]);
            return;
        }
        String string9 = "jdbc:Cache://" + string + ":" + string4 + "/" + string5;
        Database database = CacheDatabase.getDatabase(string9, string2, string3);
        Generator generator = new Generator(database, string7, string6, string8);
        generator.generateBatchInsert();
        generator.generateSingleInsert(null);
        generator.generateSingleInsert(new String[]{"SSN", "Name", "DOB"});
        generator.generateUpdate(new String[]{"Home_Street", "Home_City", "Home_State", "Home_Zip"});
        generator.generateLoad("loadPerson", new String[]{"SSN", "Name", "DOB", "FavoriteColors"});
        generator.generateLoad("loadWithState", new String[]{"ID", "Name", "Home_State", "Home_Zip"});
        generator.flush();
    }
}

