/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.FakeStream;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.Stream;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class CacheReader
extends Reader {
    private boolean ready = false;
    private Stream stream;

    CacheReader(CacheConnection cacheConnection, String string, int n, int n2, int n3) throws SQLException {
        this.stream = new RealStream(cacheConnection, string, null, n, 4, n2, n3);
        ((RealStream)this.stream).getSize();
        if (this.stream.size > 0) {
            this.ready = true;
        }
    }

    CacheReader(CacheConnection cacheConnection, byte[] byArray) throws SQLException {
        this.stream = new RealStream(cacheConnection, null, byArray, 0, 4, -1, 0);
        ((RealStream)this.stream).getSizeOpen();
        if (this.stream.size > 0) {
            this.ready = true;
        }
    }

    CacheReader(CacheConnection cacheConnection, byte[] byArray, int n) throws SQLException {
        this.stream = new RealStream(cacheConnection, null, byArray, n, 4, -1, 0);
        ((RealStream)this.stream).getSPStreamSize();
        if (this.stream.size > 0) {
            this.ready = true;
        }
    }

    CacheReader(String string) throws SQLException {
        this.stream = new FakeStream(string.toCharArray(), 4, -1, 0);
        this.ready = true;
    }

    public boolean ready() {
        return this.ready;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) <= 0) {
            return -1;
        }
        return cArray[0];
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        if (!this.ready) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = this.stream.fetchStream(cArray, n + n4, n2 - n4)) >= 0) continue;
                if (n4 == 0) {
                    return n3;
                }
                break;
            } while ((n4 += n3) < n2);
            return n4;
        }
        catch (Exception exception) {
            throw new IOException("Unable to read stream data");
        }
    }

    protected boolean isNull() {
        return this.stream.isNull();
    }

    public void close() throws IOException {
        this.stream.close();
        this.ready = false;
    }

    protected final String toUnicodeString() throws SQLException {
        try {
            if (this.stream.size == 0) {
                return "";
            }
            char[] cArray = new char[this.stream.size];
            int n = this.read(cArray);
            return new String(cArray, 0, n);
        }
        catch (Exception exception) {
            throw new SQLException("Error read stream data " + exception.getMessage(), "S1000");
        }
    }
}

