/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class ListUtil {
    private static final int STREAM_BUF_SIZE = 32768;
    private static final int LONGDIGIT10 = 18;
    private static BigInteger[] m_bigPow10 = new BigInteger[19];
    private static final long CONGNEGD5 = 0x1999999999999999L;
    private static final long CONGNEGD10 = 0xCCCCCCCCCCCCCCCL;
    private static final int GINT = Integer.MAX_VALUE;
    private static final int GNEGI = Integer.MIN_VALUE;
    private static final long[] scaletab;
    private static final char[] tenstab;
    private static final char[] onestab;
    private static final int MAX_BYTES_IN_CHAR = 3;

    static void readTimestampb(byte[] byArray, int n, int n2, int[] nArray, int[] nArray2) throws SQLException {
        ListUtil.readDateb(byArray, n, n2, nArray);
        n2 -= 10;
        if (byArray[n += 10] != 32) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        ListUtil.readTimeb(byArray, ++n, --n2, nArray2);
    }

    static int readTimeb(byte[] byArray, int n, int n2, int[] nArray) throws SQLException {
        long[] lArray = new long[1];
        nArray[0] = ListUtil.dblint(ListUtil.parsenumb(byArray, n, n2, lArray), lArray[0]);
        n2 -= 2;
        if (byArray[n += 2] != 58) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        nArray[1] = ListUtil.dblint(ListUtil.parsenumb(byArray, ++n, --n2, lArray), lArray[0]);
        n2 -= 2;
        if (byArray[n += 2] != 58) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        nArray[2] = ListUtil.dblint(ListUtil.parsenumb(byArray, ++n, --n2, lArray), lArray[0]);
        if (nArray[0] < 0 || nArray[0] > 23) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        if (nArray[1] < 0 || nArray[1] > 59) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        if (nArray[2] < 0 || nArray[2] > 59) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        n += 2;
        if ((n2 -= 2) > 0) {
            if (byArray[n] != 46) {
                throw new SQLException("Invalid Time", "22008", 22008);
            }
            nArray[3] = ListUtil.dblint(ListUtil.parsenumb(byArray, n, n2, lArray), lArray[0] * 1000000000L);
        } else {
            nArray[3] = 0;
        }
        if (nArray[3] > 999999999 || nArray[3] < 0) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        return n;
    }

    static int readDateb(byte[] byArray, int n, int n2, int[] nArray) throws SQLException {
        long[] lArray = new long[1];
        nArray[0] = ListUtil.dblint(ListUtil.parsenumb(byArray, n, n2, lArray), lArray[0]);
        n2 -= 4;
        if (byArray[n += 4] != 45) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        nArray[1] = ListUtil.dblint(ListUtil.parsenumb(byArray, ++n, --n2, lArray), lArray[0]);
        n2 -= 2;
        if (byArray[n += 2] != 45) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        nArray[2] = ListUtil.dblint(ListUtil.parsenumb(byArray, ++n, --n2, lArray), lArray[0]);
        if (nArray[1] < 1 || nArray[1] > 12 || nArray[1] < 1) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        switch (nArray[1]) {
            case 2: {
                if (!(nArray[0] % 4 == 0 && nArray[0] % 100 != 0 || nArray[0] % 400 == 0 ? nArray[2] > 29 : nArray[2] > 28)) break;
                throw new SQLException("Invalid Date", "22008", 22008);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (nArray[2] <= 31) break;
                throw new SQLException("Invalid Date", "22008", 22008);
            }
            default: {
                if (nArray[2] <= 30) break;
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        return n;
    }

    public static String canonizeTimestampString(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            int n2 = string.length() - 1;
            while (string.charAt(n2) == '0') {
                --n2;
            }
            if (n2 == n) {
                --n2;
            }
            string = string.substring(0, n2 + 1);
        }
        return string;
    }

    public static String canonizeFloatingPointString(String string, boolean bl) {
        int n;
        string = string.replace(' ', '0');
        if (!bl) {
            string = String.valueOf(new Double(string));
        }
        if (string.charAt(0) == '-' && string.charAt(1) == '0') {
            string = new String("-") + string.substring(2);
        } else if (string.charAt(0) == '0') {
            string = string.substring(1);
        }
        if (string.lastIndexOf(69) < 0 && (n = string.length() - 1) > 0 && string.charAt(n) == '0') {
            string = n == 1 || n == 2 && string.charAt(0) == '-' ? new String("0") : (string.charAt(n - 1) == '.' ? string.substring(0, n - 1) : string.substring(0, n));
        }
        return string;
    }

    static final String scaledDecimaltoString(int n, BigInteger bigInteger) {
        StringBuffer stringBuffer;
        if (n == 0) {
            return bigInteger.toString();
        }
        String string = bigInteger.abs().toString();
        int n2 = bigInteger.signum();
        if (n > 0) {
            stringBuffer = new StringBuffer(string);
            if (n2 < 0) {
                stringBuffer.insert(0, '-');
            }
            do {
                stringBuffer.append('0');
            } while (--n > 0);
        } else {
            int n3;
            int n4;
            for (n4 = string.length(); n4 > 0 && n < 0 && string.charAt(n4 - 1) == '0'; --n4, ++n) {
            }
            if (n4 != string.length()) {
                if (n4 == 0) {
                    return "0";
                }
                string = string.substring(0, n4);
                if (n == 0) {
                    return n2 < 0 ? "-" + string : string;
                }
            }
            if ((n3 = n4 + n) == 0) {
                return (n2 < 0 ? "-." : ".") + string;
            }
            if (n3 > 0) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.insert(n3, '.');
                if (n2 < 0) {
                    stringBuffer.insert(0, '-');
                }
            } else {
                stringBuffer = new StringBuffer(-n + 2);
                stringBuffer.append(n2 < 0 ? "-." : ".");
                for (int i = 0; i < -n3; ++i) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    static BigDecimal parsedecb(byte[] byArray, int n, int n2) throws SQLException {
        long l;
        boolean bl;
        int n3;
        BigInteger bigInteger;
        int n4;
        int n5;
        block20: {
            block19: {
                n5 = 0;
                n4 = 0;
                bigInteger = null;
                n3 = n2 += n;
                bl = false;
                while (n < n3) {
                    if ((char)(l = (long)(byArray[n++] - 48)) <= '\t') break block19;
                    if (l == -3L) {
                        bl = !bl;
                        continue;
                    }
                    if (l == -2L) {
                        n5 = n;
                        break block19;
                    }
                    if (l == -5L) continue;
                }
                return BigDecimal.valueOf(0L);
            }
            if (l < 1L) {
                while (n < n3) {
                    if ((l = (long)(byArray[n++] - 48)) == -2L) {
                        if (n5 != 0) break;
                        n5 = n;
                        continue;
                    }
                    if (l == 0L) continue;
                    if ((char)l <= '\t') break block20;
                }
                return BigDecimal.valueOf(0L);
            }
        }
        int n6 = 1;
        while (n < n3) {
            char c;
            if ((c = (char)(byArray[n++] - 48)) <= '\t') {
                l = l * 10L + (long)c;
                if (++n6 != 18) continue;
                bigInteger = bigInteger == null ? BigInteger.valueOf(l) : bigInteger.multiply(m_bigPow10[18]).add(BigInteger.valueOf(l));
                l = 0L;
                n6 = 0;
                continue;
            }
            if ((char)byArray[n - 1] == '.') {
                if (n5 == 0) {
                    n5 = n;
                    continue;
                }
                n3 = n - 1;
                break;
            }
            n3 = n - 1;
            if ((char)byArray[n - 1] != 'E' || n >= n2) break;
            boolean bl2 = false;
            if ((c = (char)(byArray[n++] - 48)) <= '\t') {
                n4 = c;
            } else if ((char)byArray[n - 1] == '-') {
                bl2 = true;
            } else if ((char)byArray[n - 1] != '+') break;
            while (n < n2 && (c = (char)(byArray[n++] - 48)) <= '\t') {
                if (n4 <= 0xCCCCCCC && (n4 = n4 * 10 + c) >= 0) continue;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            if (!bl2) break;
            n4 = -n4;
            break;
        }
        if (n5 != 0) {
            n4 -= n3 - n5;
        }
        if (bigInteger == null) {
            bigInteger = BigInteger.valueOf(bl ? -l : l);
        } else {
            bigInteger = bigInteger.multiply(m_bigPow10[n6]).add(BigInteger.valueOf(l));
            if (bl) {
                bigInteger = bigInteger.negate();
            }
        }
        return n4 > 0 ? new BigDecimal(bigInteger.multiply(n4 > 18 ? m_bigPow10[1].pow(n4) : m_bigPow10[n4])) : new BigDecimal(bigInteger, -n4);
    }

    static final double parsedblb(byte[] byArray, int n, int n2) throws SQLException {
        char c;
        boolean bl;
        int n3;
        int n4;
        int n5;
        block19: {
            block18: {
                n5 = 0;
                n4 = 0;
                n3 = n2 += n;
                bl = false;
                while (n < n3) {
                    if ((char)((c = (char)byArray[n++]) - 48) <= '\t') break block18;
                    if (c == '-') {
                        bl = !bl;
                        continue;
                    }
                    if (c == '.') {
                        n5 = n;
                        break block18;
                    }
                    if (c == '+') continue;
                }
                return 0.0;
            }
            if (c == '0' || c == '.') {
                while (n < n3) {
                    if ((c = (char)byArray[n++]) == '.') {
                        if (n5 != 0) break;
                        n5 = n;
                        continue;
                    }
                    if (c == '0') continue;
                    if ((char)(c - 48) <= '\t') break block19;
                }
                return 0.0;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append(c);
        while (n < n3) {
            if ((char)((c = (char)byArray[n++]) - 48) <= '\t') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '.') {
                if (n5 == 0) {
                    n5 = n;
                    continue;
                }
                n3 = n - 1;
                break;
            }
            n3 = n - 1;
            if (c != 'E' || n >= n2) break;
            boolean bl2 = false;
            if ((char)((c = (char)byArray[n++]) - 48) <= '\t') {
                n4 = c;
            } else if (c == '-') {
                bl2 = true;
            } else if (c != '+') break;
            while (n < n2 && (c = (char)(byArray[n++] - 48)) <= '\t') {
                if (n4 <= 0xCCCCCCC && (n4 = n4 * 10 + c) >= 0) continue;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            if (!bl2) break;
            n4 = -n4;
            break;
        }
        if (n5 != 0) {
            n4 -= n3 - n5;
        }
        if (n4 != 0) {
            stringBuffer.append('E');
            stringBuffer.append(n4);
        }
        return Double.parseDouble(stringBuffer.toString());
    }

    static final int parsefracb(byte[] byArray, int n, int n2, long l, int n3, boolean bl, long[] lArray) throws SQLException {
        block0: do {
            char c;
            if ((c = (char)(byArray[n++] - 48)) > '\t') {
                if (c != '\u0015' || n >= n2) break;
                return ListUtil.parseexpb(byArray, n, n2, l, n3, bl, lArray);
            }
            if (l > 0xCCCCCCCCCCCCCCCL || l == 0xCCCCCCCCCCCCCCCL && c > '\u0007') {
                while (n < n2) {
                    if ((c = (char)(byArray[n++] - 48)) <= '\t') continue;
                    if (c != '\u0015' || n >= n2) break block0;
                    return ListUtil.parseexpb(byArray, n, n2, l, n3, bl, lArray);
                }
                break;
            }
            l = l * 10L + (long)c;
            --n3;
        } while (n < n2);
        return ListUtil.scale(l, n3, bl, lArray);
    }

    static final int parseexpb(byte[] byArray, int n, int n2, long l, int n3, boolean bl, long[] lArray) throws SQLException {
        char c;
        int n4;
        if (l == 0L) {
            lArray[0] = 0L;
            return 0;
        }
        boolean bl2 = false;
        if ((char)(n4 = byArray[n++] - 48) > '\t') {
            if (n4 == -3) {
                bl2 = true;
            } else if (n4 != -5) {
                n = n2;
            }
            n4 = 0;
        }
        while (n < n2 && (c = (char)(byArray[n++] - 48)) <= '\t' && n4 <= 0xCCCCCCC && (n4 = n4 * 10 + c) >= 0) {
        }
        if (n4 > 166) {
            if (!bl2) {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            lArray[0] = 0L;
            return 0;
        }
        return ListUtil.scale(l, n3 + (bl2 ? -n4 : n4), bl, lArray);
    }

    static final int parsenumb(byte[] byArray, int n, int n2, long[] lArray) throws SQLException {
        if (n2 == 0) {
            lArray[0] = 0L;
            return 0;
        }
        n2 += n;
        boolean bl = false;
        while (true) {
            int n3;
            if ((char)(n3 = byArray[n++] - 48) <= '\t') {
                while (n < n2) {
                    char c;
                    if ((c = (char)(byArray[n++] - 48)) > '\t') {
                        if (n >= n2) break;
                        if (c == '\ufffe') {
                            return ListUtil.parsefracb(byArray, n, n2, n3, 0, bl, lArray);
                        }
                        if (c != '\u0015') break;
                        return ListUtil.parseexpb(byArray, n, n2, n3, 0, bl, lArray);
                    }
                    if (n3 >= 0xCCCCCCC) {
                        long l = (long)n3 * 10L + (long)c;
                        int n4 = 0;
                        while (n < n2 && (c = (char)(byArray[n++] - 48)) <= '\t') {
                            if (l > 0xCCCCCCCCCCCCCCCL || l == 0xCCCCCCCCCCCCCCCL && c > '\u0007') {
                                do {
                                    ++n4;
                                } while (n < n2 && (c = (char)(byArray[n++] - 48)) <= '\t');
                                break;
                            }
                            l = l * 10L + (long)c;
                        }
                        if (n < n2) {
                            if (c == '\ufffe') {
                                return ListUtil.parsefracb(byArray, n, n2, l, n4, bl, lArray);
                            }
                            if (c == '\u0015') {
                                return ListUtil.parseexpb(byArray, n, n2, l, n4, bl, lArray);
                            }
                        }
                        return ListUtil.scale(l, n4, bl, lArray);
                    }
                    n3 = n3 * 10 + c;
                }
                lArray[0] = bl ? (long)(-n3) : (long)n3;
                return 0;
            }
            if (n == n2) break;
            if (n3 == -3) {
                bl = !bl;
                continue;
            }
            if (n3 == -2) {
                return ListUtil.parsefracb(byArray, n, n2, 0L, 0, bl, lArray);
            }
            if (n3 != -5) break;
        }
        lArray[0] = 0L;
        return 0;
    }

    static final int scale(long l, int n, boolean bl, long[] lArray) throws SQLException {
        if (l == 0L) {
            n = 0;
        } else if (n > 127) {
            do {
                if (l > 0xCCCCCCCCCCCCCCCL) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                l *= 10L;
            } while (--n > 127);
        } else if (n < -128) {
            if (n < -147) {
                l = 0L;
                n = 0;
            } else {
                if (l < 0L) {
                    l = 0xCCCCCCCCCCCCCCCL;
                    while (++n < -128) {
                        l /= 10L;
                    }
                } else {
                    while (++n < -128 && (l /= 10L) != 0L) {
                    }
                }
                if (l == 0L) {
                    n = 0;
                }
            }
        }
        lArray[0] = bl ? -l : l;
        return n;
    }

    static final int dblint(int n, long l) throws SQLException {
        if (n < 0) {
            if (n < -19) {
                return 0;
            }
            if ((l /= scaletab[-n]) != (long)((int)l)) {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            return (int)l;
        }
        if (l != (long)((int)l)) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        if (n > 0 && l != 0L) {
            do {
                if (l > 0xCCCCCCCL) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                if (l < -214748364L) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                l *= 10L;
            } while (--n != 0);
        }
        return (int)l;
    }

    static final long dbllong(int n, long l) throws SQLException {
        if (n < 0) {
            return n < -19 ? 0L : l / scaletab[-n];
        }
        if (n > 0 && l != 0L) {
            do {
                if (l > 0xCCCCCCCCCCCCCCCL) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                if (l < -922337203685477580L) {
                    throw new SQLException("Numeric value out of range", "22003", 22003);
                }
                l *= 10L;
            } while (--n != 0);
        }
        return l;
    }

    static final String dblstr(int n, long l) {
        char[] cArray = new char[150];
        boolean bl = l < 0L;
        int n2 = 150;
        int n3 = 150;
        if (l == 0L) {
            return "0";
        }
        if (l == Long.MIN_VALUE) {
            n3 = n2 - 19;
            "9223372036854775808".getChars(0, 19, cArray, n3);
        } else {
            int n4;
            int n5;
            if (bl) {
                l = -l;
            }
            if ((long)(n5 = (int)l) == l) {
                do {
                    n4 = n5 % 100;
                    cArray[--n3] = onestab[n4];
                    cArray[--n3] = tenstab[n4];
                } while ((n5 /= 100) != 0);
            } else {
                do {
                    n4 = (int)(l % 100L);
                    cArray[--n3] = onestab[n4];
                    cArray[--n3] = tenstab[n4];
                } while ((l /= 100L) != 0L);
            }
            if (cArray[n3] == '0') {
                ++n3;
            }
        }
        if (n > 0) {
            System.arraycopy(cArray, n3, cArray, 1, n2 -= n3);
            n3 = 1;
            do {
                int n6 = ++n2;
                ++n2;
                cArray[n6] = 48;
            } while (--n > 0);
        } else if (n < 0) {
            int n7 = n2 - n3;
            if (n7 > (n = -n)) {
                System.arraycopy(cArray, n3, cArray, n3 - 1, n7 - n);
                cArray[n2 - n - 1] = 46;
                --n3;
            } else {
                if ((n -= n7) != 0) {
                    do {
                        cArray[--n3] = 48;
                    } while (--n != 0);
                }
                cArray[--n3] = 46;
                cArray[--n3] = 48;
            }
        }
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, n2 - n3);
    }

    static final double dbl2dbl(int n, long l) {
        char[] cArray = new char[32];
        boolean bl = l < 0L;
        int n2 = 32;
        int n3 = 32;
        if (l == 0L) {
            return 0.0;
        }
        if (l == Long.MIN_VALUE) {
            n3 = n2 - 19;
            "9223372036854775808".getChars(0, 19, cArray, n3);
        } else {
            int n4;
            if (bl) {
                l = -l;
            }
            while (l > Integer.MAX_VALUE) {
                n4 = (int)(l % 100L);
                cArray[--n3] = onestab[n4];
                cArray[--n3] = tenstab[n4];
                l /= 100L;
            }
            n4 = (int)l;
            do {
                int n5 = n4 % 100;
                cArray[--n3] = onestab[n5];
                cArray[--n3] = tenstab[n5];
            } while ((n4 /= 100) != 0);
            if (cArray[n3] == '0') {
                ++n3;
            }
        }
        if (bl) {
            cArray[--n3] = 45;
        }
        if (n != 0) {
            System.arraycopy(cArray, n3, cArray, 0, n2 -= n3);
            n3 = 0;
            cArray[n2++] = 69;
            if (n < 0) {
                cArray[n2++] = 45;
                n = -n;
            }
            if (n >= 100) {
                cArray[n2++] = 49;
                n -= 100;
            }
            if (n >= 10) {
                cArray[n2++] = tenstab[n];
            }
            cArray[n2++] = onestab[n];
        }
        return Double.parseDouble(new String(cArray, n3, n2 - n3));
    }

    static final String lngstr(long l) {
        if ((long)((int)l) == l) {
            return Integer.toString((int)l);
        }
        if (l == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        int n = 20;
        char[] cArray = new char[20];
        if (l < 0L) {
            l = -l;
            do {
                int n2 = (int)(l % 100L);
                cArray[--n] = onestab[n2];
                cArray[--n] = tenstab[n2];
            } while ((l /= 100L) != 0L);
            if (cArray[n] != '0') {
                --n;
            }
            cArray[n] = 45;
        } else {
            do {
                int n3 = (int)(l % 100L);
                cArray[--n] = onestab[n3];
                cArray[--n] = tenstab[n3];
            } while ((l /= 100L) != 0L);
            if (cArray[n] == '0') {
                ++n;
            }
        }
        return new String(cArray, n, 20 - n);
    }

    static final short dblshort(int n, long l) throws SQLException {
        int n2 = ListUtil.dblint(n, l);
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        return (short)n2;
    }

    static final byte dblbyte(int n, long l) throws SQLException {
        int n2 = ListUtil.dblint(n, l);
        if (n2 > 127 || n2 < -128) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        return (byte)n2;
    }

    static final BigDecimal remainingPositiveScale(BigInteger bigInteger, int n) {
        if (n > 0) {
            bigInteger = bigInteger.multiply(n > 18 ? m_bigPow10[1].pow(n) : m_bigPow10[n]);
            n = 0;
        }
        return new BigDecimal(bigInteger, -n);
    }

    protected static int readCharacterStream(byte[] byArray, char[] cArray, int n, int n2, int n3) throws SQLException {
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
            System.arraycopy(string.toCharArray(), 0, cArray, n, string.length());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        return string.length();
    }

    protected static int readAsciiStream(byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws SQLException {
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
            byArray = string.getBytes();
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        return byArray.length;
    }

    protected static int readUnicodeStream(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) throws SQLException {
        if (n4 != -1) {
            throw new SQLException("Unsupported type conversion:  only java.sql.Types.LONGVARCHAR or java.sql.Types.VARCHAR can be converted to UnicodeStream", "S1000");
        }
        if (n3 <= 0) {
            n3 = byArray2.length - n;
        }
        if (n3 <= 0) {
            return 0;
        }
        try {
            return ListUtil.getUTF8Bytes(byArray, byArray2, 0, n, n2, n3);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    protected static final byte[] getUTF8Bytes(byte[] byArray, int n, int n2, int n3) throws SQLException {
        byte[] byArray2;
        int n4;
        int n5 = n2 / 2 * 3;
        if (n3 > 0 && n5 > n3) {
            n5 = n3;
        }
        if ((n4 = ListUtil.getUTF8Bytes(byArray, byArray2 = new byte[n5], n, 0, n2, n3)) < byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            return byArray3;
        }
        return byArray2;
    }

    protected static final int getUTF8Bytes(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) throws SQLException {
        int n5;
        if (n4 == 0) {
            n4 = -1;
        }
        int n6 = 0;
        for (int i = 0; i < n3 && (n5 = ListUtil.getUTF8single(byArray, byArray2, n + i, n2 + n6, n4)) >= 1; i += 2) {
            n6 += n5;
            if (n4 < 0) continue;
            n4 -= n6;
        }
        return n6;
    }

    protected static final int getUTFBytes(char c, byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        byte by = (byte)c;
        byte by2 = (byte)(c >> 8);
        return ListUtil.getUTF8single(by, by2, byArray, n, n2);
    }

    protected static final char getUChar(byte[] byArray, int n) {
        return (char)(byArray[n] & 0xFF | byArray[n + 1] << 8 & 0xFF00);
    }

    private static final int getUTF8single(byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws SQLException {
        if (n3 == 0) {
            return 0;
        }
        if (n + 2 >= byArray.length) {
            throw new SQLException("Bytes are not in UCS format", "S1000");
        }
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        return ListUtil.getUTF8single(by, by2, byArray2, n2, n3);
    }

    private static final int getUTF8FromAscii(byte[] byArray, int n, byte[] byArray2, int n2, int n3, String string) throws IOException {
        byte[] byArray3;
        if (n3 == 0) {
            return 0;
        }
        byte by = byArray[n];
        if ((by & 0x80) == 0) {
            byArray2[n2] = by;
            return 1;
        }
        if (0 < n3 && n3 < 2) {
            return 0;
        }
        String string2 = new String(byArray, n, 1);
        char c = string2.charAt(0);
        if (string != null && c != '?' && (byArray3 = string2.getBytes(string))[0] == 63) {
            throw new IOException("8-bit server does not support client encoding: " + c);
        }
        return ListUtil.getUTFBytes(c, byArray2, n2, n3);
    }

    private static final int getUTF8single(byte by, byte by2, byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (by2 == 0 && (by & 0x80) == 0) {
            byArray[n] = by;
            return 1;
        }
        if (0 < n2 && n2 < 2) {
            return 0;
        }
        int n3 = by & 0xFF | by2 << 8 & 0xFF00;
        if ((by2 & 0xF8) == 0) {
            int n4 = n3 >>> 6;
            int n5 = n3 % 64;
            byArray[n] = (byte)(192 + n4);
            byArray[n + 1] = (byte)(128 + n5);
            return 2;
        }
        if (0 < n2 && n2 < 3) {
            return 0;
        }
        int n6 = n3 >>> 12;
        int n7 = (n3 >>> 6) % 64;
        int n8 = n3 % 64;
        byArray[n] = (byte)(224 + n6);
        byArray[n + 1] = (byte)(128 + n7);
        byArray[n + 2] = (byte)(128 + n8);
        return 3;
    }

    protected static int readBinaryStream(byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws SQLException {
        return 0;
    }

    protected static int writeStream(InputStream inputStream, int n, int n2, byte[] byArray, int n3, int n4, int n5, String string) throws IOException {
        int n6;
        int n7 = 0;
        if (n == 0) {
            int n8 = byArray.length - n4 - 1;
            byte[] byArray2 = new byte[32768];
            while (n3 > n7) {
                int n9 = n3 > 32768 ? 32768 : n3 - n7;
                if ((n9 = inputStream.read(byArray2, 0, n9)) != -1) {
                    boolean bl = false;
                    for (int i = 0; i < n9; ++i) {
                        int n10 = ListUtil.getUTF8FromAscii(byArray2, i, byArray, n4 + n6, n8 - n6, string);
                        if (n10 == 0) {
                            bl = true;
                            break;
                        }
                        ++n7;
                        n6 += n10;
                    }
                    if (!bl) continue;
                }
                break;
            }
        } else if (n == 1) {
            int n11;
            for (n6 = 0; n3 > n6 && (n11 = inputStream.read(byArray, n4 + n6, n3 - n6)) != -1; n6 += n11) {
            }
            n7 = n6;
        } else {
            throw new IOException("Unsupported Stream type: " + n);
        }
        if (n5 >= 0) {
            byArray[n5] = (byte)n7;
            byArray[n5 + 1] = (byte)(n7 >> 8);
            byArray[n5 + 2] = (byte)(n7 >> 16);
            byArray[n5 + 3] = (byte)(n7 >> 24);
        }
        return n6;
    }

    protected static int readStream(byte[] byArray, Object object, int n, int n2, int n3) throws SQLException {
        int n4 = byArray.length;
        switch (n2) {
            case 0: {
                n4 = ListUtil.readAsciiStream(byArray, (byte[])object, n, byArray.length, n3);
                break;
            }
            case 1: {
                System.arraycopy(byArray, 0, object, n, byArray.length);
                break;
            }
            case 4: {
                n4 = ListUtil.readCharacterStream(byArray, (char[])object, n, byArray.length, n3);
            }
        }
        return n4;
    }

    private static int countUTF8(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n2 += ListUtil.utf8len(byArray[n2]);
            ++n;
        }
        return n;
    }

    private static int utf8len(int n) {
        int n2;
        int n3 = 1;
        for (int i = 7; i > 1 && (n2 = n >> i & 1) != 0; --i) {
            ++n3;
            if (i != 7) continue;
            --i;
        }
        return n3;
    }

    private static ReadResult writeUnicodeStream(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2 && (n3 = inputStream.read()) != -1) {
            byArray[n + n5] = (byte)(n3 &= 0xFF);
            ++n5;
            ++n4;
            int n6 = ListUtil.utf8len(n3);
            for (int i = 1; i < n6; ++i) {
                n3 = inputStream.read();
                if (n3 == -1) {
                    throw new IOException("Invalid unicode");
                }
                if (n5 >= n2) {
                    throw new IOException("Only " + i + " byte(s) of Unicode character were read before reaching maximum number of bytes: " + n2);
                }
                byArray[n + n5] = (byte)n3;
                ++n5;
            }
        }
        return new ReadResult(n5, n4);
    }

    static {
        long l = 1L;
        for (int i = 0; i <= 18; ++i) {
            ListUtil.m_bigPow10[i] = BigInteger.valueOf(l);
            l *= 10L;
        }
        scaletab = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        tenstab = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        onestab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    protected static class ReadResult {
        public int bytes;
        public int chars;

        public ReadResult(int n, int n2) {
            this.bytes = n;
            this.chars = n2;
        }
    }
}

