/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.preparser.CacheSqlPreParser;
import com.intersys.jdbc.preparser.CacheSqlPreParserTokenManager;
import com.intersys.jdbc.preparser.ParseException;
import com.intersys.jdbc.preparser.SimpleCharStream;
import com.intersys.jdbc.preparser.StatementTypes;
import com.intersys.jdbc.preparser.TokenMgrError;
import java.sql.SQLException;
import java.util.List;

class Preparser
implements StatementTypes {
    private boolean delimitedIds;
    private boolean addRowID;
    private String input;
    private int statementType;
    private String optionName;
    private String optionValue;
    private int paramCount;
    private List parameters;
    private String output;
    private static CacheSqlPreParser parser = null;
    private static boolean used;
    private static CacheSqlPreParserTokenManager tokenManager;

    Preparser(String string, boolean bl, boolean bl2) {
        this.delimitedIds = bl;
        this.addRowID = bl2;
        this.input = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparse() throws SQLException {
        if (parser == null) {
            Preparser.init(this.input);
        }
        CacheSqlPreParser cacheSqlPreParser = parser;
        synchronized (cacheSqlPreParser) {
            if (used) {
                Preparser.reInit(this.input);
            }
            used = true;
            CacheSqlPreParser.setDelimId(this.delimitedIds);
            CacheSqlPreParser.setAddRowID(this.addRowID);
            try {
                parser.Statement();
            }
            catch (ParseException parseException) {
                throw new SQLException(this.getExceptionMessage(parseException), "37000", 37000);
            }
            catch (TokenMgrError tokenMgrError) {
                throw new SQLException(this.getExceptionMessage(tokenMgrError), "37000", 37000);
            }
            this.statementType = parser.getStatementType();
            this.paramCount = parser.getParamCount();
            this.parameters = parser.getParameters();
            this.output = parser.isParsed() ? parser.getOutput() : this.input;
            this.optionName = parser.getOptionName();
            this.optionValue = parser.getOptionValue();
        }
    }

    private String getExceptionMessage(Throwable throwable) {
        String string = Thread.currentThread().getName() + ": " + throwable.getMessage() + ". Parsing statement: \"" + this.input + "\"";
        return string;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    public int getParametersCount() {
        return this.paramCount;
    }

    public String getPreparsedSQL() {
        return this.output;
    }

    public List getParameters() {
        return this.parameters;
    }

    public StatementTypes.Parameter getParameter(int n) {
        return (StatementTypes.Parameter)this.parameters.get(n);
    }

    private static void reInit(String string) {
        SimpleCharStream simpleCharStream = new SimpleCharStream(string);
        if (tokenManager == null) {
            tokenManager = new CacheSqlPreParserTokenManager(simpleCharStream);
        } else {
            CacheSqlPreParserTokenManager.ReInit(simpleCharStream);
        }
        parser.ReInit(tokenManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean init(String string) {
        Class<Preparser> clazz = Preparser.class;
        synchronized (Preparser.class) {
            if (parser != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            SimpleCharStream simpleCharStream = new SimpleCharStream(string);
            if (tokenManager == null) {
                tokenManager = new CacheSqlPreParserTokenManager(simpleCharStream);
            } else {
                CacheSqlPreParserTokenManager.ReInit(simpleCharStream);
            }
            parser = new CacheSqlPreParser(tokenManager);
            used = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    static {
        tokenManager = null;
    }
}

