/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.SysList;
import com.intersys.jdbc.SysListProxy;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class QuickStatement {
    public static final Unchanged UNCHANGED_OBJECT = new Unchanged();
    private CacheConnection connection;
    private int cursorNumber;

    QuickStatement(CacheConnection cacheConnection) throws SQLException {
        this.connection = cacheConnection;
        this.cursorNumber = ++this.connection.nextServerCursorNumber;
    }

    public final Wrapper wrapBinaryStream(InputStream inputStream) {
        return new Wrapper(inputStream, 1);
    }

    public final Wrapper wrapCharacterStream(InputStream inputStream) {
        return new Wrapper(inputStream, 0);
    }

    public final Wrapper wrapReader(Reader reader) {
        return new Wrapper(reader, 101);
    }

    public final Wrapper wrapHashMapOfReferences(HashMap hashMap) {
        return new Wrapper(hashMap, 3);
    }

    public final Wrapper wrapArrayListOfReferences(ArrayList arrayList) {
        return new Wrapper(arrayList, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object load(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_LOAD);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return this.connection.inMessage.wire.getWire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object bulkLoad(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_BULK_LOAD);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set((SysList)object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return this.connection.inMessage.wire.getWire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(String string, String string2, Object object, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.writeStreamParameters(vector);
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_STORE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n);
            this.writeParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                throw new SQLException("Row not found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(String string, String string2, Object object, Object object2, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_STORE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.wire.append((SysList)object2);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                throw new SQLException("Row not found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object bulkStore(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_BULK_STORE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.wire.append((SysList)object);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return this.connection.inMessage.wire;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object create(String string, String string2, int n, Vector vector, int n2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.writeStreamParameters(vector);
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CREATE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(n2);
            this.writeParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object create(String string, String string2, int n, Object object, int n2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CREATE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(n2);
            this.connection.outMessage.wire.append((SysList)object);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object bulkCreate(String string, String string2, int n, Object object, int n2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_BULK_CREATE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(n2);
            if (object instanceof SysList) {
                this.connection.outMessage.wire.append((SysList)object);
            } else if (object instanceof Batch) {
                this.connection.outMessage.wire.set(((Batch)object).counter);
                this.connection.outMessage.wire.append(((Batch)object).list);
            } else {
                throw new SQLException("Unsupported type for batch parameters: " + object.getClass().getName());
            }
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return this.connection.inMessage.wire;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_REMOVE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                throw new SQLException("Row not found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object childTableRowInsert(String string, String string2, int n, Object object, Vector vector, int n2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.writeStreamParameters(vector);
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_CREATE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n2);
            this.writeParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object childTableRowInsert(String string, String string2, int n, Object object, Object object2, int n2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_CREATE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n2);
            this.connection.outMessage.wire.append((SysList)object2);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChildTable(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_REMOVE);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeParameters(Vector vector) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            int n = vector.size();
            this.connection.outMessage.wire.set(n);
            for (int i = 0; i < n; ++i) {
                Object e = vector.elementAt(i);
                if (e == UNCHANGED_OBJECT) {
                    this.connection.outMessage.wire.setUndefined();
                    continue;
                }
                if (e instanceof ArrayList) {
                    SysListProxy.setListOfDatatypes(this.connection.outMessage.wire, (ArrayList)e);
                    continue;
                }
                if (e instanceof HashMap) {
                    SysListProxy.setMapOfDatatypes(this.connection.outMessage.wire, (HashMap)e);
                    continue;
                }
                if (e instanceof SysList) {
                    this.connection.outMessage.wire.set((SysList)e);
                    continue;
                }
                if (e instanceof Wrapper) {
                    if (((Wrapper)e).type == 2) {
                        SysListProxy.setListOfReferences(this.connection.outMessage.wire, (ArrayList)((Wrapper)e).obj);
                        continue;
                    }
                    if (((Wrapper)e).type != 3) continue;
                    SysListProxy.setMapOfReferences(this.connection.outMessage.wire, (HashMap)((Wrapper)e).obj);
                    continue;
                }
                this.connection.outMessage.wire.setParameter(e);
            }
        }
    }

    private synchronized void writeStreamParameters(Vector vector) throws SQLException {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof Wrapper)) continue;
            if (((Wrapper)e).type == 0 || ((Wrapper)e).type == 1) {
                vector.setElementAt(this.setStream((Wrapper)vector.elementAt(i)), i);
                continue;
            }
            if (((Wrapper)e).type != 101) continue;
            vector.setElementAt(this.setReader((Wrapper)vector.elementAt(i)), i);
        }
    }

    public final ArrayList getListOfDatatypesAsChildTable(String string, String string2, Object object, int n, int n2, int n3) throws SQLException {
        return this.getListAsChildTable(string, string2, object, n, n2, n3);
    }

    public final HashMap getArrayOfDatatypesAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws SQLException {
        return this.getArrayAsChildTable(string, string2, object, n, n2, n3, n4);
    }

    public final ArrayList getListOfReferencesAsChildTable(String string, String string2, Object object, int n, int n2, int n3) throws SQLException {
        return this.getListAsChildTable(string, string2, object, n, n2, n3);
    }

    public HashMap getArrayOfReferencesAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws SQLException {
        return this.getArrayAsChildTable(string, string2, object, n, n2, n3, n4);
    }

    private synchronized HashMap getArrayAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws SQLException {
        HashMap<Object, ChildTableRow> hashMap = new HashMap<Object, ChildTableRow>();
        SysList sysList = this.loadChildTable(string, string2, object, n4);
        if (sysList == null) {
            return hashMap;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                Object object2 = QuickStatement.getObject(sysList2, n);
                Object object3 = QuickStatement.getObject(sysList2, n3);
                hashMap.put(QuickStatement.getObject(sysList2, n2), new ChildTableRow(object2, object3));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return hashMap;
        }
    }

    private synchronized ArrayList getListAsChildTable(String string, String string2, Object object, int n, int n2, int n3) throws SQLException {
        ArrayList<ChildTableRow> arrayList = new ArrayList<ChildTableRow>();
        SysList sysList = this.loadChildTable(string, string2, object, n3);
        if (sysList == null) {
            return arrayList;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                arrayList.add(new ChildTableRow(QuickStatement.getObject(sysList2, n), QuickStatement.getObject(sysList2, n2)));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return arrayList;
        }
    }

    public synchronized ArrayList getListOfSerialsAsChildTable(String string, String string2, Object object, int n, int n2) throws SQLException {
        ArrayList<ChildTableRow> arrayList = new ArrayList<ChildTableRow>();
        SysList sysList = this.loadChildTable(string, string2, object, n2);
        if (sysList == null) {
            return arrayList;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                arrayList.add(new ChildTableRow(QuickStatement.getObject(sysList2, n), sysList2));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return arrayList;
        }
    }

    public synchronized HashMap getArrayOfSerialsAsChildTable(String string, String string2, Object object, int n, int n2, int n3) throws SQLException {
        HashMap<Object, ChildTableRow> hashMap = new HashMap<Object, ChildTableRow>();
        SysList sysList = this.loadChildTable(string, string2, object, n3);
        if (sysList == null) {
            return hashMap;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                Object object2 = QuickStatement.getObject(sysList2, n);
                hashMap.put(QuickStatement.getObject(sysList2, n2), new ChildTableRow(object2, sysList2));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return hashMap;
        }
    }

    public static final ArrayList getListOfReferences(Object object, int n) throws SQLException {
        SysList sysList = ((SysList)object).getList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                arrayList.add(QuickStatement.getObject(sysList2, n));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return arrayList;
        }
    }

    public static final HashMap getArrayOfReferences(Object object, int n, int n2) throws SQLException {
        SysList sysList = ((SysList)object).getList();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                Object object2 = QuickStatement.getObject(sysList2, n2);
                SysList sysList3 = sysList2.getListEx();
                hashMap.put(object2, QuickStatement.getObject(sysList3, n));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SysList loadChildTable(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_LOAD);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return this.connection.inMessage.wire;
        }
    }

    public static final SysList getSysList(Object object) throws SQLException {
        return ((SysList)object).getList();
    }

    public static final String getString(Object object) throws SQLException {
        return ((SysList)object).getString();
    }

    public static final byte[] getByte(Object object) throws SQLException {
        return ((SysList)object).getByte();
    }

    public static final Short getShort(Object object) throws SQLException {
        return ((SysList)object).getShortWrapper();
    }

    public static final Long getLong(Object object) throws SQLException {
        return ((SysList)object).getLongWrapper();
    }

    public static final Integer getInteger(Object object) throws SQLException {
        return ((SysList)object).getIntegerWrapper();
    }

    public static final BigDecimal getBigDecimal(Object object) throws SQLException {
        return ((SysList)object).getBigDecimal();
    }

    public static final Double getDouble(Object object) throws SQLException {
        return ((SysList)object).getDoubleWrapper();
    }

    public static final Boolean getBoolean(Object object) throws SQLException {
        return ((SysList)object).getBooleanWrapper();
    }

    public static final Date getDate(Object object) throws SQLException {
        return ((SysList)object).getDate();
    }

    public static final Time getTime(Object object) throws SQLException {
        return ((SysList)object).getTime();
    }

    public static final Timestamp getTimestamp(Object object) throws SQLException {
        return ((SysList)object).getTimestamp();
    }

    public final CacheInputStream getCharacterStream(Object object) throws SQLException {
        String string = ((SysList)object).getString();
        if (string == null) {
            return null;
        }
        CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string, this.cursorNumber, 0, -1, 0);
        if (cacheInputStream.isNull()) {
            return null;
        }
        return cacheInputStream;
    }

    public final CacheInputStream getBinaryStream(Object object) throws SQLException {
        String string = ((SysList)object).getString();
        if (string == null) {
            return null;
        }
        CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string, this.cursorNumber, 1, -4, 0);
        if (cacheInputStream.isNull()) {
            return null;
        }
        return cacheInputStream;
    }

    public final CacheReader getReader(Object object) throws SQLException {
        String string = ((SysList)object).getString();
        if (string == null) {
            return null;
        }
        CacheReader cacheReader = new CacheReader(this.connection, string, this.cursorNumber, -1, 0);
        if (cacheReader.isNull()) {
            return null;
        }
        return cacheReader;
    }

    public static final ArrayList getArrayList(Object object, int n) throws SQLException {
        SysList sysList = ((SysList)object).getList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            while (true) {
                arrayList.add(QuickStatement.getObject(sysList, n));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return arrayList;
        }
    }

    public static final HashMap getHashMap(Object object, int n) throws SQLException {
        SysList sysList = ((SysList)object).getList();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                hashMap.put(sysList2.getStringEx(), QuickStatement.getObject(sysList2, n));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return hashMap;
        }
    }

    public static final Object getObject(Object object, int n) throws SQLException {
        ((SysList)object).isEndEx();
        switch (n) {
            case 12: {
                return ((SysList)object).getString();
            }
            case -6: 
            case 4: 
            case 5: {
                return ((SysList)object).getIntegerWrapper();
            }
            case -5: {
                return ((SysList)object).getLongWrapper();
            }
            case 8: {
                return ((SysList)object).getDoubleWrapper();
            }
            case 91: {
                return ((SysList)object).getDate();
            }
            case 92: {
                return ((SysList)object).getTime();
            }
            case 93: {
                return ((SysList)object).getTimestamp();
            }
            case 2: {
                return ((SysList)object).getBigDecimal();
            }
            case -7: {
                return ((SysList)object).getBooleanWrapper();
            }
            case -3: 
            case -2: {
                return ((SysList)object).getByte();
            }
        }
        return ((SysList)object).getString();
    }

    private void writeListOfParameters(Vector vector) throws SQLException {
        SysList sysList = new SysList();
        sysList.setServerType(this.connection.isUnicodeServer, this.connection.serverLocale);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            sysList.setParameter(vector.elementAt(i));
        }
        this.connection.outMessage.wire.set(sysList);
    }

    public synchronized Object setStream(Wrapper wrapper) throws SQLException {
        int n;
        if (wrapper.obj == null) {
            return null;
        }
        try {
            n = ((InputStream)wrapper.obj).available();
        }
        catch (Exception exception) {
            throw new SQLException("Invalid stream length: " + exception.getMessage());
        }
        if (wrapper.type == 0) {
            return RealStream.sendStream(this.connection, wrapper.obj, n, 0, -1, this.cursorNumber);
        }
        if (wrapper.type == 1) {
            return RealStream.sendStream(this.connection, wrapper.obj, n, 1, -4, this.cursorNumber);
        }
        throw new SQLException("Invalid stream type");
    }

    public synchronized Object setReader(Wrapper wrapper) throws SQLException {
        if (wrapper.type != 101) {
            throw new SQLException("Invalid stream type");
        }
        if (wrapper.obj == null) {
            return null;
        }
        return RealStream.sendStream(this.connection, wrapper.obj, -1, 4, -1, this.cursorNumber);
    }

    public static final void parseStatus(byte[] byArray, Connection connection) throws SQLException {
        QuickStatement quickStatement = null;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("**getQuickStatement**");
        quickStatement = (QuickStatement)resultSet.getObject("**QuickStatement**");
        CacheConnection cacheConnection = quickStatement.connection;
        byte[] byArray2 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 2, byArray2, 0, byArray.length - 2);
        SysList sysList = new SysList(byArray2);
        sysList.setServerType(cacheConnection.isUnicodeServer, cacheConnection.serverLocale);
        SysList sysList2 = new SysList(sysList.getByte(0));
        sysList2.setServerType(cacheConnection.isUnicodeServer, cacheConnection.serverLocale);
        throw new SQLException(sysList2.getString(1), "00000", sysList2.getInt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object findRowIdByPrimaryKey(String string, String string2, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_FIND_ROWID_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object findRowIdByPrimaryKey(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_FIND_ROWID_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set((SysList)object);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object findRowIdByConstraint(String string, String string2, String string3, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_FIND_ROWID_BY_CONSTRAINT);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(string3);
            this.writeListOfParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object findRowIdByConstraint(String string, String string2, String string3, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_FIND_ROWID_BY_CONSTRAINT);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(string3);
            this.connection.outMessage.wire.set((SysList)object);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector findPkByConstraint(String string, String string2, String string3, Vector vector, Vector vector2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_FIND_PK_BY_CONSTRAINT);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(string3);
            this.writeListOfParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            SysList sysList = this.connection.inMessage.wire;
            Vector<Object> vector3 = new Vector<Object>();
            if (sysList == null) {
                return vector3;
            }
            for (int i = 0; i < vector2.size(); ++i) {
                try {
                    vector3.add(QuickStatement.getObject(sysList, (Integer)vector2.elementAt(i)));
                    continue;
                }
                catch (SysList.NoMoreDataException noMoreDataException) {
                    throw new SQLException("jdbcType.size() != result.size()");
                }
            }
            return vector3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object loadByPk(String string, String string2, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_LOAD_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return this.connection.inMessage.wire.getWire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object loadByPk(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_LOAD_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set((SysList)object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return this.connection.inMessage.wire.getWire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeByPk(String string, String string2, Vector vector, Vector vector2, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.writeStreamParameters(vector2);
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_STORE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n);
            this.writeParameters(vector2);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeByPk(String string, String string2, Object object, Object object2, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_STORE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set((SysList)object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.wire.append((SysList)object2);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeByPk(String string, String string2, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_REMOVE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeByPk(String string, String string2, Object object, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_REMOVE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set((SysList)object);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector createByPk(String string, String string2, int n, Vector vector, int n2, Vector vector2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.writeStreamParameters(vector);
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CREATE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.set(n2);
            this.writeParameters(vector);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            SysList sysList = this.connection.inMessage.wire;
            Vector<Object> vector3 = new Vector<Object>();
            if (sysList == null) {
                return vector3;
            }
            for (int i = 0; i < vector2.size(); ++i) {
                try {
                    vector3.add(QuickStatement.getObject(sysList, (Integer)vector2.elementAt(i)));
                    continue;
                }
                catch (SysList.NoMoreDataException noMoreDataException) {
                    throw new SQLException("jdbcType.size() != result.size()");
                }
            }
            return vector3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChildTableByPk(String string, String string2, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_REMOVE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object childTableRowInsertByPk(String string, String string2, int n, Vector vector, Vector vector2, int n2) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.writeStreamParameters(vector2);
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_CREATE_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n2);
            this.writeParameters(vector2);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            return QuickStatement.getObject(this.connection.inMessage.wire, n);
        }
    }

    public ArrayList getChildrenRowIds(String string, String string2, Object object, int n, int n2, int n3) throws SQLException {
        return this.getListAsChildTable(string, string2, object, n, n2, n3);
    }

    public ArrayList getChildrenRowIdsByPk(String string, String string2, Vector vector, int n, int n2, int n3) throws SQLException {
        return this.getListAsChildTableByPk(string, string2, vector, n, n2, n3);
    }

    public ArrayList getListOfDatatypesAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3) throws SQLException {
        return this.getListAsChildTableByPk(string, string2, vector, n, n2, n3);
    }

    public ArrayList getListOfReferencesAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3) throws SQLException {
        return this.getListAsChildTableByPk(string, string2, vector, n, n2, n3);
    }

    private synchronized ArrayList getListAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3) throws SQLException {
        ArrayList<ChildTableRow> arrayList = new ArrayList<ChildTableRow>();
        SysList sysList = this.loadChildTableByPk(string, string2, vector, n3);
        if (sysList == null) {
            return arrayList;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                arrayList.add(new ChildTableRow(QuickStatement.getObject(sysList2, n), QuickStatement.getObject(sysList2, n2)));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SysList loadChildTableByPk(String string, String string2, Vector vector, int n) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_CHILD_TABLE_LOAD_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            return this.connection.inMessage.wire;
        }
    }

    public HashMap getArrayOfDatatypesAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3, int n4) throws SQLException {
        return this.getArrayAsChildTableByPk(string, string2, vector, n, n2, n3, n4);
    }

    public HashMap getArrayOfReferencesAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3, int n4) throws SQLException {
        return this.getArrayAsChildTableByPk(string, string2, vector, n, n2, n3, n4);
    }

    private synchronized HashMap getArrayAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3, int n4) throws SQLException {
        HashMap<Object, ChildTableRow> hashMap = new HashMap<Object, ChildTableRow>();
        SysList sysList = this.loadChildTableByPk(string, string2, vector, n4);
        if (sysList == null) {
            return hashMap;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                Object object = QuickStatement.getObject(sysList2, n);
                Object object2 = QuickStatement.getObject(sysList2, n3);
                hashMap.put(QuickStatement.getObject(sysList2, n2), new ChildTableRow(object, object2));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return hashMap;
        }
    }

    public synchronized ArrayList getListOfSerialsAsChildTableByPk(String string, String string2, Vector vector, int n, int n2) throws SQLException {
        ArrayList<ChildTableRow> arrayList = new ArrayList<ChildTableRow>();
        SysList sysList = this.loadChildTableByPk(string, string2, vector, n2);
        if (sysList == null) {
            return arrayList;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                arrayList.add(new ChildTableRow(QuickStatement.getObject(sysList2, n), sysList2));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return arrayList;
        }
    }

    public synchronized HashMap getArrayOfSerialsAsChildTableByPk(String string, String string2, Vector vector, int n, int n2, int n3) throws SQLException {
        HashMap<Object, ChildTableRow> hashMap = new HashMap<Object, ChildTableRow>();
        SysList sysList = this.loadChildTableByPk(string, string2, vector, n3);
        if (sysList == null) {
            return hashMap;
        }
        try {
            while (true) {
                SysList sysList2 = sysList.getListEx();
                Object object = QuickStatement.getObject(sysList2, n);
                hashMap.put(QuickStatement.getObject(sysList2, n2), new ChildTableRow(object, sysList2));
            }
        }
        catch (SysList.NoMoreDataException noMoreDataException) {
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList getChildrenPks(String string, String string2, Object object, int n, int n2, int n3) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_GET_CHILDREN_PKS);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.wire.set(n3);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            SysList sysList = this.connection.inMessage.wire;
            ArrayList<ChildTableRow> arrayList = new ArrayList<ChildTableRow>();
            if (sysList == null) {
                return arrayList;
            }
            try {
                while (true) {
                    SysList sysList2 = sysList.getListEx();
                    arrayList.add(new ChildTableRow(QuickStatement.getObject(sysList2, n), QuickStatement.getObject(sysList2, n2)));
                }
            }
            catch (SysList.NoMoreDataException noMoreDataException) {
                return arrayList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList getChildrenPksByPk(String string, String string2, Vector vector, int n, int n2, int n3) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_GET_CHILDREN_PKS_BY_PK);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.writeListOfParameters(vector);
            this.connection.outMessage.wire.set(n3);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            SysList sysList = this.connection.inMessage.wire;
            ArrayList<ChildTableRow> arrayList = new ArrayList<ChildTableRow>();
            if (sysList == null) {
                return arrayList;
            }
            try {
                while (true) {
                    SysList sysList2 = sysList.getListEx();
                    arrayList.add(new ChildTableRow(QuickStatement.getObject(sysList2, n), QuickStatement.getObject(sysList2, n2)));
                }
            }
            catch (SysList.NoMoreDataException noMoreDataException) {
                return arrayList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector findPkByRowId(String string, String string2, Object object, Vector vector) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.QUICK_FIND_PK_BY_ROWID);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.wire.set(string2);
            this.connection.outMessage.wire.setParameter(object);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (this.connection.inMessage.readHeader(this.cursorNumber, 0, 100) == 100) {
                return null;
            }
            SysList sysList = this.connection.inMessage.wire;
            Vector<Object> vector2 = new Vector<Object>();
            if (sysList == null) {
                return vector2;
            }
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    vector2.add(QuickStatement.getObject(sysList, (Integer)vector.elementAt(i)));
                    continue;
                }
                catch (SysList.NoMoreDataException noMoreDataException) {
                    throw new SQLException("jdbcType.size() != result.size()");
                }
            }
            return vector2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.cursorNumber, CacheConnection.CLOSE_STATEMENT);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
        }
    }

    public BulkStream getBulkStream() {
        return new BulkStream(this.connection, this.cursorNumber);
    }

    public static class Batch {
        private boolean optimistic = false;
        private int rows = 320;
        public SysList list;
        private SysList header;
        public int counter;
        private QuickStatement qs;
        private BulkStream stream;
        private boolean mIsUncicode;
        private String mServerLocale;

        public Batch(boolean bl, String string) {
            this.list = new SysList();
            this.list.setServerType(bl, string);
            this.counter = 0;
            this.mIsUncicode = bl;
            this.mServerLocale = string;
            this.stream = null;
            this.header = null;
        }

        public Batch(Connection connection, String string, String string2, int n, int n2) throws SQLException {
            CacheConnection cacheConnection = (CacheConnection)connection;
            this.counter = 0;
            this.mIsUncicode = cacheConnection.isServerUnicode();
            this.mServerLocale = cacheConnection.getServerLocale();
            this.setQuickStatement(cacheConnection);
            this.stream = this.qs.getBulkStream();
            this.header = new SysList();
            this.header.setServerType(this.mIsUncicode, this.mServerLocale);
            this.header.set(string);
            this.header.set(string2);
            this.header.set(n2);
            if (this.optimistic) {
                this.list = (SysList)this.stream.getWire();
                this.list.append(this.header);
                this.list.set(this.rows);
            } else {
                this.list = new SysList();
                this.list.setServerType(this.mIsUncicode, this.mServerLocale);
            }
        }

        public final boolean getIsUnicode() {
            return this.mIsUncicode;
        }

        public final String getLocale() {
            return this.mServerLocale;
        }

        public final void flushRecord() throws SQLException {
            ++this.counter;
            if (this.stream != null) {
                if (this.optimistic) {
                    if (this.counter == this.rows) {
                        this.flush(false);
                    }
                } else {
                    int n = this.list.getLength();
                    if (n > 31000) {
                        this.flush(false);
                    }
                }
            }
        }

        public void clear() throws SQLException {
            SysListProxy.clearList(this.list);
            this.counter = 0;
        }

        public Object execute() throws SQLException {
            Object object = this.flush(true);
            return object;
        }

        private Object flush(boolean bl) throws SQLException {
            this.beforeFlush();
            Object object = this.doFlush(bl);
            this.afterFlush();
            return object;
        }

        private void beforeFlush() throws SQLException {
            if (this.optimistic) {
                if (this.counter == 0) {
                    SysList sysList = (SysList)this.stream.getWire();
                    sysList.append(this.header);
                    sysList.set(0);
                } else if (this.counter != this.rows) {
                    throw new SQLException("Error in optimistic logic: counter = " + this.counter);
                }
            } else {
                SysList sysList = (SysList)this.stream.getWire();
                sysList.append(this.header);
                sysList.set(this.counter);
                sysList.append(this.list);
            }
        }

        private Object doFlush(boolean bl) throws SQLException {
            Object object = this.stream.send(CacheConnection.QUICK_BULK_CREATE, bl);
            return object;
        }

        private void afterFlush() throws SQLException {
            if (this.optimistic) {
                this.list = (SysList)this.stream.getWire();
                this.list.append(this.header);
                this.list.set(this.rows);
            } else {
                this.list.clearList();
            }
            this.counter = 0;
        }

        public static Object execute(String string, String string2, int n, Object object, Connection connection, int n2) throws SQLException {
            Object object2;
            Batch batch = (Batch)object;
            if (batch.stream != null) {
                object2 = batch.execute();
            } else {
                if (batch.qs == null) {
                    batch.setQuickStatement(connection);
                }
                object2 = batch.qs.bulkCreate(string, string2, n, batch, n2);
                batch.clear();
            }
            return object2;
        }

        private void setQuickStatement(Connection connection) throws SQLException {
            if (this.qs != null) {
                return;
            }
            if (connection instanceof CacheConnection) {
                this.qs = ((CacheConnection)connection).createQuickStatement();
                return;
            }
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("**getQuickStatement**");
            this.qs = (QuickStatement)resultSet.getObject("**QuickStatement**");
            if (this.qs == null) {
                throw new SQLException("JDBC Connection object used is not obtained through Cache driver");
            }
        }
    }

    private class Wrapper {
        static final int CHARACTER_STREAM = 0;
        static final int BINARY_STREAM = 1;
        static final int ARRAY_OF_REFERENCES = 2;
        static final int MAP_OF_REFERENCES = 3;
        static final int READER = 101;
        int type;
        Object obj;

        Wrapper(Object object, int n) {
            this.obj = object;
            this.type = n;
        }
    }

    public class ChildTableRow {
        public Object id;
        public Object data;

        ChildTableRow(Object object, Object object2) {
            this.id = object;
            this.data = object2;
        }
    }

    public class BulkStream {
        CacheConnection connection;
        int messageCount;
        int cursorNumber;

        BulkStream(CacheConnection cacheConnection, int n) {
            this.connection = cacheConnection;
            this.cursorNumber = n;
            this.messageCount = -1;
            this.connection.outMessage.wire.reserveHeader();
        }

        Object getWire() {
            this.connection.outMessage.wire.reserveHeader();
            return this.connection.outMessage.wire;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object send(byte[] byArray, boolean bl) throws SQLException {
            if (this.messageCount == -1) {
                this.messageCount = this.connection.messageCount.getCount();
            }
            this.connection.outMessage.wire.writeContinuationHeader(this.cursorNumber, byArray, !bl);
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.connection.outMessage.send(this.messageCount);
                this.connection.inMessage.readHeader(this.cursorNumber, 0, 0);
            }
            if (bl) {
                this.messageCount = -1;
            }
            this.connection.outMessage.wire.resetHeader();
            if (byArray == CacheConnection.QUICK_BULK_CREATE && bl) {
                return this.connection.inMessage.wire;
            }
            return null;
        }
    }

    private static class Unchanged {
        private Unchanged() {
        }
    }
}

