/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.classes.RegisteredObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheIOException;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.ObjectServerInfo;
import java.io.IOException;

class Streams {
    Streams() {
    }

    public static String getOref(RegisteredObject registeredObject) throws IOException {
        if (registeredObject == null) {
            throw new IOException("Stream is closed");
        }
        try {
            return registeredObject.getZRef().toString();
        }
        catch (ObjectClosedException objectClosedException) {
            throw new IOException("Stream is closed: " + objectClosedException.getMessage());
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    public static Boolean isStreamIOSupported(RegisteredObject registeredObject) throws IOException {
        try {
            ObjectServerInfo objectServerInfo = registeredObject.getDatabase().getServerInfo();
            if (objectServerInfo.getMajorObjectVersion() >= 5 && (objectServerInfo.getMinorObjectVersion() >= 1 || objectServerInfo.getMajorObjectBuildNumber() >= 2009)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }
}

