/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects.reflect;

import com.intersys.objects.reflect.CacheModifierConstants;

public class CacheModifier
implements CacheModifierConstants {
    public static boolean isStatic(int n) {
        return (n & 1) != 0;
    }

    public static boolean byReference(int n) {
        return (n & 2) != 0;
    }

    public static boolean hasDefaultValue(int n) {
        return (n & 4) != 0;
    }

    public static boolean returnsValue(int n) {
        return (n & 8) != 0;
    }

    public static boolean isLiteral(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isServerOnly(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isReadOnly(int n) {
        return (n & 0x40) != 0;
    }

    public static String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (CacheModifier.isStatic(n)) {
            stringBuffer.append("STATIC ");
        }
        if (CacheModifier.byReference(n)) {
            stringBuffer.append("BY_REFERENCE ");
        }
        if (CacheModifier.hasDefaultValue(n)) {
            stringBuffer.append("HAS_DEFAULT_VALUE ");
        }
        if (CacheModifier.returnsValue(n)) {
            stringBuffer.append("RETURNS_VALUE ");
        }
        if (CacheModifier.isLiteral(n)) {
            stringBuffer.append("LITERAL ");
        }
        if (CacheModifier.isServerOnly(n)) {
            stringBuffer.append("SERVER_ONLY ");
        }
        if ((n2 = stringBuffer.length()) > 0) {
            return stringBuffer.toString().substring(0, n2 - 1);
        }
        return "";
    }
}

