/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2;

import java.rmi.RemoteException;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.Recoverable;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.uil2.SocketManager;
import org.jboss.mq.il.uil2.SocketManagerHandler;
import org.jboss.mq.il.uil2.UILClientIL;
import org.jboss.mq.il.uil2.msgs.AcknowledgementRequestMsg;
import org.jboss.mq.il.uil2.msgs.AddMsg;
import org.jboss.mq.il.uil2.msgs.BaseMsg;
import org.jboss.mq.il.uil2.msgs.BrowseMsg;
import org.jboss.mq.il.uil2.msgs.CheckIDMsg;
import org.jboss.mq.il.uil2.msgs.CheckUserMsg;
import org.jboss.mq.il.uil2.msgs.ConnectionTokenMsg;
import org.jboss.mq.il.uil2.msgs.CreateDestMsg;
import org.jboss.mq.il.uil2.msgs.DeleteSubscriptionMsg;
import org.jboss.mq.il.uil2.msgs.DeleteTemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.EnableConnectionMsg;
import org.jboss.mq.il.uil2.msgs.GetIDMsg;
import org.jboss.mq.il.uil2.msgs.MsgTypes;
import org.jboss.mq.il.uil2.msgs.PingMsg;
import org.jboss.mq.il.uil2.msgs.ReceiveMsg;
import org.jboss.mq.il.uil2.msgs.RecoverMsg;
import org.jboss.mq.il.uil2.msgs.SubscribeMsg;
import org.jboss.mq.il.uil2.msgs.TemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.TransactMsg;
import org.jboss.mq.il.uil2.msgs.UnsubscribeMsg;

public class ServerSocketManagerHandler
implements MsgTypes,
SocketManagerHandler {
    private static Logger log = Logger.getLogger((Class)ServerSocketManagerHandler.class);
    private ConnectionToken connectionToken;
    private Invoker server;
    private SocketManager socketMgr;
    private boolean closed;

    public ServerSocketManagerHandler(Invoker server, SocketManager socketMgr) {
        this.server = server;
        this.socketMgr = socketMgr;
        this.closed = false;
    }

    public void handleMsg(BaseMsg msg) throws Exception {
        boolean trace = log.isTraceEnabled();
        int msgType = msg.getMsgType();
        if (trace) {
            log.trace((Object)("Begin handleMsg, msgType: " + msgType));
        }
        switch (msgType) {
            case 15: {
                log.debug((Object)"Setting up the UILClientIL Connection");
                ConnectionTokenMsg cmsg = (ConnectionTokenMsg)msg;
                this.connectionToken = cmsg.getToken();
                UILClientIL clientIL = (UILClientIL)this.connectionToken.clientIL;
                clientIL.setSocketMgr(this.socketMgr);
                this.socketMgr.sendReply(msg);
                log.debug((Object)"The UILClientIL Connection is set up");
                break;
            }
            case 1: {
                AcknowledgementRequestMsg ackmsg = (AcknowledgementRequestMsg)msg;
                AcknowledgementRequest ack = ackmsg.getAck();
                this.server.acknowledge(this.connectionToken, ack);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 2: {
                AddMsg amsg = (AddMsg)msg;
                this.server.addMessage(this.connectionToken, amsg.getMsg());
                this.socketMgr.sendReply(msg);
                break;
            }
            case 3: {
                BrowseMsg bmsg = (BrowseMsg)msg;
                SpyMessage[] msgs = this.server.browse(this.connectionToken, bmsg.getDest(), bmsg.getSelector());
                bmsg.setMessages(msgs);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 4: {
                CheckIDMsg idmsg = (CheckIDMsg)msg;
                String ID = idmsg.getID();
                this.server.checkID(ID);
                if (this.connectionToken != null) {
                    this.connectionToken.setClientID(ID);
                }
                this.socketMgr.sendReply(msg);
                break;
            }
            case 5: {
                this.server.connectionClosing(this.connectionToken);
                this.closed = true;
                this.socketMgr.sendReply(msg);
                this.socketMgr.stop();
                break;
            }
            case 6: {
                CreateDestMsg cqmsg = (CreateDestMsg)msg;
                Queue queue = this.server.createQueue(this.connectionToken, cqmsg.getName());
                cqmsg.setDest((Destination)queue);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 7: {
                CreateDestMsg ctmsg = (CreateDestMsg)msg;
                Topic topic = this.server.createTopic(this.connectionToken, ctmsg.getName());
                ctmsg.setDest((Destination)topic);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 8: {
                DeleteTemporaryDestMsg dtdmsg = (DeleteTemporaryDestMsg)msg;
                SpyDestination tmpdest = dtdmsg.getDest();
                this.server.deleteTemporaryDestination(this.connectionToken, tmpdest);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 9: {
                GetIDMsg gidmsg = (GetIDMsg)msg;
                String gid = this.server.getID();
                if (this.connectionToken != null) {
                    this.connectionToken.setClientID(gid);
                }
                gidmsg.setID(gid);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 10: {
                TemporaryDestMsg tqmsg = (TemporaryDestMsg)msg;
                TemporaryQueue tmpQueue = this.server.getTemporaryQueue(this.connectionToken);
                tqmsg.setDest((Destination)tmpQueue);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 11: {
                TemporaryDestMsg ttmsg = (TemporaryDestMsg)msg;
                TemporaryTopic tmpTopic = this.server.getTemporaryTopic(this.connectionToken);
                ttmsg.setDest((Destination)tmpTopic);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 13: {
                ReceiveMsg rmsg = (ReceiveMsg)msg;
                SpyMessage reply = this.server.receive(this.connectionToken, rmsg.getSubscriberID(), rmsg.getWait());
                rmsg.setMessage(reply);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 14: {
                EnableConnectionMsg ecmsg = (EnableConnectionMsg)msg;
                this.server.setEnabled(this.connectionToken, ecmsg.isEnabled());
                this.socketMgr.sendReply(msg);
                break;
            }
            case 16: {
                SubscribeMsg smsg = (SubscribeMsg)msg;
                this.server.subscribe(this.connectionToken, smsg.getSubscription());
                this.socketMgr.sendReply(msg);
                break;
            }
            case 17: {
                TransactMsg tmsg = (TransactMsg)msg;
                TransactionRequest trans = tmsg.getRequest();
                this.server.transact(this.connectionToken, trans);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 26: {
                RecoverMsg recmsg = (RecoverMsg)msg;
                int flags = recmsg.getFlags();
                if (this.server instanceof Recoverable) {
                    Recoverable recoverable = (Recoverable)((Object)this.server);
                    Xid[] xids = recoverable.recover(this.connectionToken, flags);
                    recmsg.setXids(xids);
                    this.socketMgr.sendReply(msg);
                    break;
                }
                throw new IllegalStateException("Invoker does not implement recoverable " + this.server);
            }
            case 18: {
                UnsubscribeMsg umsg = (UnsubscribeMsg)msg;
                this.server.unsubscribe(this.connectionToken, umsg.getSubscriptionID());
                this.socketMgr.sendReply(msg);
                break;
            }
            case 19: {
                DeleteSubscriptionMsg dsmsg = (DeleteSubscriptionMsg)msg;
                DurableSubscriptionID dsub = dsmsg.getSubscriptionID();
                this.server.destroySubscription(this.connectionToken, dsub);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 20: {
                CheckUserMsg cumsg = (CheckUserMsg)msg;
                String uid = this.server.checkUser(cumsg.getUsername(), cumsg.getPassword());
                cumsg.setID(uid);
                cumsg.clearPassword();
                this.socketMgr.sendReply(msg);
                break;
            }
            case 21: {
                PingMsg ping = (PingMsg)msg;
                this.server.ping(this.connectionToken, ping.getTime());
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 22: {
                CheckUserMsg cumsg2 = (CheckUserMsg)msg;
                String sessionID = this.server.authenticate(cumsg2.getUsername(), cumsg2.getPassword());
                cumsg2.setID(sessionID);
                cumsg2.clearPassword();
                this.socketMgr.sendReply(msg);
                break;
            }
            default: {
                throw new RemoteException("Unknown msgType: " + msgType);
            }
        }
        if (trace) {
            log.trace((Object)("End handleMsg, msgType: " + msgType));
        }
    }

    public void onStreamNotification(Object stream, int size) {
    }

    public void asynchFailure(String error, Throwable e) {
        log.debug((Object)error, e);
    }

    public void close() {
        try {
            if (!this.closed) {
                this.server.connectionClosing(this.connectionToken);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error closing connection: ", (Throwable)e);
        }
    }
}

