/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc2;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.JMSException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.jdbc2.PersistenceManagerMBean;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.TransactionTimeoutConfiguration;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager,
CacheStore {
    protected SynchronizedLong nextTransactionId = new SynchronizedLong(0L);
    protected TxManager txManager;
    protected DataSource datasource;
    protected TransactionManager tm;
    private int recoveryTimeout = 0;
    private int recoveryRetries = 0;
    private int recoverMessagesChunk = 0;
    private int statementRetries = 5;
    protected String UPDATE_MARKED_MESSAGES = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE TXOP=?";
    protected String UPDATE_MARKED_MESSAGES_XARECOVERY = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE TXOP=? AND TXID NOT IN (SELECT TXID FROM JMS_TRANSACTIONS WHERE XID IS NOT NULL)";
    protected String UPDATE_MARKED_MESSAGES_WITH_TX = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE TXOP=? AND TXID=?";
    protected String DELETE_MARKED_MESSAGES_WITH_TX = "DELETE FROM JMS_MESSAGES WHERE TXID IN (SELECT TXID FROM JMS_TRANSACTIONS) AND TXOP=?";
    protected String DELETE_MARKED_MESSAGES_WITH_TX_XARECOVERY = "DELETE FROM JMS_MESSAGES WHERE TXID IN (SELECT TXID FROM JMS_TRANSACTIONS WHERE XID = NULL) AND TXOP=?";
    protected String DELETE_TX = "DELETE FROM JMS_TRANSACTIONS WHERE TXID = ?";
    protected String DELETE_MARKED_MESSAGES = "DELETE FROM JMS_MESSAGES WHERE TXID=? AND TXOP=?";
    protected String DELETE_TEMPORARY_MESSAGES = "DELETE FROM JMS_MESSAGES WHERE TXOP = 'T'";
    protected String INSERT_TX = "INSERT INTO JMS_TRANSACTIONS (TXID) values(?)";
    protected String INSERT_TX_XARECOVERY = "INSERT INTO JMS_TRANSACTIONS (TXID, XID) values(?, ?)";
    protected String DELETE_ALL_TX = "DELETE FROM JMS_TRANSACTIONS";
    protected String DELETE_ALL_TX_XARECOVERY = "DELETE FROM JMS_TRANSACTIONS WHERE XID = NULL";
    protected String SELECT_MAX_TX = "SELECT MAX(TXID) FROM (SELECT MAX(TXID) FROM JMS_TRANSACTIONS UNION SELECT MAX(TXID) FROM JMS_MESSAGES)";
    protected String SELECT_ALL_TX_XARECOVERY = "SELECT TXID, XID FROM JMS_TRANSACTIONS";
    protected String SELECT_MESSAGES_IN_DEST = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE DESTINATION=?";
    protected String SELECT_MESSAGES_IN_DEST_XARECOVERY = "SELECT MESSAGEID, MESSAGEBLOB, TXID, TXOP FROM JMS_MESSAGES WHERE DESTINATION=?";
    protected String SELECT_MESSAGE_KEYS_IN_DEST = "SELECT MESSAGEID FROM JMS_MESSAGES WHERE DESTINATION=?";
    protected String SELECT_MESSAGE = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    protected String SELECT_MESSAGE_XARECOVERY = "SELECT MESSAGEID, MESSAGEBLOB, TXID, TXOP FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    protected String INSERT_MESSAGE = "INSERT INTO JMS_MESSAGES (MESSAGEID, DESTINATION, MESSAGEBLOB, TXID, TXOP) VALUES(?,?,?,?,?)";
    protected String MARK_MESSAGE = "UPDATE JMS_MESSAGES SET TXID=?, TXOP=? WHERE MESSAGEID=? AND DESTINATION=?";
    protected String DELETE_MESSAGE = "DELETE FROM JMS_MESSAGES WHERE MESSAGEID=? AND DESTINATION=?";
    protected String UPDATE_MESSAGE = "UPDATE JMS_MESSAGES SET MESSAGEBLOB=? WHERE MESSAGEID=? AND DESTINATION=?";
    protected String CREATE_MESSAGE_TABLE = "CREATE TABLE JMS_MESSAGES ( MESSAGEID INTEGER NOT NULL, DESTINATION VARCHAR(32) NOT NULL, TXID INTEGER, TXOP CHAR(1),MESSAGEBLOB OBJECT, PRIMARY KEY (MESSAGEID, DESTINATION) )";
    protected String CREATE_IDX_MESSAGE_TXOP_TXID = "CREATE INDEX JMS_MESSAGES_TXOP_TXID ON JMS_MESSAGES (TXOP, TXID)";
    protected String CREATE_IDX_MESSAGE_DESTINATION = "CREATE INDEX JMS_MESSAGES_DESTINATION ON JMS_MESSAGES (DESTINATION)";
    protected String CREATE_TX_TABLE = "CREATE TABLE JMS_TRANSACTIONS ( TXID INTEGER, PRIMARY KEY (TXID) )";
    protected String CREATE_TX_TABLE_XARECOVERY = "CREATE TABLE JMS_TRANSACTIONS ( TXID INTEGER, XID OBJECT, PRIMARY KEY (TXID) )";
    protected static final int OBJECT_BLOB = 0;
    protected static final int BYTES_BLOB = 1;
    protected static final int BINARYSTREAM_BLOB = 2;
    protected static final int BLOB_BLOB = 3;
    protected int blobType = 0;
    protected boolean createTables;
    protected int connectionRetryAttempts = 5;
    protected boolean xaRecovery = false;
    protected ObjectName connectionManagerName;
    protected Properties sqlProperties = new Properties();

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized void createSchema() throws JMSException {
        block77: {
            boolean threadWasInterrupted;
            Statement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block73: {
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                threadWasInterrupted = Thread.interrupted();
                if (this.createTables) {
                    block70: {
                        boolean createdMessageTable;
                        block64: {
                            c = this.getConnection();
                            createdMessageTable = false;
                            stmt = c.prepareStatement(this.CREATE_MESSAGE_TABLE);
                            stmt.executeUpdate();
                            createdMessageTable = true;
                            Object var8_7 = null;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Throwable ignored) {
                                this.log.trace((Object)("Ignored: " + ignored));
                            }
                            stmt = null;
                            {
                                break block64;
                                catch (SQLException e) {
                                    this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_MESSAGE_TABLE), (Throwable)e);
                                    Object var8_8 = null;
                                    try {
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                    }
                                    catch (Throwable ignored) {
                                        this.log.trace((Object)("Ignored: " + ignored));
                                    }
                                    stmt = null;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_9 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                                catch (Throwable ignored) {
                                    this.log.trace((Object)("Ignored: " + ignored));
                                }
                                stmt = null;
                                throw throwable;
                            }
                        }
                        if (createdMessageTable) {
                            block67: {
                                stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_TXOP_TXID);
                                stmt.executeUpdate();
                                Object var11_19 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                                catch (Throwable ignored) {
                                    this.log.trace((Object)("Ignored: " + ignored));
                                }
                                stmt = null;
                                {
                                    break block67;
                                    catch (SQLException e) {
                                        this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_TXOP_TXID), (Throwable)e);
                                        Object var11_20 = null;
                                        try {
                                            if (stmt != null) {
                                                stmt.close();
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            this.log.trace((Object)("Ignored: " + ignored));
                                        }
                                        stmt = null;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var11_21 = null;
                                    try {
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                    }
                                    catch (Throwable ignored) {
                                        this.log.trace((Object)("Ignored: " + ignored));
                                    }
                                    stmt = null;
                                    throw throwable;
                                }
                            }
                            stmt = c.prepareStatement(this.CREATE_IDX_MESSAGE_DESTINATION);
                            stmt.executeUpdate();
                            Object var14_26 = null;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Throwable ignored) {
                                this.log.trace((Object)("Ignored: " + ignored));
                            }
                            stmt = null;
                            {
                                break block70;
                                catch (SQLException e) {
                                    this.log.debug((Object)("Could not create index with SQL: " + this.CREATE_IDX_MESSAGE_DESTINATION), (Throwable)e);
                                    Object var14_27 = null;
                                    try {
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                    }
                                    catch (Throwable ignored) {
                                        this.log.trace((Object)("Ignored: " + ignored));
                                    }
                                    stmt = null;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var14_28 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                                catch (Throwable ignored) {
                                    this.log.trace((Object)("Ignored: " + ignored));
                                }
                                stmt = null;
                                throw throwable;
                            }
                        }
                    }
                    String createTxTable = this.CREATE_TX_TABLE;
                    if (this.xaRecovery) {
                        createTxTable = this.CREATE_TX_TABLE_XARECOVERY;
                    }
                    stmt = c.prepareStatement(createTxTable);
                    stmt.executeUpdate();
                    Object var17_33 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignored) {
                        this.log.trace((Object)("Ignored: " + ignored));
                    }
                    stmt = null;
                    {
                        break block73;
                        catch (SQLException e) {
                            this.log.debug((Object)("Could not create table with SQL: " + createTxTable), (Throwable)e);
                            Object var17_34 = null;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Throwable ignored) {
                                this.log.trace((Object)("Ignored: " + ignored));
                            }
                            stmt = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_35 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Throwable ignored) {
                            this.log.trace((Object)("Ignored: " + ignored));
                        }
                        stmt = null;
                        throw throwable;
                    }
                }
            }
            Object var20_40 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            stmt = null;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            c = null;
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block77;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not get a connection for jdbc2 table construction ", e);
                }
            }
            catch (Throwable throwable) {
                Object var20_41 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                stmt = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                c = null;
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected synchronized void resolveAllUncommitedTXs() throws JMSException {
        block30: {
            boolean threadWasInterrupted;
            ResultSet rs;
            PreparedStatement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block26: {
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                rs = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                stmt = c.prepareStatement(this.SELECT_MAX_TX);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    this.nextTransactionId.set(rs.getLong(1) + 1L);
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
                stmt = c.prepareStatement(this.DELETE_TEMPORARY_MESSAGES);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                String deleteMarkedMessagesWithTx = this.DELETE_MARKED_MESSAGES_WITH_TX;
                if (this.xaRecovery) {
                    deleteMarkedMessagesWithTx = this.DELETE_MARKED_MESSAGES_WITH_TX_XARECOVERY;
                }
                stmt = c.prepareStatement(deleteMarkedMessagesWithTx);
                stmt.setString(1, "A");
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                String updateMarkedMessages = this.UPDATE_MARKED_MESSAGES;
                if (this.xaRecovery) {
                    updateMarkedMessages = this.UPDATE_MARKED_MESSAGES_XARECOVERY;
                }
                stmt = c.prepareStatement(updateMarkedMessages);
                stmt.setNull(1, -5);
                stmt.setString(2, "A");
                stmt.setString(3, "D");
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                String deleteAllTx = this.DELETE_ALL_TX;
                if (this.xaRecovery) {
                    deleteAllTx = this.DELETE_ALL_TX_XARECOVERY;
                }
                stmt = c.prepareStatement(deleteAllTx);
                stmt.execute();
                stmt.close();
                stmt = null;
                if (!this.xaRecovery) break block26;
                stmt = c.prepareStatement(this.SELECT_ALL_TX_XARECOVERY);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long txid = rs.getLong(1);
                    Xid xid = this.extractXid(rs, 2);
                    Tx tx = new Tx(txid);
                    tx.setXid(xid);
                    tx.checkPersisted();
                    this.txManager.restoreTx(tx);
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            Object var14_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block30;
            {
                catch (Exception e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not resolve uncommited transactions.  Message recovery may not be accurate", e);
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        if (jmsDest == null) {
            throw new IllegalArgumentException("Must supply non null JMSDestination to restoreQueue");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Must supply non null SpyDestination to restoreQueue");
        }
        boolean canOverrideTimeout = this.tm instanceof TransactionTimeoutConfiguration;
        int previousTimeout = 0;
        try {
            if (this.recoveryTimeout != 0) {
                if (canOverrideTimeout) {
                    previousTimeout = ((TransactionTimeoutConfiguration)this.tm).getTransactionTimeout();
                    this.tm.setTransactionTimeout(this.recoveryTimeout);
                } else {
                    this.log.debug((Object)("Cannot override recovery timeout, TransactionManager does implement " + TransactionTimeoutConfiguration.class.getName()));
                }
            }
            try {
                this.internalRestoreQueue(jmsDest, dest);
                Object var6_5 = null;
                if (this.recoveryTimeout == 0 || !canOverrideTimeout) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.recoveryTimeout == 0 || !canOverrideTimeout) throw throwable;
                this.tm.setTransactionTimeout(previousTimeout);
                throw throwable;
            }
            this.tm.setTransactionTimeout(previousTimeout);
            return;
        }
        catch (Exception e) {
            SpyJMSException.rethrowAsJMSException("Unexpected error in recovery", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected synchronized void internalRestoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        block54: {
            prepared = null;
            if (this.xaRecovery) {
                prepared = new HashMap<Long, Tx>();
                map = this.txManager.getPreparedTransactions();
                i = map.values().iterator();
                while (i.hasNext()) {
                    info = (TxManager.PreparedInfo)i.next();
                    j = info.getTxids().iterator();
                    while (j.hasNext()) {
                        tx = (Tx)j.next();
                        prepared.put(new Long(tx.longValue()), tx);
                    }
                }
            }
            tms = new TransactionManagerStrategy();
            tms.startTX();
            c = null;
            stmt = null;
            stmt2 = null;
            rs = null;
            threadWasInterrupted = Thread.interrupted();
            selectMessagesInDest = this.SELECT_MESSAGES_IN_DEST;
            selectMessage = this.SELECT_MESSAGE;
            if (this.xaRecovery) {
                selectMessagesInDest = this.SELECT_MESSAGES_IN_DEST_XARECOVERY;
                selectMessage = this.SELECT_MESSAGE_XARECOVERY;
            }
            c = this.getConnection();
            if (this.recoverMessagesChunk == 0) {
                stmt = c.prepareStatement(selectMessagesInDest);
            } else {
                stmt = c.prepareStatement(this.SELECT_MESSAGE_KEYS_IN_DEST);
                stmt2 = c.prepareStatement(selectMessage);
            }
            stmt.setString(1, dest.toString());
            txid = 0L;
            txop = null;
            rs = stmt.executeQuery();
            counter = 0;
            recovery = 0;
            while (rs.next()) {
                msgid = rs.getLong(1);
                message = null;
                if (this.recoverMessagesChunk == 0) {
                    message = this.extractMessage(rs);
                    if (this.xaRecovery) {
                        txid = rs.getLong(3);
                        txop = rs.getString(4);
                    }
                } else {
                    rs2 = null;
                    try {
                        stmt2.setLong(1, msgid);
                        stmt2.setString(2, dest.toString());
                        rs2 = stmt2.executeQuery();
                        if (rs2.next()) {
                            message = this.extractMessage(rs2);
                            if (this.xaRecovery) {
                                txid = rs.getLong(3);
                                txop = rs.getString(4);
                            }
                        } else {
                            this.log.warn((Object)("Failed to find message msgid=" + msgid + " dest=" + dest));
                        }
                        var22_21 = null;
                        ** if (rs2 == null) goto lbl-1000
                    }
                    catch (Throwable var21_23) {
                        var22_21 = null;
                        if (rs2 != null) {
                            try {
                                rs2.close();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        throw var21_23;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            rs2.close();
                        }
                        catch (Exception ignored) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                if (dest instanceof SpyTopic) {
                    message.header.durableSubscriberID = ((SpyTopic)dest).getDurableSubscriptionID();
                }
                if (!this.xaRecovery || txid == 0L || txop == null) {
                    jmsDest.restoreMessage(message);
                } else {
                    tx = (Tx)prepared.get(new Long(txid));
                    if (tx == null) {
                        jmsDest.restoreMessage(message);
                    } else if ("A".equals(txop)) {
                        jmsDest.restoreMessage(message, tx, 1);
                        ++recovery;
                    } else if ("D".equals(txop)) {
                        jmsDest.restoreMessage(message, tx, -1);
                        ++recovery;
                    } else {
                        throw new IllegalStateException("Unknown txop=" + txop + " for msg=" + msgid + " dest=" + dest);
                    }
                }
                ++counter;
            }
            this.log.debug((Object)("Restored " + counter + " message(s) to: " + dest + " " + recovery + " need recovery."));
            var25_24 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block54;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
                }
            }
            catch (Throwable var24_28) {
                var25_25 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw var24_28;
            }
        }
    }

    SpyMessage extractMessage(ResultSet rs) throws SQLException, IOException {
        try {
            long messageid = rs.getLong(1);
            SpyMessage message = null;
            if (this.blobType == 0) {
                message = (SpyMessage)rs.getObject(2);
            } else if (this.blobType == 1) {
                byte[] st = rs.getBytes(2);
                ByteArrayInputStream baip = new ByteArrayInputStream(st);
                ObjectInputStream ois = new ObjectInputStream(baip);
                message = SpyMessage.readMessage(ois);
            } else if (this.blobType == 2) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBinaryStream(2));
                message = SpyMessage.readMessage(ois);
            } else if (this.blobType == 3) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBlob(2).getBinaryStream());
                message = SpyMessage.readMessage(ois);
            }
            message.header.messageId = messageid;
            return message;
        }
        catch (StreamCorruptedException e) {
            throw new IOException("Could not load the message: " + e);
        }
    }

    Xid extractXid(ResultSet rs, int column) throws SQLException, IOException, ClassNotFoundException {
        try {
            Xid xid = null;
            if (this.blobType == 0) {
                xid = (Xid)rs.getObject(column);
            } else if (this.blobType == 1) {
                byte[] st = rs.getBytes(column);
                ByteArrayInputStream baip = new ByteArrayInputStream(st);
                ObjectInputStream ois = new ObjectInputStream(baip);
                xid = (Xid)ois.readObject();
            } else if (this.blobType == 2) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBinaryStream(column));
                xid = (Xid)ois.readObject();
            } else if (this.blobType == 3) {
                ObjectInputStream ois = new ObjectInputStream(rs.getBlob(column).getBinaryStream());
                xid = (Xid)ois.readObject();
            }
            return xid;
        }
        catch (StreamCorruptedException e) {
            throw new IOException("Could not load the message: " + e);
        }
    }

    /*
     * Loose catch block
     */
    public void commitPersistentTx(Tx txId) throws JMSException {
        block13: {
            if (!txId.wasPersisted()) {
                return;
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            this.removeMarkedMessages(c, txId, "D");
            this.removeTXRecord(c, txId.longValue());
            Object var7_5 = null;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block13;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not commit tx: " + txId, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarkedMessages(Connection c, Tx txid, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_MARKED_MESSAGES);
            stmt.setLong(1, txid.longValue());
            stmt.setString(2, mark);
            stmt.executeUpdate();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTXRecord(Connection c, Tx txid) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            String insertTx = this.INSERT_TX;
            if (this.xaRecovery) {
                insertTx = this.INSERT_TX_XARECOVERY;
            }
            stmt = c.prepareStatement(insertTx);
            stmt.setLong(1, txid.longValue());
            if (this.xaRecovery) {
                Xid xid = txid.getXid();
                if (xid != null) {
                    this.setBlob(stmt, 2, xid);
                } else {
                    stmt.setNull(2, 2004);
                }
            }
            stmt.executeUpdate();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTXRecord(Connection c, long txid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_TX);
            stmt.setLong(1, txid);
            stmt.executeUpdate();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {}
    }

    /*
     * Loose catch block
     */
    public void rollbackPersistentTx(Tx txId) throws JMSException {
        block19: {
            if (!txId.wasPersisted()) {
                return;
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            this.removeMarkedMessages(c, txId, "A");
            this.removeTXRecord(c, txId.longValue());
            stmt = c.prepareStatement(this.UPDATE_MARKED_MESSAGES_WITH_TX);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.setLong(4, txId.longValue());
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            Object var8_6 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block19;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not rollback tx: " + txId, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    public Tx createPersistentTx() throws JMSException {
        Tx id = new Tx(this.nextTransactionId.increment());
        return id;
    }

    public void insertPersistentTx(TransactionManagerStrategy tms, Connection c, Tx tx) throws JMSException {
        try {
            if (tx != null && !tx.checkPersisted()) {
                this.addTXRecord(c, tx);
            }
        }
        catch (Exception e) {
            tms.setRollbackOnly();
            throw new SpyJMSException("Could not create tx: " + tx.longValue(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        block22: {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("About to add message " + messageRef + " transaction=" + txId));
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            this.insertPersistentTx(tms, c, txId);
            MessageReference messageReference = messageRef;
            synchronized (messageReference) {
                SpyMessage message = messageRef.getMessage();
                if (messageRef.stored == 2) {
                    if (trace) {
                        this.log.trace((Object)("Updating message " + messageRef + " transaction=" + txId));
                    }
                    this.markMessage(c, messageRef.messageId, messageRef.getPersistentKey(), txId, "A");
                } else {
                    if (trace) {
                        this.log.trace((Object)("Inserting message " + messageRef + " transaction=" + txId));
                    }
                    this.add(c, messageRef.getPersistentKey(), message, txId, "A");
                    messageRef.setStored(2);
                }
                if (trace) {
                    this.log.trace((Object)("Added message " + messageRef + " transaction=" + txId));
                }
            }
            Object var11_12 = null;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block22;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Connection c, String queue, SpyMessage message, Tx txId, String mark) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.INSERT_MESSAGE);
            stmt.setLong(1, message.header.messageId);
            stmt.setString(2, queue);
            this.setBlob(stmt, 3, message);
            if (txId != null) {
                stmt.setLong(4, txId.longValue());
            } else {
                stmt.setNull(4, -5);
            }
            stmt.setString(5, mark);
            stmt.executeUpdate();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable ignore) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessage(Connection c, long messageid, String destination, Tx txId, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.MARK_MESSAGE);
            if (txId == null) {
                stmt.setNull(1, -5);
            } else {
                stmt.setLong(1, txId.longValue());
            }
            stmt.setString(2, mark);
            stmt.setLong(3, messageid);
            stmt.setString(4, destination);
            stmt.executeUpdate();
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable ignore) {}
    }

    public void setBlob(PreparedStatement stmt, int column, SpyMessage message) throws IOException, SQLException {
        if (this.blobType == 0) {
            stmt.setObject(column, message);
        } else if (this.blobType == 1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            SpyMessage.writeMessage(message, oos);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            stmt.setBytes(column, messageAsBytes);
        } else if (this.blobType == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            SpyMessage.writeMessage(message, oos);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
            stmt.setBinaryStream(column, (InputStream)bais, messageAsBytes.length);
        } else if (this.blobType == 3) {
            throw new RuntimeException("BLOB_TYPE: BLOB_BLOB is not yet implemented.");
        }
    }

    public void setBlob(PreparedStatement stmt, int column, Xid xid) throws IOException, SQLException {
        if (this.blobType == 0) {
            stmt.setObject(column, xid);
        } else if (this.blobType == 1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(xid);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            stmt.setBytes(column, messageAsBytes);
        } else if (this.blobType == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(xid);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
            stmt.setBinaryStream(column, (InputStream)bais, messageAsBytes.length);
        } else if (this.blobType == 3) {
            throw new RuntimeException("BLOB_TYPE: BLOB_BLOB is not yet implemented.");
        }
    }

    /*
     * Loose catch block
     */
    public void update(MessageReference messageRef, Tx txId) throws JMSException {
        block24: {
            boolean threadWasInterrupted;
            Statement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block21: {
                boolean trace = this.log.isTraceEnabled();
                if (trace) {
                    this.log.trace((Object)("Updating message " + messageRef + " transaction=" + txId));
                }
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                if (txId == null) {
                    stmt = c.prepareStatement(this.UPDATE_MESSAGE);
                    this.setBlob((PreparedStatement)stmt, 1, messageRef.getMessage());
                    stmt.setLong(2, messageRef.messageId);
                    stmt.setString(3, messageRef.getPersistentKey());
                    int rc = stmt.executeUpdate();
                    if (rc != 1) {
                        throw new SpyJMSException("Could not update the message in the database: update affected " + rc + " rows");
                    }
                } else {
                    throw new SpyJMSException("NYI: Updating a message in a transaction is not currently used");
                }
                if (!trace) break block21;
                this.log.trace((Object)("Updated message " + messageRef + " transaction=" + txId));
            }
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block24;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not update message: " + messageRef, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not update message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        block30: {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("Removing message " + messageRef + " transaction=" + txId));
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            this.insertPersistentTx(tms, c, txId);
            MessageReference messageReference = messageRef;
            synchronized (messageReference) {
                if (txId == null) {
                    stmt = c.prepareStatement(this.DELETE_MESSAGE);
                    stmt.setLong(1, messageRef.messageId);
                    stmt.setString(2, messageRef.getPersistentKey());
                    messageRef.setStored(1);
                    messageRef.removeDelayed();
                } else {
                    stmt = c.prepareStatement(this.MARK_MESSAGE);
                    stmt.setLong(1, txId.longValue());
                    stmt.setString(2, "D");
                    stmt.setLong(3, messageRef.messageId);
                    stmt.setString(4, messageRef.getPersistentKey());
                }
                int tries = 0;
                while (true) {
                    try {
                        int rc = stmt.executeUpdate();
                        if (tries <= 0) break;
                        if (rc != 1) {
                            throw new SpyJMSException("Could not mark the message as deleted in the database: update affected " + rc + " rows");
                        }
                        this.log.warn((Object)("Remove operation worked after " + tries + " retries"));
                    }
                    catch (SQLException e) {
                        this.log.warn((Object)("SQLException caught - assuming deadlock detected, try:" + (tries + 1)), (Throwable)e);
                        if (++tries >= this.statementRetries) {
                            this.log.error((Object)("Retried " + tries + " times, now giving up"));
                            throw new IllegalStateException("Could not remove message after " + tries + "attempts");
                        }
                        this.log.warn((Object)"Trying again after a pause");
                        Thread.sleep((long)(Math.random() * 500.0));
                        continue;
                    }
                    break;
                }
                if (trace) {
                    this.log.trace((Object)("Removed message " + messageRef + " transaction=" + txId));
                }
            }
            Object var13_14 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block30;
            {
                catch (Exception e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not remove message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpyMessage loadFromStorage(MessageReference messageRef) throws JMSException {
        block39: {
            block38: {
                block37: {
                    block30: {
                        block36: {
                            block35: {
                                block34: {
                                    block29: {
                                        if (this.log.isTraceEnabled()) {
                                            this.log.trace((Object)("Loading message from storage " + messageRef));
                                        }
                                        tms = new TransactionManagerStrategy();
                                        tms.startTX();
                                        c = null;
                                        stmt = null;
                                        rs = null;
                                        threadWasInterrupted = Thread.interrupted();
                                        try {
                                            try {
                                                c = this.getConnection();
                                                stmt = c.prepareStatement(this.SELECT_MESSAGE);
                                                stmt.setLong(1, messageRef.messageId);
                                                stmt.setString(2, messageRef.getPersistentKey());
                                                rs = stmt.executeQuery();
                                                if (rs.next()) {
                                                    var7_7 = this.extractMessage(rs);
                                                    var9_11 = null;
                                                    break block29;
                                                }
                                                var7_8 = null;
                                                break block30;
                                            }
                                            catch (IOException e) {
                                                tms.setRollbackOnly();
                                                throw new SpyJMSException("Could not load message : " + messageRef, e);
                                            }
                                            catch (SQLException e) {
                                                tms.setRollbackOnly();
                                                throw new SpyJMSException("Could not load message : " + messageRef, e);
                                            }
                                        }
                                        catch (Throwable var8_17) {
                                            var9_13 = null;
                                            try {
                                                if (rs != null) {
                                                    rs.close();
                                                }
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                if (stmt != null) {
                                                    stmt.close();
                                                }
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                if (c != null) {
                                                    c.close();
                                                }
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            tms.endTX();
                                            if (threadWasInterrupted == false) throw var8_17;
                                            Thread.currentThread().interrupt();
                                            throw var8_17;
                                        }
                                    }
                                    ** try [egrp 2[TRYBLOCK] [7 : 228->243)] { 
lbl60:
                                    // 1 sources

                                    if (rs != null) {
                                        rs.close();
                                    }
                                    break block34;
lbl63:
                                    // 1 sources

                                    catch (Throwable ignore) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [8 : 245->260)] { 
lbl67:
                                // 1 sources

                                if (stmt != null) {
                                    stmt.close();
                                }
                                break block35;
lbl70:
                                // 1 sources

                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [9 : 262->275)] { 
lbl74:
                            // 1 sources

                            if (c != null) {
                                c.close();
                            }
                            break block36;
lbl77:
                            // 1 sources

                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        tms.endTX();
                        if (threadWasInterrupted == false) return var7_7;
                        Thread.currentThread().interrupt();
                        return var7_7;
                    }
                    var9_12 = null;
                    ** try [egrp 2[TRYBLOCK] [7 : 228->243)] { 
lbl87:
                    // 1 sources

                    if (rs != null) {
                        rs.close();
                    }
                    break block37;
lbl90:
                    // 1 sources

                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [8 : 245->260)] { 
lbl94:
                // 1 sources

                if (stmt != null) {
                    stmt.close();
                }
                break block38;
lbl97:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            ** try [egrp 4[TRYBLOCK] [9 : 262->275)] { 
lbl101:
            // 1 sources

            if (c != null) {
                c.close();
            }
            break block39;
lbl104:
            // 1 sources

            catch (Throwable ignore) {
                // empty catch block
            }
        }
        tms.endTX();
        if (threadWasInterrupted == false) return var7_8;
        Thread.currentThread().interrupt();
        return var7_8;
    }

    /*
     * Loose catch block
     */
    public void removeFromStorage(MessageReference messageRef) throws JMSException {
        block21: {
            boolean threadWasInterrupted;
            PreparedStatement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block18: {
                if (messageRef.isPersistent()) {
                    return;
                }
                boolean trace = this.log.isTraceEnabled();
                if (trace) {
                    this.log.trace((Object)("Removing message from storage " + messageRef));
                }
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                stmt = c.prepareStatement(this.DELETE_MESSAGE);
                stmt.setLong(1, messageRef.messageId);
                stmt.setString(2, messageRef.getPersistentKey());
                stmt.executeUpdate();
                messageRef.setStored(1);
                if (!trace) break block18;
                this.log.trace((Object)("Removed message from storage " + messageRef));
            }
            Object var9_7 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block21;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not remove message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void saveToStorage(MessageReference messageRef, SpyMessage message) throws JMSException {
        block16: {
            boolean threadWasInterrupted;
            Connection c;
            TransactionManagerStrategy tms;
            block14: {
                if (messageRef.isPersistent()) {
                    return;
                }
                boolean trace = this.log.isTraceEnabled();
                if (trace) {
                    this.log.trace((Object)("Saving message to storage " + messageRef));
                }
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                this.add(c, messageRef.getPersistentKey(), message, null, "T");
                messageRef.setStored(2);
                if (!trace) break block14;
                this.log.trace((Object)("Saved message to storage " + messageRef));
            }
            Object var9_7 = null;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block16;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection getConnection() throws SQLException {
        int attempts = this.connectionRetryAttempts;
        int attemptCount = 0;
        SQLException sqlException = null;
        while (attempts-- > 0) {
            block14: {
                Connection connection;
                block13: {
                    Object var6_7;
                    if (++attemptCount > 1) {
                        this.log.debug((Object)("Retrying connection: attempt # " + attemptCount));
                    }
                    try {
                        block12: {
                            try {
                                sqlException = null;
                                connection = this.datasource.getConnection();
                                var6_7 = null;
                                if (sqlException != null) return connection;
                                if (attemptCount <= 1) break block12;
                                break block13;
                            }
                            catch (SQLException exception) {
                                this.log.debug((Object)("Connection attempt # " + attemptCount + " failed with SQLException"), (Throwable)exception);
                                sqlException = exception;
                                var6_7 = null;
                                if (sqlException == null && attemptCount > 1) {
                                    this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                                }
                                break block14;
                            }
                        }
                        return connection;
                    }
                    catch (Throwable throwable) {
                        var6_7 = null;
                        if (sqlException != null || attemptCount <= 1) throw throwable;
                        this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                        throw throwable;
                    }
                }
                this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                return connection;
            }
            if (attempts <= 0) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (sqlException == null) throw new SQLException("connection attempt interrupted");
        throw sqlException;
    }

    public void startService() throws Exception {
        this.UPDATE_MARKED_MESSAGES = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES", this.UPDATE_MARKED_MESSAGES);
        this.UPDATE_MARKED_MESSAGES_XARECOVERY = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES_XARECOVERY", this.UPDATE_MARKED_MESSAGES_XARECOVERY);
        this.UPDATE_MARKED_MESSAGES_WITH_TX = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES_WITH_TX", this.UPDATE_MARKED_MESSAGES_WITH_TX);
        this.DELETE_MARKED_MESSAGES_WITH_TX = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES_WITH_TX", this.DELETE_MARKED_MESSAGES_WITH_TX);
        this.DELETE_MARKED_MESSAGES_WITH_TX_XARECOVERY = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES_WITH_TX_XARECOVERY", this.DELETE_MARKED_MESSAGES_WITH_TX_XARECOVERY);
        this.DELETE_TX = this.sqlProperties.getProperty("DELETE_TX", this.DELETE_TX);
        this.DELETE_MARKED_MESSAGES = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES", this.DELETE_MARKED_MESSAGES);
        this.DELETE_TEMPORARY_MESSAGES = this.sqlProperties.getProperty("DELETE_TEMPORARY_MESSAGES", this.DELETE_TEMPORARY_MESSAGES);
        this.INSERT_TX = this.sqlProperties.getProperty("INSERT_TX", this.INSERT_TX);
        this.INSERT_TX_XARECOVERY = this.sqlProperties.getProperty("INSERT_TX_XARECOVERY", this.INSERT_TX_XARECOVERY);
        this.DELETE_ALL_TX = this.sqlProperties.getProperty("DELETE_ALL_TX", this.DELETE_ALL_TX);
        this.DELETE_ALL_TX_XARECOVERY = this.sqlProperties.getProperty("DELETE_ALL_TX_XARECOVERY", this.DELETE_ALL_TX_XARECOVERY);
        this.SELECT_ALL_TX_XARECOVERY = this.sqlProperties.getProperty("SELECT_ALL_TX_XARECOVERY", this.SELECT_ALL_TX_XARECOVERY);
        this.SELECT_MAX_TX = this.sqlProperties.getProperty("SELECT_MAX_TX", this.SELECT_MAX_TX);
        this.SELECT_MESSAGES_IN_DEST = this.sqlProperties.getProperty("SELECT_MESSAGES_IN_DEST", this.SELECT_MESSAGES_IN_DEST);
        this.SELECT_MESSAGES_IN_DEST_XARECOVERY = this.sqlProperties.getProperty("SELECT_MESSAGES_IN_DEST_XARECOVERY", this.SELECT_MESSAGES_IN_DEST_XARECOVERY);
        this.SELECT_MESSAGE_KEYS_IN_DEST = this.sqlProperties.getProperty("SELECT_MESSAGE_KEYS_IN_DEST", this.SELECT_MESSAGE_KEYS_IN_DEST);
        this.SELECT_MESSAGE = this.sqlProperties.getProperty("SELECT_MESSAGE", this.SELECT_MESSAGE);
        this.SELECT_MESSAGE_XARECOVERY = this.sqlProperties.getProperty("SELECT_MESSAGE_XARECOVERY", this.SELECT_MESSAGE_XARECOVERY);
        this.INSERT_MESSAGE = this.sqlProperties.getProperty("INSERT_MESSAGE", this.INSERT_MESSAGE);
        this.MARK_MESSAGE = this.sqlProperties.getProperty("MARK_MESSAGE", this.MARK_MESSAGE);
        this.DELETE_MESSAGE = this.sqlProperties.getProperty("DELETE_MESSAGE", this.DELETE_MESSAGE);
        this.UPDATE_MESSAGE = this.sqlProperties.getProperty("UPDATE_MESSAGE", this.UPDATE_MESSAGE);
        this.CREATE_MESSAGE_TABLE = this.sqlProperties.getProperty("CREATE_MESSAGE_TABLE", this.CREATE_MESSAGE_TABLE);
        this.CREATE_IDX_MESSAGE_TXOP_TXID = this.sqlProperties.getProperty("CREATE_IDX_MESSAGE_TXOP_TXID", this.CREATE_IDX_MESSAGE_TXOP_TXID);
        this.CREATE_IDX_MESSAGE_DESTINATION = this.sqlProperties.getProperty("CREATE_IDX_MESSAGE_DESTINATION", this.CREATE_IDX_MESSAGE_DESTINATION);
        this.CREATE_TX_TABLE = this.sqlProperties.getProperty("CREATE_TX_TABLE", this.CREATE_TX_TABLE);
        this.CREATE_TX_TABLE_XARECOVERY = this.sqlProperties.getProperty("CREATE_TX_TABLE_XARECOVERY", this.CREATE_TX_TABLE_XARECOVERY);
        this.createTables = this.sqlProperties.getProperty("CREATE_TABLES_ON_STARTUP", "true").equalsIgnoreCase("true");
        String s = this.sqlProperties.getProperty("BLOB_TYPE", "OBJECT_BLOB");
        if (s.equals("OBJECT_BLOB")) {
            this.blobType = 0;
        } else if (s.equals("BYTES_BLOB")) {
            this.blobType = 1;
        } else if (s.equals("BINARYSTREAM_BLOB")) {
            this.blobType = 2;
        } else if (s.equals("BLOB_BLOB")) {
            this.blobType = 3;
        }
        this.initializeFields();
        this.log.debug((Object)"Creating Schema");
        try {
            this.createSchema();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error creating schema", (Throwable)e);
        }
        this.log.debug((Object)"Resolving uncommited TXS");
        Throwable error = null;
        for (int i = 0; i <= this.recoveryRetries; ++i) {
            try {
                this.resolveAllUncommitedTXs();
                break;
            }
            catch (Throwable t) {
                if (i < this.recoveryRetries) {
                    this.log.warn((Object)("Error resolving transactions retries=" + i + " of " + this.recoveryRetries), t);
                    continue;
                }
                error = t;
                continue;
            }
        }
        if (error != null) {
            SpyJMSException.rethrowAsJMSException("Unable to resolve transactions retries=" + this.recoveryRetries, error);
        }
    }

    protected void initializeFields() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, NamingException {
        String dsName = (String)this.getServer().getAttribute(this.connectionManagerName, "BindName");
        InitialContext ctx = new InitialContext();
        this.datasource = (DataSource)ctx.lookup(dsName);
        this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public void setMessageCache(ObjectName messageCache) {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public ObjectName getConnectionManager() {
        return this.connectionManagerName;
    }

    public void setConnectionManager(ObjectName connectionManagerName) {
        this.connectionManagerName = connectionManagerName;
    }

    public MessageCache getMessageCacheInstance() {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setConnectionRetryAttempts(int value) {
        this.connectionRetryAttempts = value;
    }

    public int getConnectionRetryAttempts() {
        return this.connectionRetryAttempts;
    }

    public int getRecoveryTimeout() {
        return this.recoveryTimeout;
    }

    public void setRecoveryTimeout(int timeout) {
        this.recoveryTimeout = timeout;
    }

    public int getRecoveryRetries() {
        return this.recoveryRetries;
    }

    public void setRecoveryRetries(int retries) {
        this.recoveryRetries = retries;
    }

    public int getRecoverMessagesChunk() {
        return this.recoverMessagesChunk;
    }

    public void setRecoverMessagesChunk(int recoverMessagesChunk) {
        if (recoverMessagesChunk != 0 && recoverMessagesChunk != 1) {
            this.log.warn((Object)"Only the values 0 and 1 are currently support for chunk size, using chunk size=1");
            recoverMessagesChunk = 1;
        }
        this.recoverMessagesChunk = recoverMessagesChunk;
    }

    public boolean isXARecovery() {
        return this.xaRecovery;
    }

    public void setXARecovery(boolean xaRecovery) {
        this.xaRecovery = xaRecovery;
    }

    public int getStatementRetries() {
        return this.statementRetries;
    }

    public void setStatementRetries(int statementRetries) {
        if (statementRetries < 0) {
            statementRetries = 0;
        }
        this.statementRetries = statementRetries;
    }

    protected class TransactionManagerStrategy {
        Transaction threadTx;

        protected TransactionManagerStrategy() {
        }

        void startTX() throws JMSException {
            try {
                this.threadTx = PersistenceManager.this.tm.suspend();
                PersistenceManager.this.tm.begin();
            }
            catch (Exception e) {
                try {
                    if (this.threadTx != null) {
                        PersistenceManager.this.tm.resume(this.threadTx);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
            }
        }

        void setRollbackOnly() throws JMSException {
            try {
                PersistenceManager.this.tm.setRollbackOnly();
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not start a mark the transaction for rollback .", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void endTX() throws JMSException {
            try {
                try {
                    if (PersistenceManager.this.tm.getStatus() == 1) {
                        PersistenceManager.this.tm.rollback();
                    } else {
                        PersistenceManager.this.tm.commit();
                    }
                }
                catch (Exception e) {
                    throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    if (this.threadTx == null) throw throwable;
                    PersistenceManager.this.tm.resume(this.threadTx);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            if (this.threadTx == null) return;
            PersistenceManager.this.tm.resume(this.threadTx);
            return;
        }
    }
}

