/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;

abstract class CIMQualifiedElement
extends CIMElement {
    protected Vector qualifiers = new Vector();

    public CIMQualifiedElement(String elementName) {
        super(elementName);
    }

    public void setQualifiers(Vector qualifiers) {
        this.qualifiers = qualifiers;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void addQualifier(CIMQualifier cq) throws CIMException {
        if (this.getQualifier(cq.getName()) != null) {
            throw new CIMException("Element " + this.getName() + " already has qualifier " + cq.getName());
        }
        this.qualifiers.addElement(cq);
    }

    public boolean removeQualifier(String name) {
        return this.qualifiers.removeElement(new CIMQualifier(name));
    }

    public CIMQualifier setQualifier(CIMQualifier qualifier) throws CIMException {
        return this.setQualifier(qualifier.getName(), qualifier.getValue());
    }

    public CIMQualifier setQualifier(String name, CIMValue value) throws CIMException {
        CIMQualifier qe = this.getQualifier(name);
        if (qe == null) {
            throw new CIMException("Element " + this.getName() + " does not have qualifier " + name);
        }
        qe.setValue(value);
        return qe;
    }

    public CIMQualifier getQualifier(String name) {
        if (name == null) {
            return null;
        }
        Enumeration enumQualifiers = this.qualifiers.elements();
        while (enumQualifiers.hasMoreElements()) {
            CIMQualifier qualifier = (CIMQualifier)enumQualifiers.nextElement();
            if (!qualifier.getName().equalsIgnoreCase(name)) continue;
            return qualifier;
        }
        return null;
    }

    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }
}

