/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.cimxml.XmlElement;
import javax.wbem.client.adapter.http.DtdResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XmlInstance
extends XmlElement {
    static final String ARRAYSIZE = "ARRAYSIZE";
    static final String ASSOCIATION = "ASSOCIATION";
    static final String CIMVERSION = "CIMVERSION";
    private static final String CIMVERSIONSTRING = "2.0";
    static final String CLASSORIGIN = "CLASSORIGIN";
    static final String CODE = "CODE";
    static final String DESCRIPTION = "DESCRIPTION";
    private static final String DTDVERSION = "DTDVERSION";
    private static final String DTDVERSIONSTRING = "2.0";
    static final String EMBEDDEDOBJECT = "EmbeddedObject";
    static final String ID = "ID";
    static final String INDICATION = "INDICATION";
    static final String ISARRAY = "ISARRAY";
    static final String METHOD = "METHOD";
    static final String NAME = "NAME";
    static final String OVERRIDABLE = "OVERRIDABLE";
    static final String PARAMETER = "PARAMETER";
    static final String PROTOCOLVERSION = "PROTOCOLVERSION";
    static final String PROTOCOLVERSIONSTRING = "1.0";
    static final String PROPAGATED = "PROPAGATED";
    static final String PROPERTY = "PROPERTY";
    static final String REFERENCE = "REFERENCE";
    static final String REFERENCECLASS = "REFERENCECLASS";
    static final String SUPERCLASS = "SUPERCLASS";
    static final String TOSUBCLASS = "TOSUBCLASS";
    static final String TRANSLATABLE = "TRANSLATABLE";
    static final String TYPE = "TYPE";
    static final String VALUETYPE = "VALUETYPE";
    static final String PARAMTYPE = "PARAMTYPE";
    static final String XMLERROR = "XMLERROR";
    static final String CNAME = "__Namespace";
    private static final String REFERENCETYPE = "reference";
    static final String TRUE = "true";
    static final String FALSE = "false";
    static final String LOOPBACK_ADDRESS = "127.0.0.1";
    DtdResolver resolver = null;
    private static final String SYSTEMID = "http://www.dmtf.org/cim/mapping/xml/v2.0";
    private static final String PUBLICID = "-//DMTF//DTD CIM 2.0//EN";
    private static final String NEWINDICATION = "NewIndication";
    private boolean validate = false;
    boolean sendDoctype = System.getProperty("setdoctype") != null ? "true".equalsIgnoreCase(System.getProperty("setdoctype")) : false;

    public XmlInstance() {
    }

    public XmlInstance(boolean showImplied) {
        super(showImplied);
    }

    public XmlInstance(boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        super(includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public XmlInstance(boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied, boolean showDefault, boolean showHost, boolean showNamespace) {
        super(includeQualifiers, includeClassOrigin, propertyList, showImplied, showDefault, showHost, showNamespace);
    }

    Document pcdata2Xml(String pcdata) throws SAXException, IOException, ParserConfigurationException {
        InputSource input = new InputSource(new StringReader(pcdata));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(this.validate);
        if (this.resolver == null) {
            this.resolver = new DtdResolver();
            this.resolver.registerCatalogEntry(PUBLICID, "javax/wbem/client/adapter/http/cim20.dtd", this.getClass().getClassLoader());
        }
        DocumentBuilder builder = dbf.newDocumentBuilder();
        builder.setEntityResolver(this.resolver);
        return builder.parse(input);
    }

    String xml2Pcdata(Document doc) throws IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            String systemId;
            Transformer transformer = tFactory.newTransformer();
            DocumentType docType = doc.getDoctype();
            if (docType != null && (systemId = docType.getSystemId()) != null) {
                String systemValue = new File(systemId).getName();
                transformer.setOutputProperty("doctype-system", systemValue);
            }
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    void setCIMName(String name) {
        this.setAttr(NAME, name);
    }

    void setCIMName(CIMElement ce) {
        this.setCIMName(ce.getName());
    }

    private void setCIMType(CIMDataType cdt) {
        if (cdt != null && !cdt.isReferenceType()) {
            this.setAttr(TYPE, this.getCIMType(cdt));
        }
    }

    private String getCIMType(CIMDataType cdt) {
        String type = null;
        if (cdt == null) {
            return type;
        }
        if (!cdt.isReferenceType()) {
            type = cdt.toString().toLowerCase();
            if (type.indexOf("_") > 0) {
                type = type.substring(0, type.indexOf("_"));
            } else if (type.indexOf("[") > 0) {
                type = type.substring(0, type.indexOf("["));
            }
        } else {
            type = REFERENCETYPE;
        }
        return type;
    }

    private void setParamType(CIMDataType cdt) {
        this.setAttr(PARAMTYPE, this.getCIMType(cdt));
    }

    private void setQualifierFlavor(CIMQualifier cq) {
        if (cq.hasFlavor(new CIMFlavor(1))) {
            this.setAttr(OVERRIDABLE, FALSE);
        } else if (this.getShowDefault()) {
            this.setAttr(OVERRIDABLE, TRUE);
        }
        if (cq.hasFlavor(new CIMFlavor(2))) {
            this.setAttr(TOSUBCLASS, FALSE);
        } else if (this.getShowDefault()) {
            this.setAttr(TOSUBCLASS, TRUE);
        }
        if (cq.hasFlavor(new CIMFlavor(4))) {
            this.setAttr(TRANSLATABLE, TRUE);
        } else if (this.getShowDefault()) {
            this.setAttr(TRANSLATABLE, FALSE);
        }
    }

    private void setClassOrigin(String origin) {
        boolean haveOrigin;
        boolean bl = haveOrigin = origin != null && origin.length() > 0;
        if (haveOrigin && (this.getIncludeClassOrigin() || this.getShowImplied())) {
            this.setAttr(CLASSORIGIN, origin);
        }
    }

    private void setClassOrigin(CIMProperty cp) {
        if (this.getIncludeClassOrigin() || this.getShowImplied()) {
            this.setClassOrigin(cp.getOriginClass());
        }
    }

    private void setClassOrigin(CIMMethod cm) {
        if (this.getIncludeClassOrigin() || this.getShowImplied()) {
            this.setClassOrigin(cm.getOriginClass());
        }
    }

    private void setPropagated(boolean propagated) {
        String s;
        String string = s = propagated ? TRUE : FALSE;
        if (this.getShowDefault() || propagated) {
            this.setAttr(PROPAGATED, s);
        }
    }

    private void setPropagated(CIMProperty cp, String name) {
        if (cp.isPropagated()) {
            this.setPropagated(true);
        } else {
            this.setPropagated(false);
        }
    }

    private void setPropagated(CIMQualifier cq) {
        this.setPropagated(false);
    }

    private void setPropagated(CIMMethod cm, String name) {
        if (name.equals(cm.getOriginClass())) {
            this.setPropagated(false);
        } else {
            this.setPropagated(true);
        }
    }

    private void setSuperClass(String name) {
        if (this.getShowImplied()) {
            this.setAttr(SUPERCLASS, name);
        }
    }

    private void setSuperClass(CIMClass cc) {
        String name;
        if (this.getShowImplied() && (name = cc.getSuperClass()).length() != 0) {
            this.setSuperClass(name);
        }
    }

    private void setClassName(String name) {
        this.setAttr("CLASSNAME", name);
    }

    private void setClassName(CIMInstance ci) {
        String name = ci.getClassName();
        if (name.length() != 0) {
            this.setClassName(name);
        }
    }

    private void setReferenceClass(String name) {
        if (this.getShowImplied()) {
            this.setAttr(REFERENCECLASS, name);
        }
    }

    private void setReferenceClass(CIMProperty cp) {
        if (this.getShowImplied()) {
            this.setReferenceClass(cp.getType().getRefClassName());
        }
    }

    private void setReferenceClass(CIMParameter cp) {
        if (this.getShowImplied()) {
            this.setReferenceClass(cp.getType().getRefClassName());
        }
    }

    protected String root(String body) {
        String xmlHeader = "";
        if (this.sendDoctype) {
            xmlHeader = "<!DOCTYPE CIM PUBLIC '-//DMTF//DTD CIM 2.0//EN' 'http://www.dmtf.org/cim/mapping/xml/v2.0'>\n";
        }
        this.setAttr(CIMVERSION, "2.0");
        this.setAttr(DTDVERSION, "2.0");
        return xmlHeader + this.stag("CIM") + body + this.etag();
    }

    private String value(String pcdata) {
        return this.stag("VALUE") + this.pcdata(pcdata) + this.etag();
    }

    private String value(String[] pcdata) {
        StringBuffer Xml = new StringBuffer();
        Xml.append(this.stag("VALUE.ARRAY"));
        for (int i = 0; i < pcdata.length; ++i) {
            Xml.append(this.value(pcdata[i]));
        }
        return Xml.toString() + this.etag();
    }

    private String value(boolean value) {
        return this.stag("VALUE") + (value ? "TRUE" : "FALSE") + this.etag();
    }

    protected String value(CIMValue cv) {
        if (cv == null || cv.getValue() == null) {
            return "";
        }
        if (cv.getType() != null && cv.getType().isArrayType()) {
            if (42 == cv.getType().getType()) {
                return this.valueRefArray(cv);
            }
            return this.valueArray(cv);
        }
        return this.stag("VALUE") + this.pcdata(cv) + this.etag();
    }

    private String value(Vector values) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            CIMValue cv = new CIMValue(values.elementAt(i));
            Xml.append(this.value(cv));
        }
        return Xml.toString();
    }

    private String value(CIMProperty cp) {
        if (cp.isReference()) {
            return this.valueReference(cp.getValue());
        }
        if (cp.getValue() != null) {
            return this.value(cp.getValue());
        }
        return "";
    }

    private String quoted(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            if (pcdata.charAt(i) == '\\' || pcdata.charAt(i) == '\"') {
                buf.append("\\");
            }
            buf.append(pcdata.charAt(i));
        }
        return buf.toString();
    }

    private boolean hasMarkup(String pcdata) {
        return pcdata.indexOf("<") != -1 || pcdata.indexOf("&") != -1 || pcdata.indexOf("\"") != -1 || pcdata.indexOf(">") != -1 || pcdata.indexOf("'") != -1;
    }

    private String cdata(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        block7: for (int i = 0; i < pcdata.length(); ++i) {
            switch (pcdata.charAt(i)) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                default: {
                    buf.append(pcdata.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    private String pcdata(String pcdata) {
        String Xml = pcdata;
        if (this.hasMarkup(pcdata)) {
            Xml = this.cdata(pcdata);
        }
        return Xml;
    }

    private String pcdata(CIMValue cv) {
        if (cv == null) {
            return "";
        }
        if (cv.getType() != null && cv.getType().isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (cv.getValue() == null) {
            return "";
        }
        Object obj = cv.getValue();
        if (obj instanceof CIMInstance) {
            return this.pcdata(this.quoted(this.instance((CIMInstance)obj)));
        }
        if (obj instanceof CIMClass) {
            return this.pcdata(this.quoted(this.cimClass((CIMClass)obj)));
        }
        return this.pcdata(obj.toString());
    }

    private String valueArray(CIMValue cv) {
        return this.stag("VALUE.ARRAY") + this.value((Vector)cv.getValue()) + this.etag();
    }

    private String valueReference(CIMObjectPath cop) {
        String ns = cop.getNameSpace();
        String host = cop.getHost();
        boolean haveNs = ns != null && ns.length() > 0;
        boolean haveHost = host != null && host.length() > 0;
        boolean bShowNamespace = this.getShowNamespace();
        boolean bShowHost = this.getShowHost();
        if (haveHost) {
            this.setShowHost(true);
        } else if (haveNs) {
            this.setShowNamespace(true);
        }
        String x = this.stag("VALUE.REFERENCE") + this.pickObjectName(cop) + this.etag();
        this.setShowHost(bShowHost);
        this.setShowNamespace(bShowNamespace);
        return x;
    }

    private String valueReference(CIMValue cv) {
        CIMObjectPath cop = new CIMObjectPath();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        return this.valueReference(cop);
    }

    private String valueRefArray(CIMValue cv) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.stag("VALUE.REFARRAY"));
        Vector vCOPs = (Vector)cv.getValue();
        Enumeration eCOPs = vCOPs.elements();
        while (eCOPs.hasMoreElements()) {
            CIMObjectPath cop = (CIMObjectPath)eCOPs.nextElement();
            sb.append(this.valueReference(cop));
        }
        sb.append(this.etag());
        return sb.toString();
    }

    protected String valueObject(Object obj) {
        return this.stag("VALUE.OBJECT") + this.object(obj) + this.etag();
    }

    protected String valueNamedInstance(CIMInstance ci) {
        return this.stag("VALUE.NAMEDINSTANCE") + this.instanceName(ci) + this.instance(ci) + this.etag();
    }

    private String valueNamedInstance(CIMObjectPath name, CIMInstance ci) {
        return this.stag("VALUE.NAMEDINSTANCE") + this.instanceName(name) + this.instance(ci) + this.etag();
    }

    protected String valueObjectWithPath(Object obj, CIMNameSpace ns) {
        return this.stag("VALUE.OBJECTWITHPATH") + this.objectWithPath(obj, ns) + this.etag();
    }

    private String pickObjectName(CIMObjectPath cop) {
        if (this.getShowHost()) {
            return this.objectPath(cop, false);
        }
        if (this.getShowNamespace()) {
            return this.localObjectPath(cop);
        }
        return this.objectName(cop);
    }

    protected String localObjectPath(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            return this.localInstancePath(cop);
        }
        return this.localClassPath(cop);
    }

    private String objectName(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            return this.instanceName(cop);
        }
        return this.className(cop);
    }

    private String nameSpacePath(CIMObjectPath cop) {
        boolean haveHost;
        String host = cop.getHost();
        boolean bl = haveHost = host != null && host.length() > 0;
        if (!haveHost) {
            host = "localhost";
            try {
                host = this.getLocalIPAddress();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.stag("NAMESPACEPATH") + this.host(host) + this.localNameSpacePath(cop) + this.etag();
    }

    private String localNameSpacePath(String ns) {
        StringBuffer Xml = new StringBuffer(this.stag("LOCALNAMESPACEPATH"));
        int i = ns.indexOf(47);
        while (i >= 0) {
            if (i != 0) {
                Xml.append(this.nameSpace(ns.substring(0, i)));
            }
            ns = ns.substring(i + 1);
            i = ns.indexOf(47);
        }
        return Xml.toString() + this.nameSpace(ns) + this.etag();
    }

    protected String localNameSpacePath(CIMNameSpace cns) {
        return this.localNameSpacePath(cns.getNameSpace());
    }

    protected String localNameSpacePath(CIMObjectPath cop) {
        return this.localNameSpacePath(cop.getNameSpace());
    }

    private String host(String name) {
        return this.stag("HOST") + this.pcdata(name) + this.etag();
    }

    private String nameSpace(String name) {
        this.setCIMName(name);
        return this.otag("NAMESPACE");
    }

    private String classPath(CIMObjectPath cop) {
        return this.stag("CLASSPATH") + this.nameSpacePath(cop) + this.className(cop.getObjectName()) + this.etag();
    }

    private String localClassPath(CIMObjectPath cop) {
        return this.stag("LOCALCLASSPATH") + this.localNameSpacePath(cop) + this.className(cop) + this.etag();
    }

    protected String className(String name) {
        this.setCIMName(name);
        return this.otag("CLASSNAME");
    }

    protected String className(CIMClass cc) {
        return this.className(cc.getName());
    }

    private String className(CIMObjectPath cop) {
        String name = cop.getObjectName();
        if (name != "") {
            return this.className(name);
        }
        return "";
    }

    private String instancePath(CIMObjectPath cop) {
        return this.stag("INSTANCEPATH") + this.nameSpacePath(cop) + this.instanceName(cop) + this.etag();
    }

    private String localInstancePath(CIMObjectPath cop) {
        return this.stag("LOCALINSTANCEPATH") + this.localNameSpacePath(cop) + this.instanceName(cop) + this.etag();
    }

    private String instanceName(Vector cp, String name) {
        String keybinding = this.keyBinding(cp);
        this.setClassName(name);
        return this.stag("INSTANCENAME") + keybinding + this.etag();
    }

    protected String instanceName(CIMObjectPath cop) {
        return this.instanceName(cop.getKeys(), cop.getObjectName());
    }

    protected String instanceName(CIMInstance ci) {
        return this.instanceName(ci.getKeys(), ci.getClassName());
    }

    protected String objectPath(CIMObjectPath cop) {
        return this.objectPath(cop, true);
    }

    private String objectPath(CIMObjectPath cop, boolean includetype) {
        StringBuffer Xml = new StringBuffer();
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            Xml.append(this.instancePath(cop));
        } else {
            Xml.append(this.classPath(cop));
        }
        if (includetype) {
            Xml = new StringBuffer(this.stag("OBJECTPATH") + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String keyBinding(CIMProperty cp) {
        this.setCIMName(cp);
        StringBuffer Xml = new StringBuffer(this.stag("KEYBINDING"));
        if (cp.isReference()) {
            Xml.append(this.valueReference(cp.getValue()));
        } else {
            Xml.append(this.keyValue(cp));
        }
        return Xml.toString() + this.etag();
    }

    String keyBinding(Vector cp) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cp.size(); ++i) {
            if (!(cp.elementAt(i) instanceof CIMProperty)) continue;
            CIMProperty p = (CIMProperty)cp.elementAt(i);
            Xml.append(this.keyBinding(p));
        }
        return Xml.toString();
    }

    private void setValueType(CIMDataType cdt) {
        String type = this.getCIMType(cdt);
        if (type == null) {
            return;
        }
        type = type.equals("string") || type.equals("datetime") || type.equals("char16") ? "string" : (type.equals("boolean") ? "boolean" : "numeric");
        this.setAttr(VALUETYPE, type);
    }

    String keyValue(CIMProperty cp) {
        this.setCIMType(cp.getType());
        this.setValueType(cp.getType());
        return this.stag("KEYVALUE") + (cp.getValue() == null ? "" : this.pcdata(cp.getValue())) + this.etag();
    }

    String object(Object obj) {
        if (obj instanceof CIMClass) {
            return this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instance((CIMInstance)obj);
        }
        return "";
    }

    String namedObject(Object obj) {
        if (obj instanceof CIMClass) {
            return this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.instanceName((CIMInstance)obj) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    String objectWithPath(Object obj, CIMNameSpace ns) {
        if (obj instanceof CIMClass) {
            CIMClass cl = (CIMClass)obj;
            if (cl.getObjectPath().getNameSpace() == null || cl.getObjectPath().getNameSpace().length() == 0) {
                cl.setObjectPath(new CIMObjectPath(cl.getName(), ns.getNameSpace()));
            }
            return this.classPath(cl.getObjectPath()) + this.cimClass(cl);
        }
        if (obj instanceof CIMInstance) {
            CIMInstance iop = (CIMInstance)obj;
            if (iop.getObjectPath().getNameSpace() == null || iop.getObjectPath().getNameSpace().length() == 0) {
                iop.setObjectPath(new CIMObjectPath(iop.getClassName(), ns.getNameSpace()));
            }
            return this.instancePath(iop.getObjectPath()) + this.instance(iop);
        }
        return "";
    }

    String objectWithLocalPath(Object obj) {
        if (obj instanceof CIMClass) {
            return this.localClassPath(new CIMObjectPath()) + this.cimClass((CIMClass)obj);
        }
        if (obj instanceof CIMInstance) {
            return this.localInstancePath(new CIMObjectPath()) + this.instance((CIMInstance)obj);
        }
        return "";
    }

    String cimClass(CIMClass cc) {
        this.setCIMName(cc);
        this.setSuperClass(cc);
        return this.stag("CLASS") + this.qualifier(cc) + this.property(cc) + this.method(cc) + this.etag("CLASS");
    }

    protected String instance(CIMInstance ci) {
        this.setClassName(ci);
        return this.stag("INSTANCE") + this.qualifier(ci) + this.property(ci) + this.etag();
    }

    String qualifier(CIMQualifier q) {
        StringBuffer Xml = new StringBuffer();
        if (this.getIncludeQualifiers()) {
            this.setCIMName(q);
            if (q.getValue() != null) {
                this.setCIMType(q.getValue().getType());
            } else {
                CIMDataType cdt = new CIMDataType(9);
                this.setCIMType(cdt);
            }
            this.setPropagated(q);
            this.setQualifierFlavor(q);
            Xml = new StringBuffer(this.stag("QUALIFIER"));
            if (q.getValue() != null) {
                if (q.getValue().getType() != null && q.getValue().getType().isArrayType()) {
                    Xml.append(this.valueArray(q.getValue()));
                } else {
                    Xml.append(this.value(q.getValue()));
                }
            }
            Xml.append(this.etag("QUALIFIER"));
        }
        return Xml.toString();
    }

    String qualifier(Vector qualifiers) {
        StringBuffer Xml = new StringBuffer();
        if (this.getIncludeQualifiers()) {
            for (int i = 0; i < qualifiers.size(); ++i) {
                Xml.append(this.qualifier((CIMQualifier)qualifiers.elementAt(i)));
            }
        }
        return Xml.toString();
    }

    String qualifier(CIMClass cc) {
        return this.getIncludeQualifiers() ? this.qualifier(cc.getQualifiers()) : "";
    }

    String qualifier(CIMInstance ci) {
        return "";
    }

    String qualifier(CIMProperty cp) {
        return this.getIncludeQualifiers() ? this.qualifier(cp.getQualifiers()) : "";
    }

    String qualifier(CIMMethod cm) {
        return this.getIncludeQualifiers() ? this.qualifier(cm.getQualifiers()) : "";
    }

    String qualifier(CIMParameter cp) {
        return this.getIncludeQualifiers() ? this.qualifier(cp.getQualifiers()) : "";
    }

    String qualifierDeclaration(CIMQualifierType qt) {
        this.setCIMName(qt.getName());
        this.setCIMType(qt.getType());
        this.setAttr(ISARRAY, qt.isArrayValue() ? TRUE : FALSE);
        this.setQualifierFlavor(new CIMQualifier("", qt));
        return this.stag("QUALIFIER.DECLARATION") + this.scope(qt) + (qt.hasDefaultValue() && qt.getDefaultValue().getValue() != null ? this.value(qt.getDefaultValue()) : "") + this.etag();
    }

    String scope(CIMQualifierType qt) {
        boolean showscope = false;
        if (qt.hasScope(new CIMScope(1))) {
            this.setAttr("CLASS", TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr("CLASS", FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(2))) {
            this.setAttr(ASSOCIATION, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(ASSOCIATION, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(3))) {
            this.setAttr(INDICATION, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(INDICATION, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(4))) {
            this.setAttr(PROPERTY, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(PROPERTY, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(5))) {
            this.setAttr(REFERENCE, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(REFERENCE, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(6))) {
            this.setAttr(METHOD, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(METHOD, FALSE);
            showscope = true;
        }
        if (qt.hasScope(new CIMScope(7))) {
            this.setAttr(PARAMETER, TRUE);
            showscope = true;
        } else if (this.getShowDefault()) {
            this.setAttr(PARAMETER, FALSE);
            showscope = true;
        }
        return showscope ? this.otag("SCOPE") : "";
    }

    boolean includeProperty(String property) {
        if (this.PropertyList == null) {
            return true;
        }
        if (this.PropertyList.length == 0) {
            return false;
        }
        for (int i = 0; i < this.PropertyList.length; ++i) {
            if (!property.equalsIgnoreCase(this.PropertyList[i])) continue;
            return true;
        }
        return false;
    }

    String property(CIMProperty cp, String name) {
        if (cp.getOverridingProperty() != null) {
            return "";
        }
        if (!this.includeProperty(cp.getName())) {
            return "";
        }
        if (cp.getType() != null && cp.getType().isArrayType()) {
            return this.propertyArray(cp, name);
        }
        if (cp.isReference()) {
            return this.propertyReference(cp, name);
        }
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        boolean found = false;
        Vector v = cp.getQualifiers();
        CIMValue cv = cp.getValue();
        if (cv != null && cv.getValue() instanceof CIMInstance) {
            for (int i = 0; i < v.size(); ++i) {
                CIMQualifier q = (CIMQualifier)v.elementAt(i);
                if (!q.getName().equals(EMBEDDEDOBJECT)) continue;
                found = true;
                break;
            }
            if (!found) {
                CIMQualifier q = new CIMQualifier(EMBEDDEDOBJECT);
                q.setValue(CIMValue.TRUE);
                v.addElement(q);
            }
        }
        return this.stag(PROPERTY) + this.qualifier(v) + this.value(cp) + this.etag();
    }

    String property(Vector p, String name) {
        String refs = "";
        String notrefs = "";
        for (int i = 0; i < p.size(); ++i) {
            CIMProperty cp = (CIMProperty)p.elementAt(i);
            if (cp == null || !this.includeProperty(cp.getName()) || cp.getType() == null) continue;
            if (cp.getType().isReferenceType()) {
                refs = refs + this.propertyReference(cp, name);
                continue;
            }
            notrefs = notrefs + this.property(cp, name);
        }
        return refs + notrefs;
    }

    String property(CIMClass cc) {
        return this.property(cc.getProperties(), cc.getName());
    }

    String property(CIMInstance ci) {
        return this.property(ci.getProperties(), ci.getClassName());
    }

    String propertyArray(CIMProperty cp, String name) {
        StringBuffer Xml = new StringBuffer();
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        Xml.append(this.stag("PROPERTY.ARRAY") + this.qualifier(cp.getQualifiers()));
        if (cp.getValue() != null) {
            Xml.append(this.valueArray(cp.getValue()));
        }
        return Xml.toString() + this.etag();
    }

    String propertyReference(CIMProperty cp, String name) {
        CIMObjectPath cop = new CIMObjectPath(cp.getType().getRefClassName());
        CIMValue cv = cp.getValue();
        if (cv != null) {
            Object cvo = cv.getValue();
            cop = (CIMObjectPath)cvo;
        }
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        this.setClassOrigin(cp);
        this.setPropagated(cp, name);
        return this.stag("PROPERTY.REFERENCE") + this.qualifier(cp) + this.valueReference(cop) + this.etag();
    }

    String method(CIMMethod cm, String name) {
        this.setCIMName(cm);
        this.setCIMType(cm.getType());
        this.setClassOrigin(cm);
        this.setPropagated(cm, name);
        return this.stag(METHOD) + this.qualifier(cm) + this.parameter(cm.getParameters()) + this.etag();
    }

    String method(Vector cms, String name) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cms.size(); ++i) {
            Xml.append(this.method((CIMMethod)cms.elementAt(i), name));
        }
        return Xml.toString();
    }

    String method(CIMClass cc) {
        return this.method(cc.getMethods(), cc.getName());
    }

    String parameter(CIMParameter cp) {
        if (cp.getType() != null && cp.getType().isArrayType()) {
            if (cp.getType().isReferenceType()) {
                return this.parameterRefArray(cp);
            }
            return this.parameterArray(cp);
        }
        if (cp.getType() != null && cp.getType().isReferenceType()) {
            return this.parameterReference(cp);
        }
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        return this.stag(PARAMETER) + this.qualifier(cp) + this.etag();
    }

    String parameter(Vector cp) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < cp.size(); ++i) {
            Xml.append(this.parameter((CIMParameter)cp.elementAt(i)));
        }
        return Xml.toString();
    }

    String parameterReference(CIMParameter cp) {
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        return this.stag("PARAMETER.REFERENCE") + this.qualifier(cp) + this.etag();
    }

    String parameterArray(CIMParameter cp) {
        this.setCIMName(cp);
        this.setCIMType(cp.getType());
        return this.stag("PARAMETER.ARRAY") + this.qualifier(cp) + this.etag();
    }

    String parameterRefArray(CIMParameter cp) {
        this.setCIMName(cp);
        this.setReferenceClass(cp);
        return this.stag("PARAMETER.REFARRAY") + this.qualifier(cp) + this.etag();
    }

    void setError(int code) {
        this.setAttr(CODE, String.valueOf(code));
    }

    void setError(int code, String description) {
        this.setAttr(CODE, String.valueOf(code));
        if (this.getShowImplied()) {
            this.setAttr(DESCRIPTION, description);
        }
    }

    void setId(String cdata) {
        this.setAttr(ID, cdata);
    }

    void setProtocolVersion() {
        this.setAttr(PROTOCOLVERSION, PROTOCOLVERSIONSTRING);
    }

    String message(String body) {
        this.setId(this.getUniqueString());
        this.setProtocolVersion();
        return this.stag("MESSAGE") + body + this.etag();
    }

    String request(String call) {
        return this.stag("SIMPLEREQ") + call + this.etag();
    }

    String request(Vector calls) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < calls.size(); ++i) {
            Xml.append(this.request((String)calls.elementAt(i)));
        }
        if (calls.size() > 1) {
            Xml = new StringBuffer(this.stag("MULTIREQ") + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String exprequest(String call) {
        return this.stag("SIMPLEEXPREQ") + call + this.etag();
    }

    String exprequest(Vector calls) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < calls.size(); ++i) {
            Xml.append(this.exprequest((String)calls.elementAt(i)));
        }
        if (calls.size() > 1) {
            Xml = new StringBuffer(this.stag("MULTIEXPREQ") + Xml.toString() + this.etag());
        }
        return Xml.toString();
    }

    String call(String name, String body) {
        this.setCIMName(name);
        return this.stag("IMETHODCALL") + body + this.etag();
    }

    String expcall(String name, String body) {
        this.setCIMName(name);
        return this.stag("EXPMETHODCALL") + body + this.etag();
    }

    String xcall(String name, String body) {
        this.setCIMName(name);
        return this.stag("METHODCALL") + body + this.etag();
    }

    String paramValue(CIMProperty p) {
        this.setCIMName(p.getName());
        return this.appendValue(p.getValue(), p.getType());
    }

    String paramValue(Vector params) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < params.size(); ++i) {
            Xml.append(this.paramValue((CIMProperty)params.elementAt(i)));
        }
        return Xml.toString();
    }

    protected String paramValue(CIMArgument p) {
        this.setCIMName(p.getName());
        this.setParamType(p.getType());
        return this.appendValue(p.getValue(), p.getType());
    }

    private String appendValue(CIMValue cv, CIMDataType type) {
        if (cv == null || cv.getValue() == null) {
            return this.otag("PARAMVALUE");
        }
        StringBuffer b = new StringBuffer();
        b.append(this.stag("PARAMVALUE"));
        if (type.isArrayType()) {
            b.append(this.value(cv));
        } else if (type.isReferenceType()) {
            b.append(this.valueReference(cv));
        } else {
            b.append(this.value(cv));
        }
        b.append(this.etag("PARAMVALUE"));
        return b.toString();
    }

    protected String paramValue(CIMArgument[] params) {
        StringBuffer Xml = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            Xml.append(this.paramValue(params[i]));
        }
        return Xml.toString();
    }

    protected String iParamValue(String name, String value) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.value(value) + this.etag();
    }

    protected String iParamValue(String name, String[] value) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.value(value) + this.etag();
    }

    protected String iParamValue(String name, boolean b) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.value(b) + this.etag();
    }

    protected String iParamValue(String name, CIMObjectPath cop) {
        this.setCIMName(name);
        return this.stag("IPARAMVALUE") + this.objectName(cop) + this.etag();
    }

    protected String iParamValue(CIMObjectPath cop) {
        Vector keys = cop.getKeys();
        if (keys.size() > 0) {
            this.setCIMName("InstanceName");
        } else {
            this.setCIMName("ClassName");
        }
        return this.stag("IPARAMVALUE") + this.objectName(cop) + this.etag();
    }

    protected String iParamValue(CIMValue cv) {
        this.setCIMName("NewValue");
        return this.stag("IPARAMVALUE") + this.value(cv) + this.etag();
    }

    protected String iParamValue(CIMClass cc, String call) {
        if (call.equals("CreateClass")) {
            this.setCIMName("NewClass");
        } else if (call.equals("ModifyClass")) {
            this.setCIMName("ModifiedClass");
        }
        return this.stag("IPARAMVALUE") + this.cimClass(cc) + this.etag();
    }

    protected String iParamValue(CIMInstance ci) {
        this.setCIMName("NewInstance");
        return this.stag("IPARAMVALUE") + this.instance(ci) + this.etag();
    }

    protected String iParamValue(CIMObjectPath name, CIMInstance ci) {
        this.setCIMName("ModifiedInstance");
        return this.stag("IPARAMVALUE") + this.valueNamedInstance(name, ci) + this.etag();
    }

    protected String iParamValue(CIMQualifierType qt) {
        this.setCIMName("QualifierDeclaration");
        return this.stag("IPARAMVALUE") + this.qualifierDeclaration(qt) + this.etag();
    }

    protected String expParamValue(CIMInstance ci) {
        this.setCIMName(NEWINDICATION);
        return this.stag("EXPPARAMVALUE") + this.instance(ci) + this.etag();
    }

    protected String returnValue(CIMValue cv) {
        this.setParamType(cv.getType());
        return this.stag("RETURNVALUE") + this.value(cv) + this.etag();
    }

    private String getLocalIPAddress() {
        String address = LOOPBACK_ADDRESS;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
            if (address.equals(LOOPBACK_ADDRESS)) {
                try {
                    InetAddress raw_IP = new Socket("www.dmtf.org", 80).getLocalAddress();
                    address = raw_IP.getHostAddress();
                }
                catch (Exception e1) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }
}

