/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.logging.appender;

import com.p6spy.engine.common.P6SpyOptions;
import com.p6spy.engine.logging.appender.FormattedLogger;
import com.p6spy.engine.logging.appender.P6Logger;
import java.util.Date;
import java.util.Vector;

public class EgJdbcMonitor
extends FormattedLogger
implements P6Logger {
    private static long totalJdbcCalls = 0L;
    private static long selects = 0L;
    private static long inserts = 0L;
    private static long updates = 0L;
    private static long deletes = 0L;
    private static long commits = 0L;
    private static long rollbacks = 0L;
    private static long errors = 0L;
    private static long executionThreshold = 0L;
    private static double totalResponseTime = 0.0;
    private static double totalSelectTime = 0.0;
    private static double totalInsertTime = 0.0;
    private static double totalUpdateTime = 0.0;
    private static double totalDeleteTime = 0.0;
    private static double totalCommitTime = 0.0;
    private static double totalRollbackTime = 0.0;
    private static Vector top10Statements = new Vector();
    private static Vector top10Times = new Vector();
    private static int topN = 10;
    private static long minimumTimeFromTheList = 0L;
    private static boolean isDDEnabled = true;

    public static void setExecutionThreshold(long l) {
        executionThreshold = l;
    }

    public static String enableDD(boolean bl) {
        isDDEnabled = bl;
        return "true";
    }

    public String getJdbcStatementStats() {
        EgJdbcMonitor egJdbcMonitor = this;
        synchronized (egJdbcMonitor) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(totalJdbcCalls + " " + totalResponseTime + " ");
            stringBuffer.append(selects + " " + totalSelectTime + " ");
            stringBuffer.append(inserts + " " + totalInsertTime + " ");
            stringBuffer.append(updates + " " + totalUpdateTime + " ");
            stringBuffer.append(deletes + " " + totalDeleteTime + " ");
            stringBuffer.append(commits + " " + totalCommitTime + " ");
            stringBuffer.append(rollbacks + " " + totalRollbackTime + " ");
            stringBuffer.append(errors);
            stringBuffer.append(";");
            int n = top10Statements.size();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.findMaxIndex(top10Times);
                if (n3 < 0) break;
                top10Times.removeElementAt(n3);
                String string = (String)top10Statements.get(n3);
                top10Statements.removeElementAt(n3);
                if (n2 == 0) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append("***");
                    stringBuffer.append(string);
                }
                ++n2;
            }
            totalJdbcCalls = 0L;
            selects = 0L;
            inserts = 0L;
            updates = 0L;
            deletes = 0L;
            commits = 0L;
            rollbacks = 0L;
            totalResponseTime = 0.0;
            totalSelectTime = 0.0;
            totalInsertTime = 0.0;
            totalUpdateTime = 0.0;
            totalDeleteTime = 0.0;
            totalCommitTime = 0.0;
            totalRollbackTime = 0.0;
            errors = 0L;
            top10Statements = new Vector();
            top10Times = new Vector();
            minimumTimeFromTheList = 0L;
            String string = stringBuffer.toString();
            return string;
        }
    }

    private void saveStatementForDD(String string, long l, String string2) {
        String string3 = l + ":$:" + new Date(Long.parseLong(string)).toString() + ":$:" + string2;
        int n = top10Statements.size();
        if (n < topN) {
            top10Statements.add(string3);
            top10Times.add(new Long(l));
            if (n == 0) {
                minimumTimeFromTheList = l;
            } else if (minimumTimeFromTheList > l) {
                minimumTimeFromTheList = l;
            }
            return;
        }
        if (n >= topN && l <= minimumTimeFromTheList) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Long l2 = (Long)top10Times.get(n2);
            long l3 = l2;
            if (l3 <= minimumTimeFromTheList) {
                top10Statements.remove(n2);
                top10Times.remove(n2);
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            top10Statements.add(string3);
            top10Times.add(new Long(l));
            minimumTimeFromTheList = this.findMinTime(top10Times);
        }
    }

    private int findMaxIndex(Vector vector) {
        int n = 0;
        long l = 0L;
        int n2 = 0;
        while (n2 < vector.size()) {
            Long l2 = (Long)vector.get(n2);
            long l3 = l2;
            if (n2 == 0) {
                l = l3;
                n = 0;
            } else if (l < l3) {
                l = l3;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private long findMinTime(Vector vector) {
        long l = 0L;
        int n = 0;
        while (n < vector.size()) {
            Long l2 = (Long)vector.get(n);
            long l3 = l2;
            if (n == 0) {
                l = l3;
            } else if (l > l3) {
                l = l3;
            }
            ++n;
        }
        return l;
    }

    public EgJdbcMonitor() {
        executionThreshold = P6SpyOptions.getExecutionThreshold();
    }

    public void logException(Exception exception) {
    }

    public void logText(String string) {
    }

    public void logSQL(int n, String string, long l, String string2, String string3, String string4) {
        if (string4 == null || string4.length() <= 0 || l < 0L) {
            return;
        }
        EgJdbcMonitor egJdbcMonitor = this;
        synchronized (egJdbcMonitor) {
            ++totalJdbcCalls;
            totalResponseTime += (double)l;
            if (string2.equalsIgnoreCase("statement")) {
                String string5 = string4.toLowerCase().trim();
                if (string5.startsWith("insert")) {
                    ++inserts;
                    totalInsertTime += (double)l;
                } else if (string5.startsWith("update")) {
                    ++updates;
                    totalUpdateTime += (double)l;
                } else if (string5.startsWith("select")) {
                    ++selects;
                    totalSelectTime += (double)l;
                } else if (string5.startsWith("delete")) {
                    ++deletes;
                    totalDeleteTime += (double)l;
                }
            } else if (string2.equalsIgnoreCase("commit")) {
                ++commits;
                totalCommitTime += (double)l;
            } else if (string2.equals("rollback")) {
                ++rollbacks;
                totalRollbackTime += (double)l;
            } else if (string2.equalsIgnoreCase("error")) {
                ++errors;
            }
            if (isDDEnabled && l >= executionThreshold) {
                this.saveStatementForDD(string, l, string4);
            }
        }
    }
}

