/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.Util;
import javax.crypto.ShortBufferException;

final class ISO10126Padding
implements Padding {
    private int blockSize;

    ISO10126Padding(int n) {
        this.blockSize = n;
    }

    @Override
    public void padWithLen(byte[] byArray, int n, int n2) throws ShortBufferException {
        if (byArray == null) {
            return;
        }
        int n3 = Util.Math.addExact(n, n2);
        if (n3 > byArray.length) {
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte by = (byte)(n2 & 0xFF);
        byte[] byArray2 = new byte[n2 - 1];
        SunJCE.RANDOM.nextBytes(byArray2);
        System.arraycopy(byArray2, 0, byArray, n, n2 - 1);
        byArray[n3 - 1] = by;
    }

    @Override
    public int unpad(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return 0;
        }
        int n3 = Util.Math.addExact(n, n2);
        byte by = byArray[n3 - 1];
        int n4 = by & 0xFF;
        if (n4 < 1 || n4 > this.blockSize) {
            return -1;
        }
        int n5 = n3 - n4;
        if (n5 < n) {
            return -1;
        }
        return n5;
    }

    @Override
    public int padLength(int n) {
        int n2 = this.blockSize - n % this.blockSize;
        return n2;
    }
}

