/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.tds.SybTimestamp;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateObject {
    private static final String ZEROS = "0000000000";
    private int _nanos = 0;
    private Calendar _calendar = null;
    private int _baseType = 93;

    public DateObject() throws SQLException {
        this.init(null, null);
    }

    public DateObject(Calendar calendar) throws SQLException {
        this.init(null, calendar);
    }

    public DateObject(Object object) throws SQLException {
        this.init(object, null);
    }

    public DateObject(Object object, int n) throws SQLException {
        this._baseType = n;
        this.init(object, null);
    }

    public DateObject(Object object, Calendar calendar) throws SQLException {
        this.init(object, calendar);
    }

    public DateObject(Object object, Calendar calendar, int n) throws SQLException {
        this._baseType = n;
        this.init(object, calendar);
    }

    public int getNanos() {
        return this._nanos;
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public void setNanos(int n) {
        this._nanos = n;
    }

    public String format(boolean bl, boolean bl2) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._baseType != 92 || bl2) {
            stringBuffer.append(this._calendar.get(1) + "-");
            n = this._calendar.get(2) + 1;
            stringBuffer.append((n < 10 ? "0" : "") + n + "-");
            n = this._calendar.get(5);
            stringBuffer.append((n < 10 ? "0" : "") + n);
        }
        if (this._baseType != 91 || bl2) {
            if (this._baseType != 92 || bl2) {
                stringBuffer.append(" ");
            }
            n = this._calendar.get(11);
            stringBuffer.append((n < 10 ? "0" : "") + n + ":");
            n = this._calendar.get(12);
            stringBuffer.append((n < 10 ? "0" : "") + n + ":");
            n = this._calendar.get(13);
            stringBuffer.append((n < 10 ? "0" : "") + n);
            if (bl || bl2) {
                String string = null;
                if (this._nanos == 0) {
                    string = "0";
                } else {
                    string = Integer.toString(this._nanos);
                    if (string.length() < 9) {
                        string = ZEROS.substring(0, 9 - string.length()) + string;
                    }
                    char[] cArray = new char[string.length()];
                    string.getChars(0, string.length(), cArray, 0);
                    int n2 = 8;
                    while (cArray[n2] == '0') {
                        --n2;
                    }
                    string = new String(cArray, 0, n2 + 1);
                }
                stringBuffer.append("." + string);
            }
        }
        return stringBuffer.toString();
    }

    public SybTimestamp toSybTimestamp() {
        SybTimestamp sybTimestamp = new SybTimestamp(this._calendar.getTime().getTime());
        sybTimestamp.setNanos(this._nanos);
        return sybTimestamp;
    }

    public String toString() {
        String string = this.format(true, false);
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            int n2 = n + 4;
            if (n2 > string.length()) {
                n2 = string.length();
            }
            string = string.substring(0, n2);
        }
        return string;
    }

    private void init(Object object, Calendar calendar) throws SQLException {
        Calendar calendar2 = null;
        calendar2 = calendar != null ? (Calendar)calendar.clone() : Calendar.getInstance();
        if (object != null) {
            this._calendar = Convert.objectToCalendar(object, calendar2);
            if (object instanceof Timestamp) {
                this._nanos = ((Timestamp)object).getNanos();
            } else if (object instanceof Time) {
                int n = this._calendar.get(14);
                this._nanos = n * 1000000;
            }
        } else {
            this._calendar = calendar2;
            this._calendar.clear();
        }
    }
}

