/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class DataFormat
extends Token {
    public static final int MAX_DATAFMT_LENGTH = 136;
    protected String _name;
    protected int _status;
    protected int _usertype;
    protected int _datatype;
    protected int _length;
    protected int _precision;
    protected int _scale;
    protected String _locale;
    protected int _localeLen;
    protected String _tableName;
    protected String _className = null;
    protected int _blobType;
    protected int _classIdLen;
    protected boolean _colStatusBytePresent;
    protected byte[] _nameBytes;
    protected int _nameLen;
    protected TdsInputStream _tdsIn;

    protected DataFormat() {
    }

    public DataFormat(TdsInputStream tdsInputStream) throws IOException {
        this.newDataFormat(tdsInputStream, true);
    }

    public DataFormat(TdsInputStream tdsInputStream, boolean bl) throws IOException {
        this.newDataFormat(tdsInputStream, bl);
    }

    protected void newDataFormat(TdsInputStream tdsInputStream, boolean bl) throws IOException {
        this._tdsIn = tdsInputStream;
        try {
            this.readMetaInfo(tdsInputStream);
            this.readStatus(tdsInputStream);
            this._colStatusBytePresent = (this._status & 8) != 0;
            this._usertype = tdsInputStream.readInt();
            this._datatype = tdsInputStream.readUnsignedByte();
            this._precision = 0;
            this._scale = 0;
            this._length = 0;
            block2 : switch (this._datatype) {
                case 48: 
                case 50: {
                    this._length = 1;
                    break;
                }
                case 52: {
                    this._length = 2;
                    break;
                }
                case 49: 
                case 51: 
                case 56: 
                case 58: 
                case 59: 
                case 122: {
                    this._length = 4;
                    break;
                }
                case 60: 
                case 61: 
                case 62: 
                case 191: {
                    this._length = 8;
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 47: 
                case 103: 
                case 104: 
                case 109: 
                case 110: 
                case 111: 
                case 123: 
                case 147: {
                    this._length = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 106: 
                case 108: {
                    this._length = tdsInputStream.readUnsignedByte();
                    this._precision = tdsInputStream.readUnsignedByte();
                    this._scale = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 175: 
                case 225: {
                    this._length = tdsInputStream.readInt();
                    break;
                }
                case 34: 
                case 35: {
                    this._length = tdsInputStream.readInt();
                    this._tableName = tdsInputStream.readString(tdsInputStream.readUnsignedShort());
                    break;
                }
                case 36: {
                    this._blobType = tdsInputStream.readUnsignedByte();
                    this._classIdLen = tdsInputStream.readShort();
                    switch (this._blobType) {
                        case 1: {
                            this._className = tdsInputStream.readString(this._classIdLen);
                            break block2;
                        }
                        case 3: 
                        case 4: {
                            tdsInputStream.skip(this._classIdLen);
                            break block2;
                        }
                    }
                    tdsInputStream.skip(this._classIdLen);
                    break;
                }
                case 31: 
                case 255: {
                    break;
                }
            }
            if (this._className == null) {
                try {
                    this._className = TdsJdbcInputStream.getObjectClassName(this._datatype, this._usertype, this._blobType, this._length);
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
            }
            if (bl) {
                int n = tdsInputStream.readUnsignedByte();
                this._locale = n > 0 ? tdsInputStream.readString(n) : "";
            }
            switch (this._datatype) {
                case 60: 
                case 110: 
                case 122: {
                    this._scale = 4;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
    }

    public DataFormat(TdsParam tdsParam, TdsOutputStream tdsOutputStream) throws IOException {
        this._nameLen = 0;
        this._name = tdsParam._name;
        if (this._name != null) {
            this._nameLen = this._name.length();
        }
        this._status = tdsParam._inValue == null ? 32 : 0;
        this._status |= tdsParam._regType != -999 ? 1 : 0;
        if (tdsParam._tdos._tds.serverAcceptsColumnStatusByte() && tdsParam._sqlType != -998) {
            this._status |= 8;
            this._colStatusBytePresent = true;
        }
        this._usertype = 0;
        this._locale = null;
        int[] nArray = new int[4];
        ((TdsDataOutputStream)tdsOutputStream).dataTypeInfo(tdsParam, nArray);
        this._datatype = nArray[0];
        switch (this._datatype) {
            case 9217: {
                this._datatype = 36;
                this._blobType = 1;
                this._className = tdsParam._inValue != null ? (tdsParam._outParamClassName != null ? tdsParam._outParamClassName : tdsParam._inValue.getClass().getName()) : (tdsParam._outParamClassName != null ? tdsParam._outParamClassName : "");
                this._classIdLen = this._className.length();
                break;
            }
            case 9220: {
                this._datatype = 36;
                this._blobType = 4;
                break;
            }
            case 9219: {
                this._datatype = 36;
                this._blobType = 3;
                break;
            }
            case 225: {
                if (!tdsParam._parameterHoldsUnicharData) break;
                this._usertype = 35;
                break;
            }
        }
        this._length = DataFormat.maxLength(tdsParam, this._datatype, nArray[1]);
        this._precision = nArray[2];
        this._scale = nArray[3];
    }

    public String getName() {
        if (this._name != null) {
            return this._name;
        }
        if (this._nameLen == 0) {
            this._name = "";
            return this._name;
        }
        try {
            this._name = this._tdsIn.convertBytesToString(this._nameBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._name;
    }

    public int length() {
        int n = 8 + (this._name == null ? 0 : this._name.length()) + DataFormat.lengthSize(this._datatype) + (this._locale == null ? 0 : this._locale.length());
        block0 : switch (this._datatype) {
            case 106: 
            case 108: {
                n += 2;
                break;
            }
            case 36: 
            case 9217: {
                switch (this._blobType) {
                    case 1: 
                    case 3: 
                    case 4: {
                        n += 3 + this._classIdLen;
                        break block0;
                    }
                }
                break;
            }
            case 34: 
            case 35: {
                n += 2 + (this._name == null ? 0 : this._name.length());
            }
        }
        return n;
    }

    protected static int lengthSize(int n) {
        switch (n) {
            case 36: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: 
            case 191: 
            case 9219: 
            case 9220: {
                return 0;
            }
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: {
                return 1;
            }
            case 34: 
            case 35: 
            case 175: 
            case 225: {
                return 4;
            }
            case 31: 
            case 255: {
                break;
            }
        }
        return -1;
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        this.sendMetaInfo(tdsOutputStream);
        this.sendStatus(tdsOutputStream);
        tdsOutputStream.writeInt(this._usertype);
        switch (this._datatype) {
            case 9219: {
                this._blobType = 3;
                tdsOutputStream.writeByte(36);
                break;
            }
            case 9220: {
                this._blobType = 4;
                tdsOutputStream.writeByte(36);
                break;
            }
            default: {
                tdsOutputStream.writeByte(this._datatype);
            }
        }
        block4 : switch (this._datatype) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: 
            case 191: {
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: {
                tdsOutputStream.writeByte(this._length);
                break;
            }
            case 106: 
            case 108: {
                tdsOutputStream.writeByte(this._length);
                tdsOutputStream.writeByte(this._precision);
                tdsOutputStream.writeByte(this._scale);
                break;
            }
            case 175: 
            case 225: {
                tdsOutputStream.writeInt(this._length);
                break;
            }
            case 36: 
            case 9219: 
            case 9220: {
                tdsOutputStream.writeByte(this._blobType);
                switch (this._blobType) {
                    case 1: {
                        byte[] byArray = tdsOutputStream.stringToByte(this._className);
                        if (byArray == null) {
                            tdsOutputStream.writeShort(0);
                            break block4;
                        }
                        tdsOutputStream.writeShort(byArray.length);
                        tdsOutputStream.write(byArray);
                        break block4;
                    }
                    case 3: 
                    case 4: {
                        tdsOutputStream.writeShort(0);
                        break block4;
                    }
                }
                break;
            }
            case 34: 
            case 35: {
                tdsOutputStream.writeInt(this._length);
                byte[] byArray = tdsOutputStream.stringToByte(this._tableName);
                tdsOutputStream.writeShort(byArray.length);
                tdsOutputStream.write(byArray);
                break;
            }
            case 31: 
            case 255: {
                break;
            }
        }
        if (this._locale == null) {
            tdsOutputStream.writeByte(0);
        } else {
            byte[] byArray = tdsOutputStream.stringToByte(this._locale);
            int n = byArray.length > 255 ? 255 : byArray.length;
            tdsOutputStream.writeByte(n);
            tdsOutputStream.write(byArray, 0, n);
        }
    }

    protected static int maxLength(TdsParam tdsParam, int n, int n2) {
        switch (n) {
            case 48: 
            case 50: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 49: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 122: {
                return 4;
            }
            case 60: 
            case 61: 
            case 62: 
            case 191: {
                return 8;
            }
            case 123: 
            case 147: {
                return n2 > 0 ? n2 : 4;
            }
            case 38: {
                if (n2 > 0) {
                    return n2;
                }
                if (tdsParam._sqlType == -5) {
                    return 8;
                }
                return 4;
            }
            case 110: 
            case 111: {
                return n2 > 0 ? n2 : 8;
            }
            case 109: {
                if (n2 > 0) {
                    return n2;
                }
                if (tdsParam._sqlType == 7) {
                    return 4;
                }
                return 8;
            }
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: {
                return 255;
            }
            case 106: 
            case 108: {
                return 54;
            }
            case 34: 
            case 35: 
            case 36: 
            case 175: 
            case 225: 
            case 9219: 
            case 9220: {
                return Integer.MAX_VALUE;
            }
            case 31: 
            case 255: {
                break;
            }
        }
        return 0;
    }

    protected void readMetaInfo(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._nameLen = tdsInputStream.readUnsignedByte();
            if (this._nameLen > 0) {
                this._nameBytes = new byte[this._nameLen];
                tdsInputStream.read(this._nameBytes, 0, this._nameLen);
            }
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
    }

    protected void sendMetaInfo(TdsOutputStream tdsOutputStream) throws IOException {
        byte[] byArray = tdsOutputStream.stringToByte(this._name);
        if (byArray == null) {
            tdsOutputStream.writeByte(0);
        } else {
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
    }

    protected void readStatus(TdsInputStream tdsInputStream) throws IOException {
        this._status = tdsInputStream.readUnsignedByte();
    }

    protected void sendStatus(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(this._status);
    }

    public static String getDataTypeString(int n) {
        switch (n) {
            case 34: {
                return "IMAGE";
            }
            case 35: {
                return "TEXT";
            }
            case 37: {
                return "VARBINARY";
            }
            case 38: {
                return "INTN";
            }
            case 45: {
                return "BINARY";
            }
            case 47: {
                return "CHAR";
            }
            case 50: {
                return "BIT";
            }
            case 61: {
                return "DATETIM";
            }
            case 58: {
                return "SHORTDATE";
            }
            case 111: {
                return "DATETIMN";
            }
            case 49: {
                return "DATE";
            }
            case 123: {
                return "DATEN";
            }
            case 51: {
                return "TIME";
            }
            case 147: {
                return "TIMEN";
            }
            case 106: {
                return "DECN";
            }
            case 59: {
                return "FLT4";
            }
            case 62: {
                return "FLT8";
            }
            case 191: {
                return "INT8";
            }
            case 109: {
                return "FLTN";
            }
            case 48: {
                return "INT1";
            }
            case 52: {
                return "INT2";
            }
            case 56: {
                return "INT4";
            }
            case 225: {
                return "LONGBINARY";
            }
            case 175: {
                return "LONGCHAR";
            }
            case 60: {
                return "MONEY";
            }
            case 122: {
                return "SHORTMONEY";
            }
            case 110: {
                return "MONEYN";
            }
            case 108: {
                return "NUMN";
            }
            case 103: {
                return "SENSITIVITY";
            }
            case 104: {
                return "BOUNDARY";
            }
            case 39: {
                return "VARCHAR";
            }
            case 36: {
                return "BLOB";
            }
            case 31: {
                return "VOID";
            }
            case 255: {
                return "UNKNOWN";
            }
        }
        return "<unrecognized>";
    }

    protected boolean isUnitype() {
        return this._datatype == 225 && (this._usertype == 35 || this._usertype == 34);
    }
}

