/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsDateTime {
    private static final int BASEBIAS = 693595;
    private static final int BASEYEAR = 1;
    private static final int CENTURY_ADJUST = 52;
    private static final int TIMEMASK = 0x1FFFFFF;
    private static final int C300TH_P_HOUR = 1080000;
    private static final int C300TH_P_MIN = 18000;
    private static final int[] MONTHDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LMONTHDAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECS = 5;
    public static final int DATETIME = 1;
    public static final int SMALLDATETIME = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    int[] _timestamp = new int[]{0, 0, 0, 0, 0, 0};
    long _nano = 0L;
    DateObject _dateObj = null;
    int _type = 0;

    public TdsDateTime(int n, int n2, int n3) {
        this._type = n3;
        if (n3 == 1) {
            TdsDateTime.numToYearMonthDay(n, this._timestamp);
            this.convertFourByteTime(n2);
        } else if (n3 == 2) {
            TdsDateTime.numToYearMonthDay(n, this._timestamp);
            this.convertTwoByteTime(n2);
        } else if (n3 == 3) {
            TdsDateTime.numToYearMonthDay(n, this._timestamp);
        } else if (n3 == 4) {
            this.convertFourByteTime(n2);
            this._timestamp[0] = 1970;
            this._timestamp[1] = 0;
            this._timestamp[2] = 1;
        }
    }

    private void convertFourByteTime(int n) {
        this._timestamp[3] = (n &= 0x1FFFFFF) / 1080000;
        this._timestamp[4] = n / 18000 % 60;
        this._timestamp[5] = n / 300 % 60;
        this._nano = (long)n % 300L * 10000000L / 3L;
    }

    private void convertTwoByteTime(int n) {
        this._timestamp[3] = n / 60;
        this._timestamp[4] = n % 60;
    }

    public static int[] tdsDateTime(DateObject dateObject) {
        int[] nArray = new int[2];
        Calendar calendar = dateObject.getCalendar();
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5) - 1;
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        double d = dateObject.getNanos();
        nArray[0] = TdsDateTime.ymdToNum(n, n2, n3);
        int n7 = (int)Math.round(d * 3.0 / 1.0E7);
        nArray[1] = ((n4 * 60 + n5) * 60 + n6) * 300 + n7;
        if (d != 0.0 && n7 == 300) {
            nArray[1] = nArray[1] - 1;
        }
        return nArray;
    }

    public DateObject dateObjectValue() throws SQLException {
        return this.dateObjectValue(null);
    }

    public DateObject dateObjectValue(Calendar calendar) throws SQLException {
        if (this._dateObj == null) {
            this._dateObj = this.convertToDateObject(calendar);
        }
        return this._dateObj;
    }

    public String stringValue() {
        StringBuffer stringBuffer = new StringBuffer(26);
        if (this._type != 4) {
            stringBuffer.append(this._timestamp[0]);
            stringBuffer.append('-');
            if (this._timestamp[1] < 9) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[1] + 1);
            stringBuffer.append('-');
            if (this._timestamp[2] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[2]);
        }
        if (this._type != 3) {
            String string;
            double d = (double)this._nano / 1.0E9;
            if (d == 0.0) {
                string = "0.0";
            } else {
                string = String.valueOf(d);
                if (string.length() > 5) {
                    string = string.substring(0, 5);
                }
            }
            if (this._type != 4) {
                stringBuffer.append(' ');
            }
            if (this._timestamp[3] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[3]);
            stringBuffer.append(':');
            if (this._timestamp[4] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[4]);
            stringBuffer.append(':');
            if (this._timestamp[5] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[5]);
            stringBuffer.append('.');
            stringBuffer.append(string.substring(2));
        }
        return stringBuffer.toString();
    }

    private static void numToYearMonthDay(int n, int[] nArray) {
        int n2;
        int n3;
        int n4 = (n += 693595) / 365;
        while ((n3 = n - (n4 * 365 + (n2 = TdsDateTime.leapcnt(n4)))) < 0) {
            --n4;
        }
        int[] nArray2 = MONTHDAYS;
        if (TdsDateTime.leapyear(n4)) {
            nArray2 = LMONTHDAYS;
        }
        ++n4;
        int n5 = n3;
        int n6 = 0;
        while (n5 >= nArray2[n6]) {
            n5 -= nArray2[n6];
            ++n6;
        }
        nArray[0] = n4;
        nArray[1] = n6;
        nArray[2] = n5 + 1;
    }

    private static int ymdToNum(int n, int n2, int n3) {
        int n4 = --n * 365 + TdsDateTime.leapcnt(n);
        int[] nArray = MONTHDAYS;
        if (TdsDateTime.leapyear(n)) {
            nArray = LMONTHDAYS;
        }
        int n5 = 0;
        while (n5 < n2) {
            n4 += nArray[n5];
            ++n5;
        }
        n4 += n3;
        return n4 -= 693595;
    }

    private static boolean leapyear(int n) {
        boolean bl = ++n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
        return bl;
    }

    private static int leapcnt(int n) {
        int n2 = n / 100;
        int n3 = n / 4 - n2 + n2 / 4;
        return n3;
    }

    private DateObject convertToDateObject(Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        dateObject = new DateObject(calendar);
        Calendar calendar2 = dateObject.getCalendar();
        calendar2.set(1, this._timestamp[0]);
        calendar2.set(2, this._timestamp[1]);
        calendar2.set(5, this._timestamp[2]);
        calendar2.set(11, this._timestamp[3]);
        calendar2.set(12, this._timestamp[4]);
        calendar2.set(13, this._timestamp[5]);
        calendar2.set(14, (int)this._nano / 1000000);
        dateObject.setNanos((int)this._nano);
        return dateObject;
    }
}

