/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.DynamicClassLoader;
import com.sybase.jdbc2.jdbc.DynamicObjectInputStream;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.jdbc.RawToAsciiInputStream;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.jdbc.UnicharToAsciiInputStream;
import com.sybase.jdbc2.jdbc.UnicharToUniInputStream;
import com.sybase.jdbc2.tds.CachedTdsJdbcInputStream;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Cacheable;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsJdbcInputStream
extends TdsDataObject
implements Cacheable {
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_MATH_BIGDECIMAL = "java.math.BigDecimal";
    private static final String JAVA_IO_FILTERINPUTSTREAM = "java.io.FilterInputStream";
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String JAVA_SQL_TIME = "java.sql.Time";
    private static final String JAVA_SQL_DATE = "java.sql.Date";
    private static final int BUFLEN = 512;
    public static final int RAW_TO_ASCII_STREAM = 1;
    public static final int RAW_TO_UNI_STREAM = 2;
    public static final int CHARSET_TO_UNI_STREAM = 3;
    public static final int RAW_STREAM = 4;
    public static final int UNICHAR_TO_UNI_STREAM = 5;
    public static final int UNICHAR_TO_ASCII_STREAM = 6;
    private CacheManager _monitor;
    private RawInputStream _columnInputStream;
    private InputStreamReader _columnInputStreamReader;
    private DynamicClassLoader _classLoader;

    public TdsJdbcInputStream(TdsProtocolContext tdsProtocolContext, Tds tds) throws IOException {
        super(tdsProtocolContext);
        this._classLoader = this._tds.getClassLoader();
    }

    protected TdsDataObject createCachedCopy() throws SQLException, IOException {
        return new CachedTdsJdbcInputStream(this);
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(6) : this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 225: {
                        if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                            this._columnInputStream = this.makeNewRIS(5);
                            String string = null;
                            string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, string);
                        } else {
                            this._columnInputStream = this.makeNewRIS(1);
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        }
                        return this._columnInputStreamReader;
                    }
                }
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return reader;
    }

    public InputStream getUnicodeStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(3);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(5) : this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public InputStream getBinaryStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 4) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        boolean bl = false;
        try {
            block20: {
                try {
                    this.beginRead();
                    if (this._isNull) break block20;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            bigDecimal = new BigDecimal((double)this.readUnsignedByte());
                            break;
                        }
                        case 52: {
                            bigDecimal = new BigDecimal((double)this.readShort());
                            break;
                        }
                        case 56: {
                            bigDecimal = new BigDecimal((double)this.readInt());
                            break;
                        }
                        case 191: {
                            bigDecimal = new BigDecimal((double)this.readLong());
                            break;
                        }
                        case 38: {
                            bigDecimal = new BigDecimal((double)this.readINTN());
                            break;
                        }
                        case 59: {
                            bigDecimal = new BigDecimal(this.readFloat());
                            break;
                        }
                        case 62: {
                            bigDecimal = new BigDecimal(this.readDouble());
                            break;
                        }
                        case 109: {
                            bigDecimal = new BigDecimal(this.readFLTN());
                            break;
                        }
                        case 106: 
                        case 108: {
                            bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            bigDecimal = new BigDecimal(Convert.numString(this.readString()));
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                bigDecimal = new BigDecimal(Convert.numString(this.readUnicodeString()));
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            bigDecimal = this.readMONEYN();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (!bl) break block20;
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var7_5 = null;
                    this.endRead();
                    return Convert.setScale(bigDecimal, n);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var7_6 = null;
                    this.endRead();
                    return Convert.setScale(bigDecimal, n);
                }
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return Convert.setScale(bigDecimal, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            block18: {
                try {
                    this.beginRead();
                    if (this._isNull) break block18;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            bl = 0 != this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            bl = 0 != this.readShort();
                            break;
                        }
                        case 56: {
                            bl = 0 != this.readInt();
                            break;
                        }
                        case 191: {
                            bl = 0L != this.readLong();
                            break;
                        }
                        case 38: {
                            bl = 0L != this.readINTN();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            bl = 0 != bigDecimal.signum();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            bl = 0.0 != this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            bl = 0 != bigDecimal.signum();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            String string = this.readString();
                            bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                String string = this.readUnicodeString();
                                bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                                break;
                            }
                            bl2 = true;
                            break;
                        }
                        default: {
                            bl2 = true;
                        }
                    }
                    if (!bl2) break block18;
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var6_10 = null;
                    this.endRead();
                    return bl;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var6_11 = null;
                    this.endRead();
                    return bl;
                }
            }
            Object var6_9 = null;
            this.endRead();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte getByte() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            block19: {
                try {
                    this.beginRead();
                    if (this._isNull) break block19;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 191: {
                            l = this.readLong();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (bl) {
                        ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                    }
                    Convert.checkByteOflo(l);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var7_4 = null;
                    this.endRead();
                    return (byte)l;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var7_5 = null;
                    this.endRead();
                    return (byte)l;
                }
            }
            Object var7_3 = null;
            this.endRead();
            return (byte)l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public byte[] getBytes() throws SQLException {
        byte[] byArray;
        block11: {
            byArray = null;
            try {
                block10: {
                    this.beginRead();
                    if (this._isNull) break block10;
                    switch (this._dataFmt._datatype) {
                        case 36: {
                            int n;
                            if (this._dataFmt._blobType != 4) {
                                ErrorMessage.raiseError("JZ0TE", "Object");
                            }
                            this._columnInputStream = this.makeNewRIS(4);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            byte[] byArray2 = new byte[512];
                            while ((n = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                                byteArrayOutputStream.write(byArray2, 0, n);
                            }
                            byArray = byteArrayOutputStream.toByteArray();
                            byteArrayOutputStream.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            break;
                        }
                        case 34: 
                        case 37: 
                        case 45: 
                        case 225: {
                            byArray = this.funkyBinaryReader();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "varbinay, long binary, binary, image");
                        }
                    }
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.endRead();
                throw throwable;
            }
            this.endRead();
            {
                break block11;
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var6_7 = null;
                    this.endRead();
                }
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getRawBytes() throws SQLException {
        byte[] byArray = null;
        try {
            block7: {
                try {
                    this.beginRead();
                    if (this._isNull) break block7;
                    this._columnInputStream = this.makeNewRIS(4);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[512];
                    while (true) {
                        int n;
                        if ((n = this._columnInputStream.read(byArray2, 0, 512)) == -1) {
                            byArray = byteArrayOutputStream.toByteArray();
                            byteArrayOutputStream.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            this._dataLength = byArray.length;
                            break;
                        }
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var6_7 = null;
                    this.endRead();
                    return byArray;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return byArray;
    }

    /*
     * Loose catch block
     */
    public TextPointer getTextPtr() throws SQLException {
        byte[] byArray;
        block17: {
            block16: {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 34: 
                        case 35: {
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0R4");
                            break;
                        }
                    }
                    break block16;
                }
                ErrorMessage.raiseError("JZ0R4");
            }
            byArray = null;
            this.endRead();
            try {
                if (this._dataFmt._datatype == 34) {
                    this.funkyBinaryReader();
                    break block17;
                }
                String string = this.readString();
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    byArray = null;
                    this.endRead();
                    try {
                        if (this._dataFmt._datatype == 34) {
                            this.funkyBinaryReader();
                            break block17;
                        }
                        String string = this.readString();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.endRead();
                try {
                    if (this._dataFmt._datatype == 34) {
                        this.funkyBinaryReader();
                    } else {
                        String string = this.readString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        TextPointer textPointer = new TextPointer(this._context);
        byte[] byArray2 = new byte[this._textptrlen];
        byArray = new byte[8];
        System.arraycopy(this._textptr, 0, byArray2, 0, this._textptrlen);
        System.arraycopy(this._textptr, this._textptrlen, byArray, 0, 8);
        textPointer._textPtr = byArray2;
        textPointer._timeStamp = byArray;
        textPointer._tableName = this._dataFmt._tableName;
        textPointer._columnName = this._dataFmt.getName();
        return textPointer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        boolean bl = false;
        try {
            block15: {
                try {
                    this.beginRead();
                    if (this._isNull) break block15;
                    switch (this._dataFmt._datatype) {
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            dateObject = Convert.objectToDateObject(this.readString(), n, calendar);
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                dateObject = Convert.objectToDateObject(this.readUnicodeString(), n, calendar);
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 58: 
                        case 61: 
                        case 111: {
                            dateObject = this.readDATETIMN().dateObjectValue(calendar);
                            break;
                        }
                        case 49: 
                        case 123: {
                            if (n == 92) {
                                ErrorMessage.raiseError("JZ0TI", "date", "time");
                                break;
                            }
                            dateObject = this.readDATEN().dateObjectValue(calendar);
                            break;
                        }
                        case 51: 
                        case 147: {
                            if (n == 91) {
                                ErrorMessage.raiseError("JZ0TI", "time", "date");
                                break;
                            }
                            dateObject = this.readTIMEN().dateObjectValue(calendar);
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (!bl) break block15;
                    ErrorMessage.raiseError("JZ0TE", "char, unichar, varchar, univarchar, text, datetime, short datetime, date, time");
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var8_6 = null;
                    this.endRead();
                    return dateObject;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorMessage.raiseError("JZ009", illegalArgumentException.getMessage());
                    Object var8_7 = null;
                    this.endRead();
                    return dateObject;
                }
            }
            Object var8_5 = null;
            this.endRead();
            return dateObject;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getDouble() throws SQLException {
        double d = 0.0;
        boolean bl = false;
        try {
            block18: {
                try {
                    this.beginRead();
                    if (this._isNull) break block18;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            d = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            d = this.readShort();
                            break;
                        }
                        case 56: {
                            d = this.readInt();
                            break;
                        }
                        case 191: {
                            d = this.readLong();
                            break;
                        }
                        case 38: {
                            d = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            d = this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bigDecimal == null) break;
                            d = bigDecimal.doubleValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            d = Double.valueOf(Convert.numString(this.readString()));
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                d = Double.valueOf(Convert.numString(this.readUnicodeString()));
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            if (bigDecimal == null) break;
                            d = bigDecimal.doubleValue();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (!bl) break block18;
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var7_8 = null;
                    this.endRead();
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var7_9 = null;
                    this.endRead();
                    return d;
                }
            }
            Object var7_7 = null;
            this.endRead();
            return d;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getFloat() throws SQLException {
        float f = 0.0f;
        boolean bl = false;
        try {
            block20: {
                try {
                    this.beginRead();
                    if (this._isNull) break block20;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            f = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            f = this.readShort();
                            break;
                        }
                        case 56: {
                            f = this.readInt();
                            break;
                        }
                        case 191: {
                            f = this.readLong();
                            break;
                        }
                        case 38: {
                            f = this.readINTN();
                            break;
                        }
                        case 59: {
                            f = this.readFloat();
                            break;
                        }
                        case 62: {
                            f = (float)this.readDouble();
                            break;
                        }
                        case 109: {
                            f = (float)this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bigDecimal == null) break;
                            f = bigDecimal.floatValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            f = Float.valueOf(Convert.numString(this.readString())).floatValue();
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                f = Float.valueOf(Convert.numString(this.readUnicodeString())).floatValue();
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            if (bigDecimal == null) break;
                            f = bigDecimal.floatValue();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (!bl) break block20;
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var6_8 = null;
                    this.endRead();
                    return f;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var6_9 = null;
                    this.endRead();
                    return f;
                }
            }
            Object var6_7 = null;
            this.endRead();
            return f;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInt() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            block19: {
                try {
                    this.beginRead();
                    if (this._isNull) break block19;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 191: {
                            l = this.readLong();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (bl) {
                        ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                    }
                    Convert.checkIntOflo(l);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var7_4 = null;
                    this.endRead();
                    return (int)l;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var7_5 = null;
                    this.endRead();
                    return (int)l;
                }
            }
            Object var7_3 = null;
            this.endRead();
            return (int)l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLong() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            block18: {
                try {
                    this.beginRead();
                    if (this._isNull) break block18;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 191: {
                            l = this.readLong();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (!bl) break block18;
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var7_4 = null;
                    this.endRead();
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var7_5 = null;
                    this.endRead();
                    return l;
                }
            }
            Object var7_3 = null;
            this.endRead();
            return l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject() throws SQLException {
        Object object = null;
        try {
            block34: {
                this.beginRead();
                if (this._isNull) break block34;
                block2 : switch (this._dataFmt._datatype) {
                    case 50: {
                        int n = this.readUnsignedByte();
                        object = new Boolean(n != 0);
                        break;
                    }
                    case 48: {
                        object = new Integer((byte)this.readUnsignedByte());
                        break;
                    }
                    case 52: {
                        object = new Integer(this.readShort());
                        break;
                    }
                    case 56: {
                        object = new Integer(this.readInt());
                        break;
                    }
                    case 191: {
                        object = new Long(this.readLong());
                        break;
                    }
                    case 38: {
                        if (this._dataLength <= 4) {
                            object = new Integer((int)this.readINTN());
                            break;
                        }
                        object = new Long(this.readINTN());
                        break;
                    }
                    case 59: {
                        object = new Float(this.readFloat());
                        break;
                    }
                    case 62: 
                    case 109: {
                        if (this._dataLength == 4) {
                            object = new Float(this.readFloat());
                            break;
                        }
                        object = new Double(this.readFLTN());
                        break;
                    }
                    case 106: 
                    case 108: {
                        object = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        break;
                    }
                    case 39: 
                    case 47: {
                        object = this.readString();
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        object = this.readMONEYN();
                        break;
                    }
                    case 37: 
                    case 45: 
                    case 225: {
                        if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                            object = this.readUnicodeString();
                            break;
                        }
                    }
                    case 34: {
                        object = this.funkyBinaryReader();
                        break;
                    }
                    case 35: 
                    case 175: {
                        object = this.readString();
                        break;
                    }
                    case 58: 
                    case 61: 
                    case 111: {
                        object = Convert.objectToTimestamp(this.readDATETIMN().dateObjectValue());
                        break;
                    }
                    case 49: 
                    case 123: {
                        object = Convert.objectToDate(this.readDATEN().dateObjectValue());
                        break;
                    }
                    case 51: 
                    case 147: {
                        object = Convert.objectToTime(this.readTIMEN().dateObjectValue());
                        break;
                    }
                    case 103: 
                    case 104: {
                        byte[] byArray = new byte[this._dataLength];
                        this.in.read(byArray, 0, this._dataLength);
                        object = byArray;
                        break;
                    }
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 1: {
                                object = this.readObject();
                                break block2;
                            }
                            case 3: {
                                this._columnInputStream = this.makeNewRIS(3);
                                object = this._columnInputStream;
                                break block2;
                            }
                            case 4: {
                                this._columnInputStream = this.makeNewRIS(4);
                                object = this._columnInputStream;
                                break block2;
                            }
                        }
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TC");
                    }
                }
            }
            Object var5_6 = null;
            if (this._columnInputStream != null) return object;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (this._columnInputStream != null) throw throwable;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        {
            return object;
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
                Object var5_7 = null;
                if (this._columnInputStream != null) return object;
                this.endRead();
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                Object var5_8 = null;
                if (this._columnInputStream != null) return object;
                this.endRead();
                return object;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getShort() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            block19: {
                try {
                    this.beginRead();
                    if (this._isNull) break block19;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 191: {
                            l = this.readLong();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 225: {
                            if (this._dataFmt.isUnitype()) {
                                l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (bl) {
                        ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, money, short money");
                    }
                    Convert.checkShortOflo(l);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var7_4 = null;
                    this.endRead();
                    return (short)l;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var7_5 = null;
                    this.endRead();
                    return (short)l;
                }
            }
            Object var7_3 = null;
            this.endRead();
            return (short)l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.endRead();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public String getString() throws SQLException {
        String string;
        block38: {
            string = null;
            try {
                block37: {
                    this.beginRead();
                    if (this._isNull) break block37;
                    block2 : switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            string = String.valueOf(this.readUnsignedByte());
                            break;
                        }
                        case 52: {
                            string = String.valueOf(this.readShort());
                            break;
                        }
                        case 56: {
                            string = String.valueOf(this.readInt());
                            break;
                        }
                        case 191: {
                            string = String.valueOf(this.readLong());
                            break;
                        }
                        case 38: {
                            string = String.valueOf(this.readINTN());
                            break;
                        }
                        case 59: {
                            string = String.valueOf(this.readFloat());
                            break;
                        }
                        case 62: {
                            string = String.valueOf(this.readDouble());
                            break;
                        }
                        case 109: {
                            string = String.valueOf(this.readFLTN());
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bigDecimal != null) {
                                string = bigDecimal.toString();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            string = this.readString();
                            break;
                        }
                        case 34: 
                        case 37: 
                        case 45: 
                        case 103: 
                        case 104: {
                            if (this._holds0LNN) {
                                string = "";
                                break;
                            }
                            string = HexConverts.hexConvert(this.funkyBinaryReader());
                            break;
                        }
                        case 225: {
                            if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                                string = this.readUnicodeString();
                                break;
                            }
                            if (this._holds0LNN) {
                                string = "";
                                break;
                            }
                            string = HexConverts.hexConvert(this.funkyBinaryReader());
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            if (bigDecimal != null) {
                                string = bigDecimal.toString();
                            }
                            break;
                        }
                        case 58: 
                        case 61: 
                        case 111: {
                            string = this.readDATETIMN().stringValue();
                            break;
                        }
                        case 49: 
                        case 123: {
                            string = this.readDATEN().stringValue();
                            break;
                        }
                        case 51: 
                        case 147: {
                            string = this.readTIMEN().stringValue();
                            break;
                        }
                        case 36: {
                            switch (this._dataFmt._blobType) {
                                case 1: {
                                    Object object = this.readObject();
                                    if (object == null) {
                                        string = null;
                                        break block2;
                                    }
                                    string = object.toString();
                                    break block2;
                                }
                                case 3: {
                                    int n;
                                    this._columnInputStream = this.makeNewRIS(4);
                                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                                    char[] cArray = new char[512];
                                    StringBuffer stringBuffer = new StringBuffer();
                                    while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                        stringBuffer.append(cArray, 0, n);
                                    }
                                    string = stringBuffer.toString();
                                    inputStreamReader.close();
                                    this._columnInputStream.close();
                                    this._columnInputStream = null;
                                    break block2;
                                }
                                case 4: {
                                    int n;
                                    this._columnInputStream = this.makeNewRIS(4);
                                    byte[] byArray = new byte[512];
                                    StringBuffer stringBuffer = new StringBuffer();
                                    while ((n = this._columnInputStream.read(byArray, 0, 512)) != -1) {
                                        stringBuffer.append(HexConverts.hexConvert(byArray, n));
                                    }
                                    string = stringBuffer.toString();
                                    this._columnInputStream.close();
                                    this._columnInputStream = null;
                                    break block2;
                                }
                            }
                            ErrorMessage.raiseError("JZ0TC");
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                this.endRead();
                throw throwable;
            }
            this.endRead();
            {
                break block38;
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    Object var11_15 = null;
                    this.endRead();
                    break block38;
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                    Object var11_16 = null;
                    this.endRead();
                }
            }
        }
        return string;
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    public void open(boolean bl) {
        this._state = bl ? 2 : 1;
        if (this._context._lastResult == 209) {
            this._context._lastResult = -1;
        }
    }

    public int getState() {
        return this._state;
    }

    public void setManager(CacheManager cacheManager) {
        this._monitor = cacheManager;
    }

    public void cache() throws IOException {
        if (this._state == 3) {
            return;
        }
        if (this._monitor == null) {
            this.startRead();
            if (this._context._rereadable && (this._state == 0 || this._columnInputStream == null)) {
                this.openCacheStream();
            }
        }
        this._state = 2;
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
            } else {
                this._columnInputStream.close();
                this._columnInputStream = null;
            }
            this._state = 3;
            return;
        }
        this.getSize();
        if (this._dataLength == -1 && this._columnInputStream == null) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            this._columnInputStream.cache((CacheStream)this.in);
            this._state = 3;
            this.reset();
            this._columnInputStream = null;
            return;
        }
        byte[] byArray = new byte[512];
        int n = this._dataLength;
        while (n > 0) {
            int n2 = n < 512 ? n : 512;
            this.in.read(byArray, 0, n2);
            n -= n2;
        }
        if (this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
        if (this._monitor != null) {
            this.in.reset();
        }
    }

    public void clear() throws IOException {
        if (this._columnInputStream != null) {
            this._columnInputStream.close();
            this._columnInputStream = null;
        } else {
            switch (this._state) {
                case 0: {
                    if (this._monitor != null) break;
                    this.skipParam();
                    break;
                }
                case 1: {
                    this.skipParam();
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
                case 2: {
                    this.getSize();
                    this.in.skip(this._dataLength);
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                }
            }
        }
        this.initialize();
    }

    private void skipParam() throws IOException {
        this.getSize();
        if (this._dataLength == -1) {
            try {
                try {
                    this._columnInputStream = this.makeNewRIS(4);
                    this._columnInputStream.close();
                }
                catch (SQLException sQLException) {
                    ErrorMessage.raiseIOECheckDead(sQLException);
                    Object var3_2 = null;
                    this._columnInputStream = null;
                }
                Object var3_1 = null;
                this._columnInputStream = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._columnInputStream = null;
                throw throwable;
            }
        } else {
            this.in.skip(this._dataLength);
        }
    }

    public void resetInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this._dataLength != -1 ? this._dataLength : this.in.available();
    }

    public void initialize() {
        super.initialize();
        this._columnInputStream = null;
        if (this.in instanceof CacheStream) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = this._context._in;
        }
    }

    public void reset() throws IOException {
        if (this._state == 3 && !this._isNull) {
            this.in.reset();
            if (this._monitor != null) {
                this._dataLength = -2;
                this.getSize();
            }
        } else {
            ErrorMessage.raiseIOException("JZ0P7");
        }
    }

    protected void beginRead() throws IOException {
        if (this._monitor == null && this._state == 0 && this._prev != null && this._prev._state != 3) {
            this._prev.cache();
        }
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
                this._state = 3;
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        this.getSize();
        if (this._isNull) {
            return;
        }
        if (this._monitor == null) {
            if (this._state == 0) {
                if (this._context._rereadable) {
                    this.openCacheStream();
                }
                this._state = 1;
            }
        } else if (this._state == 0) {
            ErrorMessage.raiseIOException("JZ0R3");
        }
        if (this._state == 3) {
            if (this._context._rereadable) {
                this.reset();
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
    }

    protected void endRead() throws SQLException {
        if (this._state != 3 && this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
    }

    protected RawInputStream makeNewRIS(int n) throws SQLException {
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                try {
                    Object var4_2;
                    try {
                        this._columnInputStream.close();
                        this._state = 3;
                        this.reset();
                    }
                    catch (IOException iOException) {
                        ErrorMessage.raiseErrorCheckDead(iOException);
                        var4_2 = null;
                        this._columnInputStream = null;
                    }
                    var4_2 = null;
                    this._columnInputStream = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this._columnInputStream = null;
                    throw throwable;
                }
            } else {
                ErrorMessage.raiseError("JZ0R3");
            }
        }
        RawInputStream rawInputStream = null;
        CacheManager cacheManager = null;
        int n2 = this._dataLength;
        if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
            n2 = this._dataFmt._length;
        }
        if (this._context._maxFieldSize > 0) {
            n2 = Math.min(n2, this._context._maxFieldSize);
        }
        if (this._state != 3) {
            cacheManager = this._monitor;
            this._state = 1;
        }
        try {
            switch (n) {
                case 4: {
                    rawInputStream = new RawInputStream(this, this._dataLength, n2, cacheManager);
                    break;
                }
                case 1: {
                    rawInputStream = new RawToAsciiInputStream(this, this._dataLength, n2, cacheManager);
                    break;
                }
                case 3: {
                    rawInputStream = new CharsetToUniInputStream(this, this._dataLength, n2, cacheManager, this._tds._charsetName);
                    break;
                }
                case 2: {
                    int n3 = this._dataLength == -1 ? -1 : 2 * this._dataLength;
                    int n4 = n2 == -1 ? -1 : 2 * n2;
                    rawInputStream = new CharsetToUniInputStream(new RawToAsciiInputStream(this, this._dataLength, n2, cacheManager), n3, n4, null, "ISO8859_1");
                    break;
                }
                case 5: {
                    if (this.getBigEndian()) {
                        rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n2, cacheManager, false);
                        break;
                    }
                    rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n2, cacheManager, true);
                    break;
                }
                case 6: {
                    if (n2 != this._dataLength) {
                        n2 = n2 * 2 < this._dataLength ? (n2 *= 2) : this._dataLength;
                    }
                    rawInputStream = new UnicharToAsciiInputStream(this, this._dataLength, n2, this.getBigEndian(), cacheManager);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ0I5", iOException.toString());
        }
        rawInputStream.setCached(this._state == 3);
        return rawInputStream;
    }

    protected static String getObjectClassName(int n, int n2, int n3, int n4) throws SQLException {
        String string = JAVA_LANG_OBJECT;
        switch (n) {
            case 50: {
                string = JAVA_LANG_BOOLEAN;
                break;
            }
            case 48: 
            case 52: 
            case 56: {
                string = JAVA_LANG_INTEGER;
                break;
            }
            case 191: {
                string = JAVA_LANG_LONG;
                break;
            }
            case 38: {
                if (n4 <= 4) {
                    string = JAVA_LANG_INTEGER;
                    break;
                }
                string = JAVA_LANG_LONG;
                break;
            }
            case 59: {
                string = JAVA_LANG_FLOAT;
                break;
            }
            case 62: 
            case 109: {
                if (n4 == 4) {
                    string = JAVA_LANG_FLOAT;
                    break;
                }
                string = JAVA_LANG_DOUBLE;
                break;
            }
            case 35: 
            case 39: 
            case 47: 
            case 175: {
                string = JAVA_LANG_STRING;
                break;
            }
            case 60: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                string = JAVA_MATH_BIGDECIMAL;
                break;
            }
            case 34: 
            case 37: 
            case 45: 
            case 103: 
            case 104: {
                string = new byte[1].getClass().getName();
                break;
            }
            case 225: {
                if (n2 == 34 || n2 == 35) {
                    string = JAVA_LANG_STRING;
                    break;
                }
                string = new byte[1].getClass().getName();
                break;
            }
            case 58: 
            case 61: 
            case 111: {
                string = JAVA_SQL_TIMESTAMP;
                break;
            }
            case 49: 
            case 123: {
                string = JAVA_SQL_DATE;
                break;
            }
            case 51: 
            case 147: {
                string = JAVA_SQL_TIME;
                break;
            }
            case 36: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        string = JAVA_LANG_OBJECT;
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = JAVA_IO_FILTERINPUTSTREAM;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return string;
    }

    private void openCacheStream() {
        this.in = new CacheStream(this._context._cm, this.in, this._context._timeout);
    }

    private Object readObject() throws SQLException {
        Object object = null;
        try {
            this._columnInputStream = this.makeNewRIS(4);
            if (this._columnInputStream.available() > 0) {
                ObjectInputStream objectInputStream = this._classLoader == null ? new ObjectInputStream(this._columnInputStream) : new DynamicObjectInputStream((InputStream)this._columnInputStream, this._classLoader);
                object = objectInputStream.readObject();
                objectInputStream.close();
            } else {
                this._isNull = true;
            }
            this._columnInputStream.close();
            this._columnInputStream = null;
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ010", exception.getMessage());
        }
        return object;
    }
}

