/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import ftp.FtpException;
import ftp.FtpListResult;
import ftp.FtpObserver;
import ftp.FtpReplyResourceBundle;
import ftp.SocketOpener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FtpBean {
    protected static final String FTP_INIT = "FTP_INIT";
    protected static final String CMD_ACCT = "ACCT ";
    protected static final String CMD_APPE = "APPE ";
    protected static final String CMD_CWD = "CWD ";
    protected static final String CMD_CDUP = "CDUP";
    protected static final String CMD_DELE = "DELE ";
    protected static final String CMD_MKD = "MKD ";
    protected static final String CMD_PASV = "PASV";
    protected static final String CMD_PASS = "PASS ";
    protected static final String CMD_PORT = "PORT ";
    protected static final String CMD_PWD = "PWD";
    protected static final String CMD_QUIT = "QUIT";
    protected static final String CMD_RMD = "RMD ";
    protected static final String CMD_REST = "REST ";
    protected static final String CMD_RETR = "RETR ";
    protected static final String CMD_RNTO = "RNTO ";
    protected static final String CMD_RNFR = "RNFR ";
    protected static final String CMD_SITE = "SITE ";
    protected static final String CMD_STOR = "STOR ";
    protected static final String CMD_SYST = "SYST";
    protected static final String CMD_USER = "USER ";
    protected static final String CMD_TYPE = "TYPE ";
    protected static final String CMD_LIST = "LIST";
    protected static final String REPLY_POS_PRE = "1";
    protected static final String REPLY_POS_CMP = "2";
    protected static final String REPLY_POS_INT = "3";
    protected static final String REPLY_TRA_NEG = "4";
    protected static final String REPLY_PER_NEG = "5";
    protected static final String REPLY_UNDEF = "0";
    private final String TF_MOD_ASCII = "A";
    private final String TF_MOD_BIN = "I";
    private final String FTP_ENCODING = "US-ASCII";
    private final FtpReplyResourceBundle ftpReplies = new FtpReplyResourceBundle();
    private String acctInfo = "";
    private String server = "";
    private String user = "";
    private String replymessage = "";
    private String reply = "";
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;
    private int port = 21;
    private boolean passive = true;
    private int timeout;
    private int[] lock = new int[0];
    private boolean acquired = false;
    private Vector thread_spool = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean DEBUG = false;
    public boolean connectSuccess = false;
    public boolean authSuccess = false;
    public double connectTime = -1.0;
    public double authTime = -1.0;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void ftpConnect(String string, String string2) throws IOException, FtpException {
        this.ftpConnect(string, string2, "", "");
    }

    public void ftpConnect(String string, String string2, String string3) throws IOException, FtpException {
        this.ftpConnect(string, string2, string3, "");
    }

    public void ftpConnect(String string, String string2, String string3, String string4) throws IOException, FtpException {
        this.ftpConnect(string, 21, string2, string3, string4);
    }

    public void ftpConnect(String string, int n, String string2, String string3, String string4) throws IOException, FtpException {
        this.port = n;
        this.acquire();
        this.setServerName(string);
        this.setUserName(string2);
        this.setAcctInfo(string4);
        try {
            long l = System.currentTimeMillis();
            this.socket = this.timeout == 0 ? new Socket(string, this.port) : new SocketOpener(string, this.port).makeSocket(this.timeout);
            long l2 = System.currentTimeMillis();
            this.connectSuccess = true;
            this.connectTime = (double)(l2 - l) / 1000.0;
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "US-ASCII"));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), "US-ASCII"), true);
            this.getRespond(FTP_INIT);
            l = System.currentTimeMillis();
            this.ftpLogin(string2, string3, string4);
            l2 = System.currentTimeMillis();
            this.authTime = (double)(l2 - l) / 1000.0;
            this.authSuccess = true;
            Object var11_8 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.release();
            throw throwable;
        }
    }

    public void close() throws IOException, FtpException {
        this.acquire();
        try {
            this.ftpCommand(CMD_QUIT);
            this.closeSocket();
            this.setServerName("");
            this.setUserName("");
            this.setAcctInfo("");
            Object var2_1 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.release();
            throw throwable;
        }
    }

    public void fileDelete(String string) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_DELE, string);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    public void fileRename(String string, String string2) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_RNFR, string);
            this.ftpCommand(CMD_RNTO, string2);
            Object var4_3 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.release();
            throw throwable;
        }
    }

    public String getAsciiFile(String string, String string2) throws IOException, FtpException {
        return this.getAsciiFile(string, string2, (FtpObserver)null);
    }

    public String getAsciiFile(String string, String string2, FtpObserver ftpObserver) throws IOException, FtpException {
        String string3;
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.setTransferType(true);
            string3 = new String(this.getFile(string, 0L, ftpObserver), "US-ASCII");
            Object var6_5 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.release();
            throw throwable;
        }
        string3 = this.changeLineSeparator(string3, "\r\n", string2);
        return string3.toString();
    }

    public void getAsciiFile(String string, String string2, String string3) throws IOException, FtpException {
        this.getAsciiFile(string, string2, string3, null);
    }

    public void getAsciiFile(String string, String string2, String string3, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            int n;
            Socket socket = this.getDataSocket(CMD_RETR, string, 0L);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            byte[] byArray = new byte[1025];
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                if ((char)byArray[n - 1] == '\r') {
                    byArray[n] = (byte)bufferedInputStream.read();
                    if (byArray[n] != -1) {
                        ++n;
                    }
                }
                String string4 = new String(byArray, 0, n, "US-ASCII");
                string4 = this.changeLineSeparator(string4, "\r\n", string3);
                randomAccessFile.writeBytes(string4);
                if (ftpObserver == null) continue;
                ftpObserver.byteRead(n);
            }
            randomAccessFile.close();
            bufferedInputStream.close();
            socket.close();
            this.getRespond(CMD_RETR);
            if (!this.reply.substring(0, 3).equals("226")) {
                throw new FtpException(this.reply);
            }
            Object var13_11 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            this.release();
            throw throwable;
        }
    }

    public void appendAsciiFile(String string, String string2, String string3) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        string2 = this.changeLineSeparator(string2, string3, "\r\n");
        byte[] byArray = string2.getBytes("US-ASCII");
        this.acquire();
        try {
            this.setTransferType(true);
            this.appendFile(string, byArray);
            Object var6_5 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.release();
            throw throwable;
        }
    }

    public void putAsciiFile(String string, String string2, String string3) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        string2 = this.changeLineSeparator(string2, string3, "\r\n");
        byte[] byArray = string2.getBytes("US-ASCII");
        this.acquire();
        try {
            this.setTransferType(true);
            this.putFile(string, byArray, 0L);
            Object var6_5 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.release();
            throw throwable;
        }
    }

    public byte[] getBinaryFile(String string) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        return this.getBinaryFile(string, 0L, null);
    }

    public byte[] getBinaryFile(String string, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        return this.getBinaryFile(string, 0L, ftpObserver);
    }

    public byte[] getBinaryFile(String string, long l) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        return this.getBinaryFile(string, l, null);
    }

    public byte[] getBinaryFile(String string, long l, FtpObserver ftpObserver) throws IOException, FtpException {
        byte[] byArray;
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.setTransferType(false);
            byArray = this.getFile(string, l, ftpObserver);
            Object var7_5 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.release();
            throw throwable;
        }
        return byArray;
    }

    public void getBinaryFile(String string, String string2) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.getBinaryFile(string, string2, 0L, null);
    }

    public void getBinaryFile(String string, String string2, long l) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.getBinaryFile(string, string2, l, null);
    }

    public void getBinaryFile(String string, String string2, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.getBinaryFile(string, string2, 0L, ftpObserver);
    }

    public void getBinaryFile(String string, String string2, long l, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.setTransferType(false);
            Socket socket = null;
            socket = this.getDataSocket(CMD_RETR, string, l);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            randomAccessFile.seek(l);
            this.readData(bufferedInputStream, randomAccessFile, ftpObserver);
            bufferedInputStream.close();
            randomAccessFile.close();
            socket.close();
            this.getRespond(CMD_RETR);
            Object var10_8 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.release();
            throw throwable;
        }
    }

    public void putBinaryFile(String string, byte[] byArray) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(string, byArray, -1L);
    }

    public void putBinaryFile(String string, byte[] byArray, long l) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.setTransferType(false);
            this.putFile(string, byArray, l);
            Object var6_4 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.release();
            throw throwable;
        }
    }

    public void putBinaryFile(String string, String string2) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(string, string2, 0L, null);
    }

    public void putBinaryFile(String string, String string2, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(string, string2, 0L, ftpObserver);
    }

    public void putBinaryFile(String string, String string2, long l) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(string, string2, l, null);
    }

    public void putBinaryFile(String string, String string2, long l, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            Socket socket = null;
            this.setTransferType(false);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            socket = this.getDataSocket(CMD_STOR, string2, l);
            if (l > 0L) {
                randomAccessFile.seek(l);
            }
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.writeData(randomAccessFile, dataOutputStream, ftpObserver);
            randomAccessFile.close();
            dataOutputStream.close();
            this.getRespond(CMD_STOR);
            Object var10_8 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.release();
            throw throwable;
        }
    }

    public void appendBinaryFile(String string) throws IOException, FtpException {
        this.appendBinaryFile(string, string, null);
    }

    public void appendBinaryFile(String string, String string2) throws IOException, FtpException {
        this.appendBinaryFile(string, string2, null);
    }

    public void appendBinaryFile(String string, String string2, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            Socket socket = null;
            this.setTransferType(false);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            socket = this.getDataSocket(CMD_APPE, string2, 0L);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.writeData(randomAccessFile, dataOutputStream, ftpObserver);
            randomAccessFile.close();
            dataOutputStream.close();
            this.getRespond(CMD_APPE);
            Object var8_7 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.release();
            throw throwable;
        }
    }

    public String getDirectory() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_PWD);
            Object var2_1 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.release();
            throw throwable;
        }
        int n = this.reply.indexOf("\"");
        int n2 = this.reply.lastIndexOf("\"");
        return this.reply.substring(n + 1, n2);
    }

    public void setDirectory(String string) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_CWD, string);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    public void toParentDirectory() throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_CDUP);
            Object var2_1 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.release();
            throw throwable;
        }
    }

    public FtpListResult getDirectoryContent() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        String string = this.getDirectoryContentAsString();
        FtpListResult ftpListResult = new FtpListResult();
        ftpListResult.parseList(string, this.getSystemType());
        return ftpListResult;
    }

    public String getDirectoryContentAsString() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Socket socket = null;
        this.acquire();
        try {
            String string;
            socket = this.getDataSocket(CMD_LIST, 0L);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "US-ASCII"));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append("\n");
            }
            bufferedReader.close();
            socket.close();
            this.getRespond(CMD_LIST);
            Object var6_5 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.release();
            throw throwable;
        }
        return stringBuffer.toString();
    }

    public void makeDirectory(String string) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_MKD, string);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    public void removeDirectory(String string) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_RMD, string);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    public void execute(String string) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_SITE, string);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    public String getSystemType() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_SYST);
            Object var2_1 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.release();
            throw throwable;
        }
        return this.reply.substring(4);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.acquire();
        this.pcs.firePropertyChange("port", new Integer(this.port), new Integer(n));
        this.port = n;
        this.release();
    }

    public void setSocketTimeout(int n) throws SocketException {
        this.acquire();
        this.pcs.firePropertyChange("socketTimeout", new Integer(this.timeout), new Integer(n));
        this.timeout = n;
        this.release();
    }

    public int getSocketTimeout() throws SocketException {
        return this.timeout;
    }

    public String getAcctInfo() {
        return this.acctInfo;
    }

    public String getServerName() {
        return this.server;
    }

    public String getUserName() {
        return this.user;
    }

    public String getReply() {
        return this.reply;
    }

    public String getReplyMessage() {
        return this.replymessage;
    }

    public boolean isPassiveModeTransfer() {
        return this.passive;
    }

    public void setPassiveModeTransfer(boolean bl) {
        this.acquire();
        this.pcs.firePropertyChange("passiveModeTransfer", new Boolean(this.passive), new Boolean(bl));
        this.passive = bl;
        this.release();
    }

    private void closeSocket() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    private String getReplyType(String string) {
        if (string == null || string.length() <= 0) {
            return REPLY_UNDEF;
        }
        String string2 = string.substring(0, 1);
        if (!(string2.equals(REPLY_POS_PRE) || string2.equals(REPLY_POS_CMP) || string2.equals(REPLY_POS_INT) || string2.equals(REPLY_TRA_NEG) || string2.equals(REPLY_PER_NEG))) {
            return REPLY_UNDEF;
        }
        return string2;
    }

    private void getRespond(String string) throws IOException, FtpException {
        String string2 = "";
        String string3 = "";
        while (this.checkReply(string2 = this.in.readLine())) {
            string3 = string3.concat(string2).concat("\n");
        }
        this.setReplyMessage(string3);
        this.setReply(string2);
        String string4 = this.getReplyType(this.reply);
        String[] stringArray = null;
        try {
            stringArray = this.ftpReplies.getStringArray(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new FtpException("Valid reply for command '" + string + "' not found in reply resource bundle");
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (string4.equals(stringArray[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new FtpException(this.reply);
        }
    }

    private void ftpLogin(String string, String string2, String string3) throws IOException, FtpException {
        this.ftpCommand(CMD_USER, string);
        if (this.getReplyType(this.reply).equals(REPLY_POS_CMP)) {
            return;
        }
        this.ftpCommand(CMD_PASS, string2);
        if (this.getReplyType(this.reply).equals(REPLY_POS_CMP)) {
            return;
        }
        this.ftpCommand(CMD_ACCT, string3);
    }

    private void ftpCommand(String string) throws IOException, FtpException {
        this.ftpCommand(string, "");
    }

    private void ftpCommand(String string, String string2) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.out.print(string + string2 + "\r\n");
        this.out.flush();
        this.getRespond(string);
    }

    private byte[] getFile(String string, long l, FtpObserver ftpObserver) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        Socket socket = null;
        socket = this.getDataSocket(CMD_RETR, string, l);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        byte[] byArray = this.getBytes(bufferedInputStream, ftpObserver);
        bufferedInputStream.close();
        socket.close();
        this.getRespond(CMD_RETR);
        if (!this.reply.substring(0, 3).equals("226")) {
            throw new FtpException(this.reply);
        }
        return byArray;
    }

    private byte[] getBytes(BufferedInputStream bufferedInputStream, FtpObserver ftpObserver) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            if (ftpObserver == null) continue;
            ftpObserver.byteRead(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void appendFile(String string, byte[] byArray) throws IOException, FtpException {
        Socket socket = null;
        socket = this.getDataSocket(CMD_APPE, string, 0L);
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.close();
        socket.close();
        this.getRespond(CMD_APPE);
    }

    private void putFile(String string, byte[] byArray, long l) throws IOException, FtpException {
        Socket socket = null;
        socket = this.getDataSocket(CMD_STOR, string, l);
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.close();
        socket.close();
        this.getRespond(CMD_STOR);
    }

    private Socket getDataSocket(String string, long l) throws IOException, FtpException {
        return this.getDataSocket(string, "", l);
    }

    private Socket getDataSocket(String string, String string2, long l) throws IOException, FtpException {
        Socket socket = null;
        ServerSocket serverSocket = null;
        if (this.passive) {
            socket = this.getPassiveDataSocket();
        } else {
            serverSocket = this.getActiveDataSocket();
        }
        if (l > 0L) {
            this.ftpCommand(CMD_REST, Long.toString(l));
        }
        this.ftpCommand(string, string2);
        if (!this.passive) {
            socket = serverSocket.accept();
            serverSocket.close();
        }
        return socket;
    }

    private Socket getPassiveDataSocket() throws IOException, FtpException {
        Socket socket = null;
        this.ftpCommand(CMD_PASV);
        String[] stringArray = new String[6];
        this.reply = this.reply.substring(this.reply.indexOf(40) + 1, this.reply.indexOf(41));
        StringTokenizer stringTokenizer = new StringTokenizer(this.reply, ",");
        int n = 0;
        while (n < 6) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string = stringArray[0] + '.' + stringArray[1] + '.' + stringArray[2] + '.' + stringArray[3];
        int n2 = (Integer.parseInt(stringArray[4]) << 8) + Integer.parseInt(stringArray[5]);
        socket = this.timeout == 0 ? new Socket(string, n2) : new SocketOpener(string, n2).makeSocket(this.timeout);
        return socket;
    }

    private ServerSocket getActiveDataSocket() throws IOException, FtpException {
        int[] nArray = new int[6];
        String string = this.socket.getLocalAddress().getHostAddress();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (n < 4) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        ServerSocket serverSocket = new ServerSocket(0);
        int n2 = serverSocket.getLocalPort();
        nArray[4] = (n2 & 0xFF00) >> 8;
        nArray[5] = n2 & 0xFF;
        String string2 = "";
        int n3 = 0;
        while (n3 < nArray.length) {
            string2 = string2.concat(String.valueOf(nArray[n3]));
            if (n3 < nArray.length - 1) {
                string2 = string2.concat(",");
            }
            ++n3;
        }
        this.ftpCommand(CMD_PORT, string2);
        return serverSocket;
    }

    private void setReply(String string) {
        this.pcs.firePropertyChange("reply", this.reply, string);
        this.reply = string;
    }

    private void setReplyMessage(String string) {
        this.pcs.firePropertyChange("replyMessage", this.replymessage, string);
        this.replymessage = string;
    }

    private void setAcctInfo(String string) {
        this.pcs.firePropertyChange("acctInfo", this.acctInfo, string);
        this.acctInfo = string;
    }

    private void setServerName(String string) {
        this.pcs.firePropertyChange("serverName", this.server, string);
        this.server = string;
    }

    private void setUserName(String string) {
        this.pcs.firePropertyChange("userName", this.user, string);
        this.user = string;
    }

    private void setTransferType(boolean bl) throws IOException, FtpException {
        if (bl) {
            this.ftpCommand(CMD_TYPE, "A");
        } else {
            this.ftpCommand(CMD_TYPE, "I");
        }
    }

    private String changeLineSeparator(String string, String string2, String string3) {
        int n;
        if (string2.equals(string3)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        while ((n = string.indexOf(string2)) != -1) {
            stringBuffer.append(string.substring(0, n)).append(string3);
            string = string.substring(n + string2.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private boolean checkReply(String string) {
        if (string == null) {
            return true;
        }
        return string.length() <= 3 || string.charAt(3) != ' ' || !Character.isDigit(string.charAt(0)) || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2));
    }

    private void readData(BufferedInputStream bufferedInputStream, RandomAccessFile randomAccessFile, FtpObserver ftpObserver) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            randomAccessFile.write(byArray, 0, n);
            if (ftpObserver == null) continue;
            ftpObserver.byteRead(n);
        }
    }

    private void writeData(RandomAccessFile randomAccessFile, DataOutputStream dataOutputStream, FtpObserver ftpObserver) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = randomAccessFile.read(byArray)) != -1) {
            dataOutputStream.write(byArray, 0, n);
            if (ftpObserver == null) continue;
            ftpObserver.byteWrite(n);
        }
    }

    private void acquire() {
        Thread thread = Thread.currentThread();
        int[] nArray = this.lock;
        synchronized (nArray) {
            this.thread_spool.addElement(thread);
        }
        try {
            while (this.acquired && !this.thread_spool.elementAt(0).equals(thread)) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.acquired = true;
    }

    private void release() {
        int[] nArray = this.lock;
        synchronized (nArray) {
            this.thread_spool.removeElementAt(0);
        }
        this.acquired = true;
    }
}

