/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import jdk.xml.internal.HashMap;

public class ConstantPoolGen
implements Serializable {
    protected int size = 1024;
    protected Constant[] constants = new Constant[this.size];
    protected int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private static final long serialVersionUID = -4422321281142141817L;
    private HashMap<String, Index> stringTable = new HashMap();
    private HashMap<String, Index> classTable = new HashMap();
    private HashMap<String, Index> utf8Table = new HashMap();
    private HashMap<String, Index> natTable = new HashMap();
    private HashMap<String, Index> cpTable = new HashMap();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("size", Integer.TYPE), new ObjectStreamField("constants", Constant[].class), new ObjectStreamField("index", Integer.TYPE), new ObjectStreamField("string_table", java.util.HashMap.class), new ObjectStreamField("class_table", java.util.HashMap.class), new ObjectStreamField("utf8_table", java.util.HashMap.class), new ObjectStreamField("n_a_t_table", java.util.HashMap.class), new ObjectStreamField("cp_table", java.util.HashMap.class)};

    public ConstantPoolGen(Constant[] cs) {
        if (cs.length > this.size) {
            this.size = cs.length;
            this.constants = new Constant[this.size];
        }
        System.arraycopy(cs, 0, this.constants, 0, cs.length);
        if (cs.length > 0) {
            this.index = cs.length;
        }
        for (int i = 1; i < this.index; ++i) {
            ConstantUtf8 u8;
            Constant s;
            Constant c = this.constants[i];
            if (c instanceof ConstantString) {
                s = (ConstantString)c;
                u8 = (ConstantUtf8)this.constants[((ConstantString)s).getStringIndex()];
                this.stringTable.put(u8.getBytes(), new Index(i));
                continue;
            }
            if (c instanceof ConstantClass) {
                s = (ConstantClass)c;
                u8 = (ConstantUtf8)this.constants[((ConstantClass)s).getNameIndex()];
                this.classTable.put(u8.getBytes(), new Index(i));
                continue;
            }
            if (c instanceof ConstantNameAndType) {
                ConstantNameAndType n = (ConstantNameAndType)c;
                u8 = (ConstantUtf8)this.constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                this.natTable.put(u8.getBytes() + NAT_DELIM + u8_2.getBytes(), new Index(i));
                continue;
            }
            if (c instanceof ConstantUtf8) {
                ConstantUtf8 u = (ConstantUtf8)c;
                this.utf8Table.put(u.getBytes(), new Index(i));
                continue;
            }
            if (!(c instanceof ConstantCP)) continue;
            ConstantCP m = (ConstantCP)c;
            ConstantClass clazz = (ConstantClass)this.constants[m.getClassIndex()];
            ConstantNameAndType n = (ConstantNameAndType)this.constants[m.getNameAndTypeIndex()];
            ConstantUtf8 u82 = (ConstantUtf8)this.constants[clazz.getNameIndex()];
            String class_name = u82.getBytes().replace('/', '.');
            u82 = (ConstantUtf8)this.constants[n.getNameIndex()];
            String method_name = u82.getBytes();
            u82 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
            String signature = u82.getBytes();
            String delim = METHODREF_DELIM;
            if (c instanceof ConstantInterfaceMethodref) {
                delim = IMETHODREF_DELIM;
            } else if (c instanceof ConstantFieldref) {
                delim = FIELDREF_DELIM;
            }
            this.cpTable.put(class_name + delim + method_name + delim + signature, new Index(i));
        }
    }

    public ConstantPoolGen(ConstantPool cp) {
        this(cp.getConstantPool());
    }

    public ConstantPoolGen() {
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] cs = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(cs, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String str) {
        Index index = this.stringTable.get(str);
        return index != null ? index.index : -1;
    }

    public int addString(String str) {
        int ret = this.lookupString(str);
        if (ret != -1) {
            return ret;
        }
        int utf8 = this.addUtf8(str);
        this.adjustSize();
        ConstantString s = new ConstantString(utf8);
        ret = this.index;
        this.constants[this.index++] = s;
        this.stringTable.put(str, new Index(ret));
        return ret;
    }

    public int lookupClass(String str) {
        Index index = this.classTable.get(str.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private int addClass_(String clazz) {
        int ret = this.lookupClass(clazz);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantClass c = new ConstantClass(this.addUtf8(clazz));
        ret = this.index;
        this.constants[this.index++] = c;
        this.classTable.put(clazz, new Index(ret));
        return ret;
    }

    public int addClass(String str) {
        return this.addClass_(str.replace('.', '/'));
    }

    public int addClass(ObjectType type) {
        return this.addClass(type.getClassName());
    }

    public int addArrayClass(ArrayType type) {
        return this.addClass_(type.getSignature());
    }

    public int lookupInteger(int n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger c;
            if (!(this.constants[i] instanceof ConstantInteger) || (c = (ConstantInteger)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int addInteger(int n) {
        int ret = this.lookupInteger(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return ret;
    }

    public int lookupFloat(float n) {
        int bits = Float.floatToIntBits(n);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat c;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((c = (ConstantFloat)this.constants[i]).getBytes()) != bits) continue;
            return i;
        }
        return -1;
    }

    public int addFloat(float n) {
        int ret = this.lookupFloat(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantFloat(n);
        return ret;
    }

    public int lookupUtf8(String n) {
        Index index = this.utf8Table.get(n);
        return index != null ? index.index : -1;
    }

    public int addUtf8(String n) {
        int ret = this.lookupUtf8(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantUtf8(n);
        this.utf8Table.put(n, new Index(ret));
        return ret;
    }

    public int lookupLong(long n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong c;
            if (!(this.constants[i] instanceof ConstantLong) || (c = (ConstantLong)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int addLong(long n) {
        int ret = this.lookupLong(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantLong(n);
        this.index += 2;
        return ret;
    }

    public int lookupDouble(double n) {
        long bits = Double.doubleToLongBits(n);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble c;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((c = (ConstantDouble)this.constants[i]).getBytes()) != bits) continue;
            return i;
        }
        return -1;
    }

    public int addDouble(double n) {
        int ret = this.lookupDouble(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantDouble(n);
        this.index += 2;
        return ret;
    }

    public int lookupNameAndType(String name, String signature) {
        Index index = this.natTable.get(name + NAT_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int addNameAndType(String name, String signature) {
        int ret = this.lookupNameAndType(name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_index = this.addUtf8(name);
        int signature_index = this.addUtf8(signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantNameAndType(name_index, signature_index);
        this.natTable.put(name + NAT_DELIM + signature, new Index(ret));
        return ret;
    }

    public int lookupMethodref(String class_name, String method_name, String signature) {
        Index index = this.cpTable.get(class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupMethodref(MethodGen method) {
        return this.lookupMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int addMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_and_type_index = this.addNameAndType(method_name, signature);
        int class_index = this.addClass(class_name);
        ret = this.index;
        this.constants[this.index++] = new ConstantMethodref(class_index, name_and_type_index);
        this.cpTable.put(class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature, new Index(ret));
        return ret;
    }

    public int addMethodref(MethodGen method) {
        return this.addMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int lookupInterfaceMethodref(String class_name, String method_name, String signature) {
        Index index = this.cpTable.get(class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen method) {
        return this.lookupInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int addInterfaceMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupInterfaceMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(method_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(class_index, name_and_type_index);
        this.cpTable.put(class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature, new Index(ret));
        return ret;
    }

    public int addInterfaceMethodref(MethodGen method) {
        return this.addInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int lookupFieldref(String class_name, String field_name, String signature) {
        Index index = this.cpTable.get(class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int addFieldref(String class_name, String field_name, String signature) {
        int ret = this.lookupFieldref(class_name, field_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(field_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantFieldref(class_index, name_and_type_index);
        this.cpTable.put(class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature, new Index(ret));
        return ret;
    }

    public Constant getConstant(int i) {
        return this.constants[i];
    }

    public void setConstant(int i, Constant c) {
        this.constants[i] = c;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] cs = new Constant[this.index];
        System.arraycopy(this.constants, 0, cs, 0, this.index);
        return new ConstantPool(cs);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < this.index; ++i) {
            buf.append(i + ")" + this.constants[i] + "\n");
        }
        return buf.toString();
    }

    public int addConstant(Constant c, ConstantPoolGen cp) {
        Constant[] constants = cp.getConstantPool().getConstantPool();
        switch (c.getTag()) {
            case 8: {
                ConstantString s = (ConstantString)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s.getStringIndex()];
                return this.addString(u8.getBytes());
            }
            case 7: {
                ConstantClass s = (ConstantClass)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s.getNameIndex()];
                return this.addClass(u8.getBytes());
            }
            case 12: {
                ConstantNameAndType n = (ConstantNameAndType)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)constants[n.getSignatureIndex()];
                return this.addNameAndType(u8.getBytes(), u8_2.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)c).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)c).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)c).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)c).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)c).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP m = (ConstantCP)c;
                ConstantClass clazz = (ConstantClass)constants[m.getClassIndex()];
                ConstantNameAndType n = (ConstantNameAndType)constants[m.getNameAndTypeIndex()];
                ConstantUtf8 u8 = (ConstantUtf8)constants[clazz.getNameIndex()];
                String class_name = u8.getBytes().replace('/', '.');
                u8 = (ConstantUtf8)constants[n.getNameIndex()];
                String name = u8.getBytes();
                u8 = (ConstantUtf8)constants[n.getSignatureIndex()];
                String signature = u8.getBytes();
                switch (c.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(class_name, name, signature);
                    }
                    case 10: {
                        return this.addMethodref(class_name, name, signature);
                    }
                    case 9: {
                        return this.addFieldref(class_name, name, signature);
                    }
                }
                throw new RuntimeException("Unknown constant type " + c);
            }
        }
        throw new RuntimeException("Unknown constant type " + c);
    }

    private java.util.HashMap<String, Index> createCompatibleHashMap(HashMap<String, Index> input) {
        java.util.HashMap<String, Index> compatibleHashMap = new java.util.HashMap<String, Index>();
        if (input != null) {
            compatibleHashMap.putAll(input);
        }
        return compatibleHashMap;
    }

    private HashMap<String, Index> createJaxpHashMap(java.util.HashMap<String, Index> input) {
        HashMap<String, Index> jaxpHashMap = new HashMap<String, Index>();
        if (input != null) {
            jaxpHashMap.putAll(input);
        }
        return jaxpHashMap;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        java.util.HashMap<String, Index> string_table = this.createCompatibleHashMap(this.stringTable);
        java.util.HashMap<String, Index> class_table = this.createCompatibleHashMap(this.classTable);
        java.util.HashMap<String, Index> utf8_table = this.createCompatibleHashMap(this.utf8Table);
        java.util.HashMap<String, Index> n_a_t_table = this.createCompatibleHashMap(this.natTable);
        java.util.HashMap<String, Index> cp_table = this.createCompatibleHashMap(this.cpTable);
        ObjectOutputStream.PutField pf = out.putFields();
        pf.put("size", this.size);
        pf.put("constants", this.constants);
        pf.put("index", this.index);
        pf.put("string_table", string_table);
        pf.put("class_table", class_table);
        pf.put("utf8_table", utf8_table);
        pf.put("n_a_t_table", n_a_t_table);
        pf.put("cp_table", cp_table);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        this.size = gf.get("size", 1024);
        this.constants = (Constant[])gf.get("constants", null);
        if (this.constants == null) {
            this.constants = new Constant[this.size];
        }
        this.index = gf.get("index", 1);
        this.stringTable = this.createJaxpHashMap((java.util.HashMap)gf.get("string_table", null));
        this.classTable = this.createJaxpHashMap((java.util.HashMap)gf.get("class_table", null));
        this.utf8Table = this.createJaxpHashMap((java.util.HashMap)gf.get("utf8_table", null));
        this.natTable = this.createJaxpHashMap((java.util.HashMap)gf.get("n_a_t_table", null));
        this.cpTable = this.createJaxpHashMap((java.util.HashMap)gf.get("cp_table", null));
    }

    private static class Index
    implements Serializable {
        int index;

        Index(int i) {
            this.index = i;
        }
    }
}

