/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xalan.internal.utils.FactoryImpl;
import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import com.sun.org.apache.xalan.internal.utils.XMLSecurityManager;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jdk.xml.internal.HashMap;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderManager {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static final String property = "org.xml.sax.driver";
    private static SAXParserFactory m_parserFactory;
    private ThreadLocal m_readers;
    private HashMap m_inUse;
    private boolean m_useServicesMechanism = true;
    private boolean _secureProcessing;
    private String _accessExternalDTD = "all";
    private XMLSecurityManager _xmlSecurityManager;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance(boolean useServicesMechanism) {
        m_singletonManager.setServicesMechnism(useServicesMechanism);
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader() throws SAXException {
        XMLReader reader;
        if (this.m_readers == null) {
            this.m_readers = new ThreadLocal();
        }
        if (this.m_inUse == null) {
            this.m_inUse = new HashMap();
        }
        boolean threadHasReader = (reader = (XMLReader)this.m_readers.get()) != null;
        String factory = SecuritySupport.getSystemProperty(property);
        if (threadHasReader && this.m_inUse.get(reader) != Boolean.TRUE && (factory == null || reader.getClass().getName().equals(factory))) {
            this.m_inUse.put(reader, Boolean.TRUE);
        } else {
            try {
                try {
                    reader = XMLReaderFactory.createXMLReader();
                    try {
                        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this._secureProcessing);
                    }
                    catch (SAXNotRecognizedException e) {
                        XMLSecurityManager.printWarning(reader.getClass().getName(), "http://javax.xml.XMLConstants/feature/secure-processing", e);
                    }
                }
                catch (Exception e) {
                    if (m_parserFactory == null) {
                        m_parserFactory = FactoryImpl.getSAXFactory(this.m_useServicesMechanism);
                        m_parserFactory.setNamespaceAware(true);
                    }
                    reader = m_parserFactory.newSAXParser().getXMLReader();
                }
                try {
                    reader.setFeature(NAMESPACES_FEATURE, true);
                    reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                }
                catch (SAXException e) {}
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException(ex);
            }
            catch (FactoryConfigurationError ex1) {
                throw new SAXException(ex1.toString());
            }
            catch (NoSuchMethodError ex1) {
            }
            catch (AbstractMethodError ex1) {
                // empty catch block
            }
            if (!threadHasReader) {
                this.m_readers.set(reader);
                this.m_inUse.put(reader, Boolean.TRUE);
            }
        }
        try {
            reader.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", this._accessExternalDTD);
        }
        catch (SAXException se) {
            XMLSecurityManager.printWarning(reader.getClass().getName(), "http://javax.xml.XMLConstants/property/accessExternalDTD", se);
        }
        String lastProperty = "";
        try {
            if (this._xmlSecurityManager != null) {
                for (XMLSecurityManager.Limit limit : XMLSecurityManager.Limit.values()) {
                    lastProperty = limit.apiProperty();
                    reader.setProperty(lastProperty, this._xmlSecurityManager.getLimitValueAsString(limit));
                }
                if (this._xmlSecurityManager.printEntityCountInfo()) {
                    lastProperty = "http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo";
                    reader.setProperty("http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo", "yes");
                }
            }
        }
        catch (SAXException se) {
            XMLSecurityManager.printWarning(reader.getClass().getName(), lastProperty, se);
        }
        return reader;
    }

    public synchronized void releaseXMLReader(XMLReader reader) {
        if (this.m_readers.get() == reader && reader != null) {
            this.m_inUse.remove(reader);
        }
    }

    public boolean useServicesMechnism() {
        return this.m_useServicesMechanism;
    }

    public void setServicesMechnism(boolean flag) {
        this.m_useServicesMechanism = flag;
    }

    public void setFeature(String name, boolean value) {
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this._secureProcessing = value;
        }
    }

    public Object getProperty(String name) {
        if (name.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            return this._accessExternalDTD;
        }
        if (name.equals("http://apache.org/xml/properties/security-manager")) {
            return this._xmlSecurityManager;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            this._accessExternalDTD = (String)value;
        } else if (name.equals("http://apache.org/xml/properties/security-manager")) {
            this._xmlSecurityManager = (XMLSecurityManager)value;
        }
    }
}

