/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private static final String[] onedigit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final short value;
    public static final int SIZE = 16;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short n) {
        boolean bl;
        int n2;
        int n3 = n;
        if (n3 >= 0) {
            n2 = 1;
            bl = false;
        } else {
            n2 = 2;
            bl = true;
            n3 = -n3;
        }
        int n4 = 10;
        while (n3 >= n4) {
            ++n2;
            n4 = (n4 << 3) + (n4 << 1);
        }
        int n5 = 48;
        if (n2 == 1) {
            return onedigit[n3];
        }
        char[] cArray = new char[n2];
        if (bl) {
            cArray[0] = 45;
        }
        int n6 = n2;
        do {
            n4 = n3 * 52429 >>> 19;
            cArray[--n6] = (char)(n3 - ((n4 << 3) + (n4 << 1)) + n5);
        } while ((n3 = n4) != 0);
        return new String(0, n2, cArray);
    }

    public static short parseShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n);
        }
        return (short)n2;
    }

    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    public static Short valueOf(String string, int n) throws NumberFormatException {
        return Short.parseShort(string, n);
    }

    public static Short valueOf(String string) throws NumberFormatException {
        return Short.valueOf(string, 10);
    }

    public static Short valueOf(short s) {
        short s2 = s;
        if (s2 >= -128 && s2 <= 127) {
            return ShortCache.cache[s2 + 128];
        }
        return new Short(s);
    }

    public static Short decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + n + " out of range from input " + string);
        }
        return (short)n;
    }

    public Short(short s) {
        this.value = s;
    }

    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Short) {
            return this.value == (Short)object;
        }
        return false;
    }

    @Override
    public int compareTo(Short s) {
        return Short.compare(this.value, s.value);
    }

    public static int compare(short s, short s2) {
        return s - s2;
    }

    public static short reverseBytes(short s) {
        return (short)((s & 0xFF00) >> 8 | s << 8);
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new Short((short)(i - 128));
            }
        }
    }
}

