/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import sun.misc.SharedSecrets;

public class HashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public HashSet() {
        this.map = new HashMap();
    }

    public HashSet(Collection<? extends E> collection) {
        this.map = new HashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public HashSet(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public HashSet(int n) {
        this.map = new HashMap(n);
    }

    HashSet(int n, float f, boolean bl) {
        this.map = new LinkedHashMap<E, Object>(n, f);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            HashSet hashSet = (HashSet)super.clone();
            hashSet.map = (HashMap)this.map.clone();
            return hashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map.capacity());
        objectOutputStream.writeFloat(this.map.loadFactor());
        objectOutputStream.writeInt(this.map.size());
        for (E e : this.map.keySet()) {
            objectOutputStream.writeObject(e);
        }
    }

    private static int roundUpToPowerOf2(int n) {
        return n >= 0x40000000 ? 0x40000000 : (n > 1 ? Integer.highestOneBit(n - 1 << 1) : 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        float f = objectInputStream.readFloat();
        int n2 = objectInputStream.readInt();
        n = (int)Math.min((float)n2 * Math.min(1.0f / f, 4.0f), 1.0737418E9f);
        SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Map.Entry[].class, HashSet.roundUpToPowerOf2(n));
        this.map = this instanceof LinkedHashSet ? new LinkedHashMap(n, f) : new HashMap(n, f);
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
        }
    }
}

