/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import sun.misc.ObjectInputFilter;
import sun.rmi.registry.RegistryImpl;

public class SingleEntryRegistry
extends RegistryImpl {
    private final String name;
    private final Remote object;
    private static final long serialVersionUID = -4897238949499730950L;

    SingleEntryRegistry(int n, String string, Remote remote) throws RemoteException {
        super(n);
        this.name = string;
        this.object = remote;
    }

    SingleEntryRegistry(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory, String string, Remote remote) throws RemoteException {
        super(n, rMIClientSocketFactory, rMIServerSocketFactory, new ObjectInputFilter(){

            @Override
            public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
                return SingleEntryRegistry.singleRegistryFilter(filterInfo);
            }
        });
        this.name = string;
        this.object = remote;
    }

    @Override
    public String[] list() {
        return new String[]{this.name};
    }

    @Override
    public Remote lookup(String string) throws NotBoundException {
        if (string.equals(this.name)) {
            return this.object;
        }
        throw new NotBoundException("Not bound: \"" + string + "\" (only " + "bound name is \"" + this.name + "\")");
    }

    @Override
    public void bind(String string, Remote remote) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    @Override
    public void rebind(String string, Remote remote) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    @Override
    public void unbind(String string) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    private static ObjectInputFilter.Status singleRegistryFilter(ObjectInputFilter.FilterInfo filterInfo) {
        return filterInfo.serialClass() != null || filterInfo.depth() > 2L || filterInfo.references() > 4L || filterInfo.arrayLength() >= 0L ? ObjectInputFilter.Status.REJECTED : ObjectInputFilter.Status.ALLOWED;
    }
}

