/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.nio.ch.DevPoll;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.Util;

final class DevPollPort
extends Port {
    private static final int MAX_EPOLL_EVENTS = 512;
    private static final int ENOENT = 2;
    private final int epfd;
    private boolean closed;
    private final int[] sp;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private final long address;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);

    DevPollPort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.epfd = DevPoll.devPollOpen();
        this.address = DevPoll.allocatePollArray(512);
        int[] nArray = new int[2];
        try {
            DevPollPort.socketpair(nArray);
            DevPoll.devPollWrite(this.epfd, nArray[0], 1);
        }
        catch (IOException iOException) {
            DevPollPort.close0(this.epfd);
            throw iOException;
        }
        this.sp = nArray;
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    DevPollPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        DevPollPort devPollPort = this;
        synchronized (devPollPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        DevPoll.freePollArray(this.address);
        DevPollPort.close0(this.sp[0]);
        DevPollPort.close0(this.sp[1]);
        DevPollPort.close0(this.epfd);
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            try {
                DevPollPort.interrupt(this.sp[1]);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        DevPollPort devPollPort = this;
        synchronized (devPollPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                this.wakeup();
            }
        }
    }

    @Override
    void startPoll(int n, int n2) {
        int n3 = DevPoll.devPollWrite(this.epfd, n, n2);
        if (n3 < 0) {
            throw new AssertionError();
        }
    }

    private static native void socketpair(int[] var0) throws IOException;

    private static native void interrupt(int var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$900(DevPollPort devPollPort) {
        devPollPort.implClose();
    }

    static {
        Util.load();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block10: while (true) {
                    int n = DevPoll.devPollioctl(DevPollPort.this.epfd, DevPollPort.this.address, 512);
                    DevPollPort.this.fdToChannelLock.readLock().lock();
                    try {
                        boolean bl = false;
                        while (true) {
                            Object object;
                            if (n-- <= 0) continue block10;
                            long l = DevPoll.getEvent(DevPollPort.this.address, n);
                            int n2 = DevPoll.getDescriptor(l);
                            if (n2 == DevPollPort.this.sp[0]) {
                                if (DevPollPort.this.wakeupCount.decrementAndGet() == 0) {
                                    DevPollPort.drain1(DevPollPort.this.sp[0]);
                                }
                                if (n <= 0) {
                                    object = DevPollPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                    return object;
                                }
                                DevPollPort.this.queue.offer(DevPollPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                continue;
                            }
                            object = (Port.PollableChannel)DevPollPort.this.fdToChannel.get(n2);
                            if (object == null) continue;
                            int n3 = DevPoll.getEvents(l);
                            Event event = new Event((Port.PollableChannel)object, n3);
                            if (n <= 0) {
                                Event event2 = event;
                                return event2;
                            }
                            DevPollPort.this.queue.offer(event);
                        }
                    }
                    finally {
                        DevPollPort.this.fdToChannelLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                DevPollPort.this.queue.offer(DevPollPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel pollableChannel, int n) {
            this.channel = pollableChannel;
            this.events = n;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }
}

