/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.hp.jvm.Intrinsics;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;

class ISO_8859_1
extends Charset
implements HistoricallyNamedCharset {
    public ISO_8859_1() {
        super("ISO-8859-1", StandardCharsets.aliases_ISO_8859_1);
    }

    @Override
    public String historicalName() {
        return "ISO8859_1";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private byte repl = (byte)63;

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u00ff';
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = n2 - n <= n4 - n3 ? n2 - n : n4 - n3;
            Intrinsics.prefetch(cArray, n + n5 - 1 << 1, 0);
            Intrinsics.prefetch(byArray, n3 + n5 - 1, 1);
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    char c = cArray[n];
                    if (c <= '\u00ff') {
                        if (n3 >= n4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)c;
                        continue;
                    }
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (c <= '\u00ff') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        ++n;
                        continue;
                    }
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = 0;
            int n4 = n + Math.min(n2, byArray.length);
            while (n < n4) {
                char c;
                if ((c = cArray[n++]) <= '\u00ff') {
                    byArray[n3++] = (byte)c;
                    continue;
                }
                if (Character.isHighSurrogate(c) && n < n4 && Character.isLowSurrogate(cArray[n])) {
                    if (n2 > byArray.length) {
                        ++n4;
                        --n2;
                    }
                    ++n;
                }
                byArray[n3++] = this.repl;
            }
            return n3;
        }
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    byte by = byArray[n];
                    if (n3 >= n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = (char)(by & 0xFF);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)(by & 0xFF));
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            if (n2 > cArray.length) {
                n2 = cArray.length;
            }
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3++] = (char)(byArray[n++] & 0xFF);
            }
            return n3;
        }
    }
}

