'use strict'

var semver = require('semver')
var shimmer = require('../shimmer')
var logger = require('../../logger')
var appendMsg = 'Cassandra :'
module.exports = function (cassandra, agent, version, enabled) {

    if (!semver.satisfies(version, '>=1.2.3')) {
        logger.debug(appendMsg,'version ', version, ' not supported')
        return cassandra
    } else {
        logger.debug(appendMsg,'version ', version, ' is supported')
    }

    if (!enabled) return cassandra

    var proto = cassandra.Client.prototype

    logger.debug(appendMsg, 'wrapping cassandra._innerExecute')

    shimmer.wrap(proto, '_innerExecute', function wrapQuery(original) {

        return function wrappedQuery(sql, values, cb) {
            var span = agent.buildSpan()
            var id = span && span.transaction.id
            var hasCallback = false

            logger.debug(appendMsg, 'new cassandra exec call  :  ', {
                id: id
            })

            if (span) {
                span.name = 'cassendra db  exec call'
                span.type = 'cassandra'
                
                var len = arguments.length -1
                var cbfn = arguments[len]

                if (typeof cbfn  === 'function') {
                     arguments[len] = wrapCallback(cbfn)
                }else{
                    span.start()
                }

                var params = {}
                params.host = this.options && this.options.contactPoints ? this.options.contactPoints.toString() : ""
                params.port = 9042 //Setting defau;t port
                params.dbName = this.keyspace
                params.resTime = ''
                params.serverType = 'cassandra'
                params.error = ''
                params.nodeOrder = ''
                params.query = arguments[0];
                span.options = params;
            }

            var result = original.apply(this, arguments)

            if (span && result && !hasCallback) {
                result.then(function () {
                    span.end()
                })
            }

            return result

            function wrapCallback(cb) {
                hasCallback = true
                span.start()
                return function wrappedCallback(err) {

                    //Capture error 
                    if (err) {
                        span.options.error = err.toString();
                        if (err.stack) span.options.error = JSON.stringify(err.stack)
                    }
                    span.end()
                    return cb.apply(this, arguments)
                }
            }
        }
    })

     logger.debug(appendMsg, 'wrapping cassandra.batch')
    shimmer.wrap(proto, 'batch', function wrapBatch(original) {
        return function wrappedBatchQuery(sql, values, cb) {
            var span = agent.buildSpan()
            var id = span && span.transaction.id
            var hasCallback = false

            logger.debug(appendMsg, 'new cassandra batch call  :  ', {
                id: id
            })

            if (span) {
                span.name = 'cassendra db batch call'
                span.type = 'cassandra'

                var len = arguments.length -1
                var cbfn = arguments[len]

                if (typeof cbfn  === 'function') {
                     arguments[len] = wrapCallback(cbfn)
                }else{
                    span.start()
                }

                var params = {}
                params.host = this.options && this.options.contactPoints ? this.options.contactPoints.toString()  : ""
                params.port = 9042 //Setting default port
                params.dbName = this.keyspace
                params.resTime = ''
                params.serverType = 'cassandra'
                params.error = ''
                params.nodeOrder = ''
                params.query = arguments[0][0].query + " : batch query";
                span.options = params;
            }

            var result = original.apply(this, arguments)

            if (span && result && !hasCallback) {

                result.then(function () {
                    span.end()
                })
            }

            return result

            function wrapCallback(cb) {
                hasCallback = true
                span.start()
                return function wrappedCallback(err) {

                    //Capture error 
                    if (err) {
                        span.options.error = err.toString();
                        if (err.stack) span.options.error = JSON.stringify(err.stack)
                    }
                    span.end()
                    return cb.apply(this, arguments)
                }
            }
        }
    })

    return cassandra
}