'use strict'

var semver = require('semver')

var shimmer = require('../shimmer')
var log = require('../../logger')
var appendMsg = 'Generic-Pool :'
module.exports = function (generic, agent, version) {
  if (semver.satisfies(version, '^2.0.0')) {
    log.debug(appendMsg, 'wrapping generic-pool.Pool')
    shimmer.wrap(generic, 'Pool', function (orig) {
      return function wrappedPool () {
        var trans = agent._instrumentation.currentTransaction
        var id = trans && trans.id
        log.debug(appendMsg, 'intercepted call to generic-pool.Pool %o', { id: id })

        var pool
        if (this instanceof generic.Pool) {
          var args = [].slice.call(arguments)
          args.unshift(null)
          pool = new (Function.prototype.bind.apply(orig, args))()
        } else {
          pool = orig.apply(this, arguments)
        }

        shimmer.wrap(pool, 'acquire', function (orig) {
          return function wrappedAcquire () {
            var trans = agent._instrumentation.currentTransaction
            var id = trans && trans.id
            log.debug(appendMsg, 'intercepted call to pool.acquire %o', { id: id })

            var cb = arguments[0]
            if (typeof cb === 'function') {
              arguments[0] = agent._instrumentation.bindFunction(cb)
            }

            return orig.apply(this, arguments)
          }
        })

        return pool
      }
    })
  } else if (semver.satisfies(version, '^3.1.0') && generic.PriorityQueue) {

    log.debug(appendMsg, 'wrapping generic-pool.PriorityQueue.prototype.enqueue')
    shimmer.wrap(generic.PriorityQueue.prototype, 'enqueue', function (orig) {
      return function wrappedEnqueue () {
        var trans = agent._instrumentation.currentTransaction
        var id = trans && trans.id
        log.debug(appendMsg, 'intercepted call to generic-pool.PriorityQueue.prototype.enqueue', { id: id })

        var obj = arguments[0]
        // Expect obj to of type Deferred
        if (obj._resolve && obj._reject) {
          obj._resolve = agent._instrumentation.bindFunction(obj._resolve)
          obj._reject = agent._instrumentation.bindFunction(obj._reject)
        }

        return orig.apply(this, arguments)
      }
    })
  } else {
    log.debug(appendMsg, 'generic-pool version : ',version,' not supported - aborting...')
  }

  return generic
}
