'use strict'

var semver = require('semver')

var shimmer = require('../shimmer')

var spanSym = Symbol('egAPMSpan')
var logger = require('../../logger')
var appendMsg = 'IO-redis :'

module.exports = function (ioredis, agent, version, enabled) {
  if (!semver.satisfies(version, '>=2.0.0 <5.0.0')) {
    logger.debug(appendMsg, 'version is not supported - aborting...', version)
    return ioredis
  } else {
    logger.debug(appendMsg,'version is supported -V ', version)
  }

  logger.debug(appendMsg,'shimming ioredis.Command.prototype.initPromise')
  shimmer.wrap(ioredis.Command && ioredis.Command.prototype, 'initPromise', wrapInitPromise)

  if (!enabled) return ioredis

  logger.debug(appendMsg,'shimming ioredis.prototype.sendCommand')
  shimmer.wrap(ioredis.prototype, 'sendCommand', wrapSendCommand)

  return ioredis

  function wrapInitPromise(original) {
    return function wrappedInitPromise() {
      var command = this
      var cb = this.callback

      if (typeof cb === 'function') {
        this.callback = agent._instrumentation.bindFunction(function wrappedCallback() {
          var span = command[spanSym]
          if (span && !span.ended) span.end()
          return cb.apply(this, arguments)
        })
      }

      return original.apply(this, arguments)
    }
  }

  function wrapSendCommand(original) {
    return function wrappedSendCommand(command) {
      var span = agent.buildSpan()
      var id = span && span.transaction.id

      logger.debug(appendMsg,'intercepted call to ioredis.prototype.sendCommand %o', {
        id: id,
        command: command && command.name
      })

      if (span && command) {

        command[spanSym] = span

        var db_name = this.options.db || '0'

        span.options = {
          host: this.options.host || '',
          port: this.options.port || '',
          resTime: '',
          nodeOrder: '',
          error: '',
          serverType: 'redis',
          command: db_name + '#' + command.name
        }

        if (typeof command.resolve === 'function') {
          command.resolve = agent._instrumentation.bindFunction(command.resolve)
        }
        if (typeof command.reject === 'function') {
          command.reject = agent._instrumentation.bindFunction(command.reject)
        }
        if (command.promise) {
          const endSpan = function () {
            if (!span.ended) span.end()
          }

          if (typeof command.promise.finally === 'function') {
            command.promise.finally(endSpan)
          } else if (typeof command.promise.then === 'function') {
            command.promise.then(endSpan).catch(endSpan)
          }
        }

        span.start(String(command.name).toUpperCase(), 'redis')
      }

      return original.apply(this, arguments)
    }
  }
}
