'use strict'

var shimmer = require('../shimmer')
var symbols = require('../../symbols')
var logger = require('../../logger')
var appendMsg = 'Knex :'
module.exports = function (Knex, agent, version, enabled) {
  if (!enabled) return Knex
  if (Knex.Client && Knex.Client.prototype) {
    var QUERY_FNS = ['queryBuilder', 'raw']
    loggerdebug(appendMsg ,'wrapping Knex.Client.prototype.runner')
    shimmer.wrap(Knex.Client.prototype, 'runner', wrapRunner)
    logger.debug(appendMsg ,'wrapping Knex.Client.prototype functions:', QUERY_FNS)
    shimmer.massWrap(Knex.Client.prototype, QUERY_FNS, wrapQueryStartPoint)
  } else {
    logger.debug(appendMsg ,'could not shim Knex')
  }

  function wrapQueryStartPoint (original) {
    return function wrappedQueryStartPoint () {
      var builder = original.apply(this, arguments)

      logger.debug(appendMsg ,'capturing custom stack trace for knex')
      var obj = {}
      Error.captureStackTrace(obj)
      builder[symbols.knexStackObj] = obj

      return builder
    }
  }

  function wrapRunner (original) {
    return function wrappedRunner () {
      var runner = original.apply(this, arguments)

      logger.debug(appendMsg ,'wrapping knex runner.query')
      shimmer.wrap(runner, 'query', wrapQuery)

      return runner
    }
  }

  function wrapQuery (original) {
    return function wrappedQuery () {
      logger.debug(appendMsg ,'intercepted call to knex runner.query')
      if (this.connection) {
        this.connection[symbols.knexStackObj] = this.builder ? this.builder[symbols.knexStackObj] : null
      }
      return original.apply(this, arguments)
    }
  }

  return Knex
}
