'use strict'

/**
 * This file is extracted from the 'shimmer' project copyright by Forrest L
 * Norvell. It have been modified slightly to be used in the current context.
 *
 * https://github.com/othiym23/shimmer
 *
 * Original file:
 *
 * https://github.com/othiym23/shimmer/blob/master/index.js
 *
 * License:
 *
 * BSD-2-Clause, http://opensource.org/licenses/BSD-2-Clause
 */

var symbols = require('../symbols')

var isWrappedSym = Symbol('egAPMIsWrapped')
var log = require('../logger')
var appendMsg = 'Shimmer :'
exports.wrap = wrap
exports.massWrap = massWrap
exports.unwrap = unwrap
exports.isWrapped = isWrapped

// Do not load agent until used to avoid circular dependency issues.
var _agent
function logger () {
  if (!_agent) _agent = require('../../')
  return _agent.logger
}

function isFunction (funktion) {
  return funktion && {}.toString.call(funktion) === '[object Function]'
}

function wrap (nodule, name, wrapper) {
  if (!nodule || !nodule[name]) {
    log.debug(appendMsg, 'no original function %s to wrap', name)
    return
  }

  if (!wrapper) {
    log.debug(appendMsg, 'no wrapper function')
    log.debug(appendMsg, (new Error()).stack)
    return
  }

  if (!isFunction(nodule[name]) || !isFunction(wrapper)) {
    log.debug(appendMsg,'original object and wrapper must be functions')
    return
  }

  if (nodule[name][isWrappedSym]) {
    log.debug(appendMsg,'function already wrapped name : ', name)
    return
  }

  var desc = Object.getOwnPropertyDescriptor(nodule, name)
  if (desc && !desc.writable) {
    log.debug(appendMsg,'function is not writable', name)
    return
  }

  var original = nodule[name]
  var wrapped = wrapper(original, name)

  wrapped[isWrappedSym] = true
  wrapped[symbols.unwrap] = function egAPMUnwrap () {
    if (nodule[name] === wrapped) {
      nodule[name] = original
      wrapped[isWrappedSym] = false
    }
  }

  nodule[name] = wrapped

  return wrapped
}

function massWrap (nodules, names, wrapper) {
  if (!nodules) {
    log.debug(appendMsg,'must provide one or more modules to patch')
    log.debug((new Error()).stack)
    return
  } else if (!Array.isArray(nodules)) {
    nodules = [nodules]
  }

  if (!(names && Array.isArray(names))) {
    log.debug(appendMsg,'must provide one or more functions to wrap on modules')
    return
  }

  nodules.forEach(function (nodule) {
    names.forEach(function (name) {
      wrap(nodule, name, wrapper)
    })
  })
}

function unwrap (nodule, name) {
  if (!nodule || !nodule[name]) {
    log.debug(appendMsg,'no function to unwrap.')
    log.debug((new Error()).stack)
    return
  }

  if (!nodule[name][symbols.unwrap]) {
    log.debug(appendMsg,'no original to unwrap to -- has %s already been unwrapped?', name)
  } else {
    return nodule[name][symbols.unwrap]()
  }
}

function isWrapped (wrapped) {
  return wrapped && wrapped[isWrappedSym]
}
