'use strict'
var path = require('path'),
fs = require('fs'); 

var BTM_PATH = __dirname + '/../logs/btm.log'
var STARTUP_PATH = __dirname + '/../logs/startup.log'

var logger = {};

//Always winston libray is exists beacuse we bundle default npm lib with source

try {
  logger = require('winston');
  logger.libExists = true;
} catch (e) {

  console.log(Date(), 'ERROR:  winston npm library is missing in EG-NODE-MONITOR, so install winston NPM', e)
  logger.libExists = false;

  var levels = ['error', 'warn', 'info', 'verbose', 'debug', 'silly']

  levels.forEach(function (level) {
    logger[level] = function(){ }
      //console.log.bind(console);
  })

}


function init(logPath) {

  if (!logger.libExists) return;
  ensureDirectoryExistence(logPath);
  
  if (!fs.existsSync(path)) {
    createFile(logPath, '');
  }
  try {

    logger.configure({
      transports: [
        //Always comment this line production env
        // new(logger.transports.Console)({
        //   timestamp: getTimeStamp,
        //   json: false,
        //   colorize: true
        // }),
        new(logger.transports.File)({
          filename: logPath,
          json: false,
          timestamp: getTimeStamp,
          name: 'file',
          maxsize: 3000000
        })
      ]
    });

    logger.info('Log path =>', logPath)

  } catch (e) {
    //Note:-Hide the console 
    console.log('Logger init', e)
  }
}


//Level : error,warn,info,verbose,debug 
var setLevel = function (level) {
  logger.level = level;
}

function setDirectory(dir) {
  init(BTM_PATH)
}

if (logger.libExists) {
  init(STARTUP_PATH);
}


logger.setLevel = setLevel;
logger.setDirectory = setDirectory;

function ensureDirectoryExistence(filePath) {
  var dirname = path.dirname(filePath);
  if (fs.existsSync(dirname)) {
    return true;
  }
  ensureDirectoryExistence(dirname);
  fs.mkdirSync(dirname);
}

function createFile(filePath, content){
  fs.writeFile(filePath, content, function(err){
    if(err){
      console.error('Logger file not able to create', err);
    }
  });
}

function format(num) {
  return (num < 10 ? '0' : '') + num;
};

function getTimeStamp() {
  var now = new Date();

  return format(now.getDate()) +
    '/' + format(now.getMonth() + 1) +
    '/' + now.getFullYear() +
    ' ' + format(now.getHours()) +
    ':' + format(now.getMinutes()) +
    ':' + format(now.getSeconds()) +
    ':' + format(now.getMilliseconds())
};

module.exports = logger;
