'use strict'

/**
 * copied from open source
 * https://www.npmjs.com/package/shimmer
 * 
 * This file is extracted from the 'shimmer' project copyright by Forrest L
 * Norvell. It have been modified slightly to be used in the current context.
 *
 * https://github.com/othiym23/shimmer
 *
 * Original file:
 *
 * https://github.com/othiym23/shimmer/blob/master/index.js
 *
 * License:
 *
 * BSD-2-Clause, http://opensource.org/licenses/BSD-2-Clause
 * 
 */

var log = require('../../../logger')
var tag = 'Shimmer: '
 
exports.wrap = wrap
exports.massWrap = massWrap
exports.unwrap = unwrap

function isFunction (funktion) {
  return funktion && {}.toString.call(funktion) === '[object Function]'
}

function wrap (nodule, name, wrapper) {
  if (!nodule || !nodule[name]) {
    log.debug(tag +'no original function %s to wrap', name)
    return
  }

  if (!wrapper) {
    log.error(tag +'no wrapper function')
    log.error(tag +(new Error()).stack)
    return
  }

  if (!isFunction(nodule[name]) || !isFunction(wrapper)) {
    log.debug(tag +'original object and wrapper must be functions')
    return
  }

  if (nodule[name].__obWrapped) {
    log.debug(tag +'function %s already wrapped', name)
    return
  }

  var original = nodule[name]
  var wrapped = wrapper(original, name)

  wrapped.__obWrapped = true
  wrapped.__obUnwrap = function __obUnwrap () {
    if (nodule[name] === wrapped) {
      nodule[name] = original
      wrapped.__obWrapped = false
    }
  }

  nodule[name] = wrapped

  return wrapped
}

function massWrap (nodules, names, wrapper) {
  if (!nodules) {
    log.error(tag +'must provide one or more modules to patch')
    log.error(tag +(new Error()).stack)
    return
  } else if (!Array.isArray(nodules)) {
    nodules = [nodules]
  }

  if (!(names && Array.isArray(names))) {
    log.error(tag +'must provide one or more functions to wrap on modules')
    return
  }

  nodules.forEach(function (nodule) {
    names.forEach(function (name) {
      wrap(nodule, name, wrapper)
    })
  })
}

function unwrap (nodule, name) {
  if (!nodule || !nodule[name]) {
    log.error(tag +'no function to unwrap.')
    log.error(tag +(new Error()).stack)
    return
  }

  if (!nodule[name].__obUnwrap) {
    log.error(tag +'no original to unwrap to -- has %s already been unwrapped?', name)
  } else {
    return nodule[name].__obUnwrap()
  }
}
