'use strict'
var log = require('../../../logger')
var shimmer = require('./shimmer')
var appendMsg = 'core-crypto :'
function wrapCrypto(agent) {

    var crypto = require('crypto')

    var methods = [
        'pbkdf2',
        'randomBytes',
        'pseudoRandomBytes',
        'randomFill',
        'scrypt'
    ]


    shimmer.massWrap(
        crypto,
        methods,
        activator
    );

    function activator(orig, name) {

        return function () {
            console.log(appendMsg, 'crypto name', name)
           var span = agent.buildSpan();
    
            if (!span) {
               // log.debug("crypto : span is null :", name)
                return orig.apply(this, arguments);
            }
    
            var index = arguments.length - 1;
            
            var cbName = ''
    
            if (typeof arguments[index] === 'function') {
                cbName = arguments[index].name || 'anonymous'
                arguments[index] = wrapCallback(arguments[index])
            }
    
            var res = orig.apply(this, arguments)
    
            var fileName = 'unknown'
    
    
            span.start('', 'crypto:' + name)
            span.cbName = cbName;
    
            return res;
    
            function wrapCallback(cb) {
    
                return function wrappedCallback() {
                   span.end()
                    return cb.apply(this, arguments)
                }
            }
        }
    }
    log.info(appendMsg, "wrapped FS module")
}


module.exports = wrapCrypto;