'use strict'
var log = require('../../../logger')
var shimmer = require('./shimmer')
var appendMsg = 'core-fs :'
function wrapFS(agent) {

    var fs = require('fs');
    var methods = [
        'watch',
        'rename',
        'truncate',
        'chown',
        'fchown',
        'chmod',
        'fchmod',
        'stat',
        'lstat',
        'fstat',
        'link',
        'symlink',
        'readlink',
        'realpath',
        'unlink',
        'rmdir',
        'mkdir',
        'readdir',
        'close',
        'open',
        'utimes',
        'futimes',
        'fsync',
        'write',
        'read',
        'readFile',
        'writeFile',
        'appendFile',
        'watchFile',
        'unwatchFile',
        'exists'
    ]

    shimmer.massWrap(
        fs,
        methods,
        activator
    );

    function activator(orig, name) {

        return function () {
         
            var span = agent.buildSpan();

            if (!span) {
                log.debug(appendMsg, "FS : span is null :", name)
                return orig.apply(this, arguments);
            }

            var index = arguments.length - 1;
            
            var cbName = ''

            if (typeof arguments[index] === 'function') {
                cbName = arguments[index].name || 'anonymous'
                arguments[index] = wrapCallback(arguments[index])
            }

            var res = orig.apply(this, arguments)

            var fileName = 'unknown'

            if (typeof arguments[0] === 'string' || typeof arguments[0] === 'number') {
                fileName = arguments[0].toString()
            } 

            span.start(fileName, 'FS:' + name)
            span.cbName = cbName;

            return res;

            function wrapCallback(cb) {

                return function wrappedCallback() {
                    span.end()
                    return cb.apply(this, arguments)
                }
            }
        }
    }

    log.info(appendMsg, "wrapped FS module")
}


module.exports = wrapFS;