'use strict'

var httpShared = require('../http-shared')
var shimmer = require('../shimmer')
var log = require('../../logger')
var appendMsg = 'Http:' 

module.exports = function (http, agent, version, enabled) {
  if (!enabled) return http
  log.debug(appendMsg,'wrapping http.Server.prototype.emit function')
  shimmer.wrap(http && http.Server && http.Server.prototype, 'emit', httpShared.instrumentRequest(agent, 'http'))

  log.debug(appendMsg,'wrapping http.request function')
  shimmer.wrap(http, 'request', httpShared.traceOutgoingRequest(agent, 'http'))

  log.debug(appendMsg,'wrapping http.ServerResponse.prototype.writeHead function')
  shimmer.wrap(http && http.ServerResponse && http.ServerResponse.prototype, 'writeHead', wrapWriteHead)

  return http

  function wrapWriteHead (original) {
    return function wrappedWriteHead () {
      var headers = arguments.length === 1
        ? this._headers // might be because of implicit headers
        : arguments[arguments.length - 1]

      var result = original.apply(this, arguments)

      var trans = httpShared.transactionForResponse.get(this)
      if (trans) {
        httpShared.transactionForResponse.delete(this)

        // It shouldn't be possible for the statusCode to be falsy, but just in
        // case we're in a bad state we should avoid throwing
        trans.result =  this.statusCode 

        // End transacton early in case of SSE
        if (headers && typeof headers === 'object' && !Array.isArray(headers)) {
          Object.keys(headers).some(function (key) {
            if (key.toLowerCase() !== 'content-type') return false
            if (String(headers[key]).toLowerCase().indexOf('text/event-stream') !== 0) return false
            log.debug(appendMsg,'detected SSE response - ending transaction %o', { id: trans.id })
            agent.endTransaction()
            return true
          })
        }
      }

      return result
    }
  }
}
