'use strict'

var semver = require('semver')

var shimmer = require('../shimmer')
var logger = require('../../logger')
var  appendMsg = 'Mysql :'

module.exports = function (mysql, agent, version, enabled) {
  if (!semver.satisfies(version, '^2.0.0')) {
    logger.debug(appendMsg , 'version ', version, ' not supported')
    return mysql
  } else {
    logger.debug(appendMsg ,'version ', version, ' is supported')
  }

  logger.debug(appendMsg ,'wrapping mysql.createPool')
  shimmer.wrap(mysql, 'createPool', wrapCreatePool)

  logger.debug(appendMsg ,'wrapping mysql.createPoolCluster')
  shimmer.wrap(mysql, 'createPoolCluster', wrapCreatePoolCluster)

  if (!enabled) return mysql

  logger.debug(appendMsg ,'wrapping mysql.createConnection')
  shimmer.wrap(mysql, 'createConnection', wrapCreateConnection)

  return mysql

  function wrapCreateConnection(original) {
    return function wrappedCreateConnection() {
      var connection = original.apply(this, arguments)

      wrapQueryable(connection, 'connection', agent)

      return connection
    }
  }

  function wrapCreatePool(original) {
    return function wrappedCreatePool() {
      var pool = original.apply(this, arguments)

      logger.debug(appendMsg ,'wrapping mysql pool.getConnection')
      shimmer.wrap(pool, 'getConnection', wrapGetConnection)

      return pool
    }
  }

  function wrapCreatePoolCluster(original) {
    return function wrappedCreatePoolCluster() {
      var cluster = original.apply(this, arguments)

      logger.debug(appendMsg ,'wrapping mysql cluster.of')
      shimmer.wrap(cluster, 'of', function wrapOf(original) {
        return function wrappedOf() {
          var ofCluster = original.apply(this, arguments)

          logger.debug(appendMsg ,'wrapping mysql cluster of.getConnection')
          shimmer.wrap(ofCluster, 'getConnection', wrapGetConnection)

          return ofCluster
        }
      })

      return cluster
    }
  }

  function wrapGetConnection(original) {
    return function wrappedGetConnection() {
      var cb = arguments[0]

      if (typeof cb === 'function') {
        arguments[0] = agent._instrumentation.bindFunction(function wrapedCallback(err, connection) { // eslint-disable-line handle-callback-err
          if (connection && enabled) wrapQueryable(connection, 'getConnection() > connection', agent)
          return cb.apply(this, arguments)
        })
      }

      return original.apply(this, arguments)
    }
  }
}


/**
  number of ways to query in Mysql library
  query(query, CB)   ('SELECT * FROM `books` WHERE `author` = "David"',  CB)
  query(query, value, CB)  ('SELECT * FROM `books` WHERE `author` = ?', ['David'], CB) 
  query(Object,CB)  ({sql: 'SELECT * FROM `books` WHERE `author` = ?',values: ['David']}, CB)
  query(Object,CB)  ({sql: 'SELECT * FROM `books` WHERE `author` = ?'}, ['David'], CB)

  For mysql pool the callback is passed via  _callback: [Function], 
 */

function wrapQueryable(obj, objType, agent) {
  logger.debug(appendMsg, 'wrapping mysql', objType, 'query()', )
  shimmer.wrap(obj, 'query', wrapQuery)

  function wrapQuery(original) {
    return function wrappedQuery(sql, values, cb) {
      var span = agent.buildSpan()
      var id = span && span.transaction.id
      var hasCallback = false
      var sqlStr

      logger.debug(appendMsg ,'new mysql query call:' + objType + '.query() : ', {
        id: id
      })

      if (span) {
        span.type = 'mysql'

        switch (typeof sql) {
          case 'string':
            sqlStr = sql
            break
          case 'object':
            if (typeof sql._callback === 'function') {
              sql._callback = wrapCallback(sql._callback)
            }
            sqlStr = sql.sql
            break
          case 'function':
            arguments[0] = wrapCallback(sql)
            break
        }

        if (sqlStr) {
          logger.debug(appendMsg ,'mysql query statement', {
            sql: sqlStr,
            id: id
          })
          span.name = sqlStr
        }

        if (typeof values === 'function') {
          arguments[1] = wrapCallback(values)
        } else if (typeof cb === 'function') {
          arguments[2] = wrapCallback(cb)
        }

        var params = getParameters(this);

        if (sqlStr) params.query = sqlStr;

        span.options = params;

      }

      var result = original.apply(this, arguments)

      //If callback not found we need use emitter to end span
      //Note:- this is for if the call back is not found then we need to use the emit function

      if (span && result && !hasCallback) {
        shimmer.wrap(result, 'emit', function (original) {
          return function (event) {
            span.start()
            switch (event) {
              case 'error':
              case 'end':
                span.end()
            }
            return original.apply(this, arguments)
          }
        })
      }

      return result

      function wrapCallback(cb) {
        hasCallback = true
        span.start()
        return function wrappedCallback(err) {

          //Capture error 
          if (err) {
            span.options.error = err.toString();
            if (err.stack) span.options.error = JSON.stringify(err.stack)
          }
          span.end()
          return cb.apply(this, arguments)
        }
      }
    }
  }


  /**
 * Note:- need to test this in UNIX platform 
 * So that we can go with confidence
 * 
 * Mostly in two variables connection object is exists .config OR connectionConfig
 * 
 * Note:- 
 * 
 *If its unix system it will connected with name => obj.socketPath
 Now Im skipping to implement this...

 database_name : nodejs
 host 192.168.8.246
 port : 3306
 Instance  192.168.8.246:3306

 */
  function getParameters(sqlObj) {

    var params = {}
    /**
      host: '',
              port: '',
              databaseName: '',
              resTime: '',
              serverType: 'oracle | mysql |  ms'
              query: '',
              'error': '',
              nodeOrder: '-',
     */
    //connectionConfig
    if (sqlObj.config) {
      params.host = sqlObj.config.host
      params.port = sqlObj.config.port
      params.dbName = sqlObj.config.database
      params.resTime = ''
      params.serverType = 'mysql'
      params.error = '',
        params.nodeOrder = ''
    }

    return params;
  }

}